/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.tasks.core;

public class CommentQuoter {
    public static final int DEFAULT_WRAP_SIZE = 80;
    private int lineSize;

    public CommentQuoter() {
        this(80);
    }

    public CommentQuoter(int lineSize) {
        this.lineSize = lineSize;
    }

    public String quote(String text) {
        String[] lines;
        StringBuilder sb = new StringBuilder(text.length() + text.length() / this.lineSize);
        String[] stringArray = lines = text.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().equals("")) {
                sb.append("> \n");
            } else {
                int pos = 0;
                while (pos < line.length()) {
                    int wrapPos = pos + this.lineSize;
                    if (wrapPos < line.length()) {
                        while (wrapPos > pos) {
                            char wrapChar = line.charAt(wrapPos);
                            if (Character.isSpaceChar(wrapChar)) break;
                            --wrapPos;
                        }
                        if (wrapPos == pos) {
                            wrapPos = pos + this.lineSize;
                            while (wrapPos < line.length()) {
                                if (Character.isSpaceChar(line.charAt(wrapPos))) break;
                                ++wrapPos;
                            }
                        }
                        String wrappedLine = line.substring(pos, wrapPos).trim();
                        sb.append("> " + wrappedLine + "\n");
                        pos = wrapPos + 1;
                        continue;
                    }
                    sb.append("> " + line.substring(pos).trim() + "\n");
                    break;
                }
            }
            ++n2;
        }
        return sb.toString();
    }
}

