/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.tasks.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.core.OfflineDataStore;
import org.eclipse.mylar.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylar.tasks.core.RepositoryTaskData;
import org.eclipse.mylar.tasks.core.TaskRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataManager {
    private static final String OFFLINE_REPORTS = "offlineReports";
    private static final int SAVE_INTERVAL = 60000;
    private File primaryFile;
    private File backupFile;
    private OfflineDataStore dataStore;
    private TaskDataSaverJob saverJob;
    private TaskRepositoryManager taskRepositoryManager;
    private Timer saveTimer;
    private IPath primaryPath;
    private IPath backupPath;

    public TaskDataManager(TaskRepositoryManager taskRepositoryManager, IPath path) {
        block11: {
            this.primaryPath = path.append(OFFLINE_REPORTS);
            this.backupPath = path.append("offlineReports.bak");
            this.taskRepositoryManager = taskRepositoryManager;
            this.primaryFile = this.primaryPath.toFile();
            this.backupFile = this.backupPath.toFile();
            if (this.primaryFile.exists()) {
                try {
                    this.readOfflineData();
                }
                catch (Throwable e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Error loading offline task data", (boolean)false);
                    if (this.restoreFromBackup()) {
                        try {
                            this.readOfflineData();
                        }
                        catch (Throwable throwable) {
                            this.dataStore = new OfflineDataStore();
                        }
                        break block11;
                    }
                    this.dataStore = new OfflineDataStore();
                }
            } else if (this.restoreFromBackup()) {
                try {
                    this.readOfflineData();
                }
                catch (Throwable throwable) {
                    this.dataStore = new OfflineDataStore();
                }
            } else {
                this.dataStore = new OfflineDataStore();
            }
        }
        this.saveTimer = new Timer();
        this.saveTimer.schedule((TimerTask)new RequestSaveTimerTask(), 60000L, 60000L);
        this.saverJob = new TaskDataSaverJob();
        this.saverJob.schedule();
    }

    private boolean restoreFromBackup() {
        MylarStatusHandler.log((String)"Restoring offline data from backup", (Object)this);
        this.primaryFile = this.primaryPath.toFile();
        this.backupFile = this.backupPath.toFile();
        if (this.backupFile.exists()) {
            if (this.primaryFile.exists() && !this.primaryFile.delete()) {
                MylarStatusHandler.log((String)"Unable to retire primary offline data", (Object)this);
            }
            this.primaryFile = this.primaryPath.toFile();
            if (this.backupFile.renameTo(this.primaryFile)) {
                this.primaryFile = this.primaryPath.toFile();
                this.backupFile = this.backupPath.toFile();
                return true;
            }
            MylarStatusHandler.log((String)"Unable to restore from offline backup", (Object)this);
        } else {
            MylarStatusHandler.log((String)"No offline backup found", (Object)this);
        }
        return false;
    }

    public void setNewTaskData(String taskHandle, RepositoryTaskData newEntry) {
        if (taskHandle == null || newEntry == null) {
            return;
        }
        this.dataStore.getNewDataMap().put(taskHandle, newEntry);
        this.dataStateChanged();
    }

    public void setOldTaskData(String taskHandle, RepositoryTaskData oldEntry) {
        if (taskHandle == null || oldEntry == null) {
            return;
        }
        this.dataStore.getOldDataMap().put(taskHandle, oldEntry);
        this.dataStateChanged();
    }

    public RepositoryTaskData getNewTaskData(String handle) {
        RepositoryTaskData data = this.dataStore.getNewDataMap().get(handle);
        return data;
    }

    public RepositoryTaskData getOldTaskData(String handle) {
        return this.dataStore.getOldDataMap().get(handle);
    }

    public Map<String, RepositoryTaskData> getUnsubmitted() {
        return Collections.unmodifiableMap(this.dataStore.getUnsubmittedTaskData());
    }

    public void removeUnsubmitted(String handle) {
        this.dataStore.getUnsubmittedTaskData().remove(handle);
        this.dataStateChanged();
    }

    public synchronized String getNewRepositoryTaskId() {
        this.dataStateChanged();
        return "" + this.dataStore.getNextTaskId();
    }

    private Set<RepositoryTaskAttribute> getLocalChanges(String handle) {
        Set<RepositoryTaskAttribute> localChanges = this.dataStore.getLocalEdits().get(handle);
        if (localChanges != null) {
            return Collections.unmodifiableSet(localChanges);
        }
        return Collections.emptySet();
    }

    public RepositoryTaskData getEditableCopy(String handle) {
        RepositoryTaskData data = this.getNewTaskData(handle);
        RepositoryTaskData clone = null;
        if (data != null) {
            try {
                clone = (RepositoryTaskData)ObjectCloner.deepCopy(data);
                this.updateAttributeFactory(clone);
            }
            catch (Exception e) {
                MylarStatusHandler.fail((Throwable)e, (String)"Error constructing modifiable task", (boolean)false);
                return null;
            }
            for (RepositoryTaskAttribute attribute : this.getLocalChanges(handle)) {
                if (attribute == null) continue;
                RepositoryTaskAttribute existing = clone.getAttribute(attribute.getID());
                if (existing != null) {
                    existing.clearValues();
                    List<String> options = existing.getOptions();
                    for (String value : attribute.getValues()) {
                        if (options.size() > 0) {
                            if (!options.contains(value)) continue;
                            existing.addValue(value);
                            continue;
                        }
                        existing.addValue(value);
                    }
                    continue;
                }
                clone.addAttribute(attribute.getID(), attribute);
            }
        }
        return clone;
    }

    public void saveEdits(String handle, Set<RepositoryTaskAttribute> attributes) {
        Set<RepositoryTaskAttribute> edits = this.dataStore.getLocalEdits().get(handle);
        if (edits == null) {
            edits = new HashSet<RepositoryTaskAttribute>();
            edits.addAll(attributes);
            this.dataStore.getLocalEdits().put(handle, edits);
        } else {
            edits.removeAll(attributes);
            edits.addAll(attributes);
        }
        this.dataStateChanged();
    }

    public Set<RepositoryTaskAttribute> getEdits(String handle) {
        Set<RepositoryTaskAttribute> changes = this.dataStore.getLocalEdits().get(handle);
        if (changes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(changes);
    }

    public void discardEdits(String handle) {
        this.dataStore.getLocalEdits().remove(handle);
        this.dataStateChanged();
    }

    public void remove(List<String> handlesToRemove) {
        for (String handle : handlesToRemove) {
            this.remove(handle);
        }
    }

    public void remove(String handle) {
        this.dataStore.getNewDataMap().remove(handle);
        this.dataStore.getOldDataMap().remove(handle);
        this.discardEdits(handle);
    }

    public void clear() {
        if (this.saverJob != null) {
            this.saverJob.waitSaveCompleted();
        }
        this.dataStore = new OfflineDataStore();
    }

    private void updateAttributeFactory(RepositoryTaskData taskData) {
        AbstractAttributeFactory factory;
        if (taskData == null) {
            return;
        }
        AbstractRepositoryConnector connector = this.taskRepositoryManager.getRepositoryConnector(taskData.getRepositoryKind());
        if (connector != null && connector.getTaskDataHandler() != null && (factory = connector.getTaskDataHandler().getAttributeFactory(taskData)) != null) {
            taskData.setAttributeFactory(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readOfflineData() throws IOException, ClassNotFoundException {
        this.clear();
        File file = this.primaryFile;
        synchronized (file) {
            ObjectInputStream in = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.primaryFile);
                in = new ObjectInputStream(fileInputStream);
                this.dataStore = (OfflineDataStore)in.readObject();
                for (RepositoryTaskData taskData : this.dataStore.getNewDataMap().values()) {
                    this.updateAttributeFactory(taskData);
                }
                for (RepositoryTaskData taskData : this.dataStore.getOldDataMap().values()) {
                    this.updateAttributeFactory(taskData);
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                    }
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                    }
                }
            }
        }
    }

    private void dataStateChanged() {
        if (this.saverJob != null) {
            this.saverJob.requestSave();
        }
    }

    public void saveNow() {
        this.saverJob.waitSaveCompleted();
        this.writeFile();
    }

    public boolean hasOutgoing(String handleIdentifier) {
        return this.getLocalChanges(handleIdentifier).size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void writeFile() {
        var1_1 = this.primaryFile;
        synchronized (var1_1) {
            if (Platform.isRunning()) {
                block34: {
                    out = null;
                    fileOuputStream = null;
                    if (!this.backupFile.exists() || this.backupFile.delete()) break block34;
                    MylarStatusHandler.log((String)"Unable to retire old offline backup.", (Object)this);
lbl10:
                    // 2 sources

                    while (true) {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                            }
                        }
                        if (fileOuputStream != null) {
                            try {
                                fileOuputStream.close();
                            }
                            catch (IOException e) {
                                MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                            }
                        }
                        return;
                    }
                }
                try {
                    try {
                        if (this.primaryFile.exists() && !this.primaryFile.renameTo(this.backupFile)) {
                            MylarStatusHandler.log((String)"Unable to backup offline data.", (Object)this);
                            ** continue;
                        }
                        fileOuputStream = new FileOutputStream(this.primaryPath.toFile());
                        out = new ObjectOutputStream(fileOuputStream);
                        out.writeObject(this.dataStore);
                    }
                    catch (Exception e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"Error occurred during save of offline task data.", (boolean)false);
                        this.restoreFromBackup();
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException e) {
                                MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                            }
                        }
                        if (fileOuputStream == null) ** GOTO lbl81
                        try {
                            fileOuputStream.close();
                        }
                        catch (IOException e) {
                            MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                        }
                    }
                }
                catch (Throwable var5_13) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                        }
                    }
                    if (fileOuputStream != null) {
                        try {
                            fileOuputStream.close();
                        }
                        catch (IOException e) {
                            MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                        }
                    }
                    throw var5_13;
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                    }
                }
                if (fileOuputStream != null) {
                    try {
                        fileOuputStream.close();
                    }
                    catch (IOException e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"Could not close stream", (boolean)false);
                    }
                }
            }
        }
lbl81:
        // 5 sources

    }

    public void stop() {
        this.saveTimer.cancel();
        this.saverJob.cancel();
        this.saveNow();
    }

    static class ObjectCloner {
        private ObjectCloner() {
        }

        public static Object deepCopy(Object oldObj) throws Exception {
            ObjectOutputStream outputStream = null;
            ObjectInputStream inputStream = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                outputStream = new ObjectOutputStream(byteArrayOutputStream);
                outputStream.writeObject(oldObj);
                outputStream.flush();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                inputStream = new ObjectInputStream(byteArrayInputStream);
                Object object = inputStream.readObject();
                return object;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                outputStream.close();
                inputStream.close();
            }
        }
    }

    private class RequestSaveTimerTask
    extends TimerTask {
        private RequestSaveTimerTask() {
        }

        public void run() {
            if (!Platform.isRunning()) {
                return;
            }
            TaskDataManager.this.saverJob.runRequested();
        }
    }

    private class TaskDataSaverJob
    extends Job {
        private volatile boolean saveRequested;
        private volatile boolean saveCompleted;

        TaskDataSaverJob() {
            super("Task Data Saver");
            this.saveRequested = false;
            this.saveCompleted = true;
            this.setPriority(30);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (true) {
                if (this.saveRequested) {
                    this.saveRequested = false;
                    this.saveCompleted = false;
                    TaskDataManager.this.writeFile();
                }
                if (this.saveRequested) continue;
                TaskDataSaverJob taskDataSaverJob = this;
                synchronized (taskDataSaverJob) {
                    this.saveCompleted = true;
                    ((Object)((Object)this)).notifyAll();
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        void requestSave() {
            this.saveRequested = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runRequested() {
            TaskDataSaverJob taskDataSaverJob = this;
            synchronized (taskDataSaverJob) {
                ((Object)((Object)this)).notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitSaveCompleted() {
            while (!this.saveCompleted) {
                TaskDataSaverJob taskDataSaverJob = this;
                synchronized (taskDataSaverJob) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

