/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.internal.tasks.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.core.SaxRepositoriesContentHandler;
import org.eclipse.mylar.internal.tasks.core.SaxRepositoriesWriter;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepositoriesExternalizer {
    private SaxRepositoriesWriter writer = new SaxRepositoriesWriter();
    public static final String ELEMENT_TASK_REPOSITORIES = "TaskRepositories";
    public static final String ELEMENT_TASK_REPOSITORY = "TaskRepository";
    public static final String ATTRIBUTE_VERSION = "OutputVersion";

    public void writeRepositoriesToXML(Collection<TaskRepository> repositories, File file) {
        block13: {
            ZipOutputStream outputStream = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    outputStream = new ZipOutputStream(new FileOutputStream(file));
                    ZipEntry zipEntry = new ZipEntry("repositories.xml");
                    outputStream.putNextEntry(zipEntry);
                    outputStream.setMethod(8);
                    this.writer.setOutputStream(outputStream);
                    this.writer.writeRepositoriesToStream(repositories);
                    outputStream.flush();
                    outputStream.closeEntry();
                    outputStream.close();
                }
                catch (IOException e) {
                    MylarStatusHandler.fail((Throwable)e, (String)("Could not write: " + file.getAbsolutePath()), (boolean)true);
                    if (outputStream == null) break block13;
                    try {
                        outputStream.close();
                    }
                    catch (IOException e2) {
                        MylarStatusHandler.fail((Throwable)e2, (String)"Unable to terminate output stream to repositories file.", (boolean)false);
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e) {
                        MylarStatusHandler.fail((Throwable)e, (String)"Unable to terminate output stream to repositories file.", (boolean)false);
                    }
                }
            }
        }
    }

    public Set<TaskRepository> readRepositoriesFromXML(File file) {
        if (!file.exists()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = new ZipInputStream(new FileInputStream(file));
            ((ZipInputStream)inputStream).getNextEntry();
            SaxRepositoriesContentHandler contentHandler = new SaxRepositoriesContentHandler();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(inputStream));
            Set<TaskRepository> set = contentHandler.getRepositories();
            return set;
        }
        catch (Throwable e) {
            file.renameTo(new File(String.valueOf(file.getAbsolutePath()) + "-save"));
            MylarStatusHandler.log((Throwable)e, (String)"Error while reading context file");
            return null;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Failed to close repositories input stream.", (boolean)false);
                }
            }
        }
    }
}

