/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylar.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.Task;
import org.eclipse.mylar.tasks.core.TaskList;

abstract class AbstractQueryHit
extends PlatformObject
implements ITaskListElement {
    protected TaskList taskList;
    protected AbstractRepositoryTask task;
    protected String repositoryUrl;
    protected String summary;
    protected String priority = Task.PriorityLevel.getDefault().toString();
    protected String taskId;
    private boolean completed = false;
    private boolean isNotified = false;
    private AbstractRepositoryQuery parent;

    protected AbstractQueryHit(TaskList taskList, String repositoryUrl, String description, String taskId) {
        this.taskList = taskList;
        this.repositoryUrl = repositoryUrl;
        this.summary = description;
        this.taskId = taskId;
    }

    public AbstractRepositoryQuery getParent() {
        return this.parent;
    }

    public void setParent(AbstractRepositoryQuery parent) {
        this.parent = parent;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public String getSummary() {
        if (this.task != null) {
            return this.task.getSummary();
        }
        return this.summary;
    }

    public AbstractRepositoryTask getOrCreateCorrespondingTask() {
        if (this.taskList == null) {
            return null;
        }
        ITask existingTask = this.taskList.getTask(this.getHandleIdentifier());
        if (existingTask instanceof AbstractRepositoryTask) {
            this.task = (AbstractRepositoryTask)existingTask;
        } else {
            this.task = this.createTask();
            this.task.setCompleted(this.completed);
            this.taskList.addTask(this.task);
        }
        return this.task;
    }

    protected abstract AbstractRepositoryTask createTask();

    public AbstractRepositoryTask getCorrespondingTask() {
        return this.task;
    }

    public void setCorrespondingTask(AbstractRepositoryTask task) {
        this.task = task;
    }

    public boolean isCompleted() {
        if (this.task != null) {
            return this.task.isCompleted();
        }
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public final String getHandleIdentifier() {
        if (this.task != null) {
            return this.task.getHandleIdentifier();
        }
        return RepositoryTaskHandleUtil.getHandle(this.repositoryUrl, this.taskId);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getIdentifyingLabel() {
        return this.getTaskId();
    }

    public boolean isNotified() {
        return this.isNotified;
    }

    public void setNotified(boolean notified) {
        this.isNotified = notified;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractQueryHit)) {
            return false;
        }
        AbstractQueryHit hit = (AbstractQueryHit)obj;
        return hit.getHandleIdentifier().equals(this.getHandleIdentifier());
    }

    public int hashCode() {
        return this.getHandleIdentifier().hashCode();
    }

    public String getUrl() {
        return "";
    }

    public String getPriority() {
        if (this.task != null) {
            return this.task.getPriority();
        }
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public void setSummary(String description) {
        this.summary = description;
    }

    public void setHandleIdentifier(String id) {
    }

    public int compareTo(ITaskListElement taskListElement) {
        return this.taskId.compareTo(((AbstractQueryHit)taskListElement).taskId);
    }

    @Deprecated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}

