/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylar.context.core.ContextCorePlugin;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.core.TaskDataManager;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.FileAttachment;
import org.eclipse.mylar.tasks.core.IAttachmentHandler;
import org.eclipse.mylar.tasks.core.ITaskDataHandler;
import org.eclipse.mylar.tasks.core.MylarStatus;
import org.eclipse.mylar.tasks.core.QueryHitCollector;
import org.eclipse.mylar.tasks.core.RepositoryAttachment;
import org.eclipse.mylar.tasks.core.RepositoryTaskData;
import org.eclipse.mylar.tasks.core.RepositoryTemplate;
import org.eclipse.mylar.tasks.core.TaskList;
import org.eclipse.mylar.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryConnector {
    public static final String MESSAGE_ATTACHMENTS_NOT_SUPPORTED = "Attachments not supported by connector: ";
    public static final String MYLAR_CONTEXT_DESCRIPTION = "mylar/context/zip";
    public static final String MYLAR_CONTEXT_FILENAME = "mylar-context.zip";
    protected Set<RepositoryTemplate> templates = new LinkedHashSet<RepositoryTemplate>();
    protected TaskList taskList;
    private boolean userManaged = true;
    private TaskDataManager taskDataManager;

    public void init(TaskList taskList) {
        this.taskList = taskList;
    }

    public abstract IAttachmentHandler getAttachmentHandler();

    public abstract ITaskDataHandler getTaskDataHandler();

    public abstract String getRepositoryUrlFromTaskUrl(String var1);

    public abstract String getTaskIdFromTaskUrl(String var1);

    public abstract String getTaskWebUrl(String var1, String var2);

    public String[] getTaskIdsFromComment(TaskRepository repository, String comment) {
        return null;
    }

    public abstract boolean canCreateTaskFromKey(TaskRepository var1);

    public abstract boolean canCreateNewTask(TaskRepository var1);

    public AbstractRepositoryTask createTaskFromExistingId(TaskRepository repository, String id, IProgressMonitor monitor) throws CoreException {
        return this.createTaskFromExistingId(repository, id, true, monitor);
    }

    public AbstractRepositoryTask createTaskFromExistingId(TaskRepository repository, String id, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractRepositoryTask task = this.taskList.getTask(repository.getUrl(), id);
        AbstractRepositoryTask repositoryTask = null;
        if (task instanceof AbstractRepositoryTask) {
            repositoryTask = task;
        } else if (task == null && this.getTaskDataHandler() != null) {
            RepositoryTaskData taskData = null;
            taskData = this.getTaskDataHandler().getTaskData(repository, id, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (taskData != null && (repositoryTask = this.createTaskFromTaskData(repository, taskData, retrieveSubTasks, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) != null) {
                this.taskList.addTask(repositoryTask);
            }
        }
        return repositoryTask;
    }

    public AbstractRepositoryTask createTaskFromTaskData(TaskRepository repository, RepositoryTaskData taskData, boolean retrieveSubTasks, IProgressMonitor monitor) throws CoreException {
        AbstractRepositoryTask repositoryTask = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            if (taskData != null && this.getTaskDataManager() != null) {
                repositoryTask = this.createTask(repository.getUrl(), taskData.getId(), String.valueOf(taskData.getId()) + ": " + taskData.getDescription());
                this.updateTaskFromTaskData(repository, repositoryTask, taskData);
                this.getTaskDataManager().setNewTaskData(repositoryTask.getHandleIdentifier(), taskData);
                if (retrieveSubTasks) {
                    monitor.beginTask("Creating task", this.getTaskDataHandler().getSubTaskIds(taskData).size());
                    for (String subId : this.getTaskDataHandler().getSubTaskIds(taskData)) {
                        AbstractRepositoryTask subTask;
                        if (subId == null || subId.trim().equals("") || (subTask = this.createTaskFromExistingId(repository, subId, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        repositoryTask.addSubTask(subTask);
                    }
                }
            }
        }
        finally {
            monitor.done();
        }
        return repositoryTask;
    }

    public abstract AbstractRepositoryTask createTask(String var1, String var2, String var3);

    public abstract IStatus performQuery(AbstractRepositoryQuery var1, TaskRepository var2, IProgressMonitor var3, QueryHitCollector var4, boolean var5);

    public abstract String getLabel();

    public abstract String getRepositoryType();

    public abstract void updateTaskFromRepository(TaskRepository var1, AbstractRepositoryTask var2, IProgressMonitor var3) throws CoreException;

    public abstract void updateTaskFromTaskData(TaskRepository var1, AbstractRepositoryTask var2, RepositoryTaskData var3);

    public String[] repositoryPropertyNames() {
        return new String[]{"version", "timezone", "encoding"};
    }

    public final Set<RepositoryAttachment> getContextAttachments(TaskRepository repository, AbstractRepositoryTask task) {
        HashSet<RepositoryAttachment> contextAttachments = new HashSet<RepositoryAttachment>();
        if (this.taskDataManager != null && this.taskDataManager.getNewTaskData(task.getHandleIdentifier()) != null) {
            for (RepositoryAttachment attachment : this.taskDataManager.getNewTaskData(task.getHandleIdentifier()).getAttachments()) {
                if (!attachment.getDescription().equals(MYLAR_CONTEXT_DESCRIPTION)) continue;
                contextAttachments.add(attachment);
            }
        }
        return contextAttachments;
    }

    public final boolean hasRepositoryContext(TaskRepository repository, AbstractRepositoryTask task) {
        if (repository == null || task == null) {
            return false;
        }
        Set<RepositoryAttachment> remoteContextAttachments = this.getContextAttachments(repository, task);
        return remoteContextAttachments != null && remoteContextAttachments.size() > 0;
    }

    public abstract Set<AbstractRepositoryTask> getChangedSinceLastSync(TaskRepository var1, Set<AbstractRepositoryTask> var2) throws CoreException;

    public final boolean attachContext(TaskRepository repository, AbstractRepositoryTask task, String longComment, IProgressMonitor monitor) throws CoreException {
        ContextCorePlugin.getContextManager().saveContext(task.getHandleIdentifier());
        File sourceContextFile = ContextCorePlugin.getContextManager().getFileForContext(task.getHandleIdentifier());
        AbstractRepositoryTask.RepositoryTaskSyncState previousState = task.getSyncState();
        if (sourceContextFile != null && sourceContextFile.exists()) {
            IAttachmentHandler handler = this.getAttachmentHandler();
            if (handler == null) {
                return false;
            }
            try {
                task.setSubmitting(true);
                task.setSyncState(AbstractRepositoryTask.RepositoryTaskSyncState.OUTGOING);
                FileAttachment attachment = new FileAttachment(sourceContextFile);
                attachment.setDescription(MYLAR_CONTEXT_DESCRIPTION);
                attachment.setFilename(MYLAR_CONTEXT_FILENAME);
                handler.uploadAttachment(repository, task, attachment, longComment, monitor);
            }
            catch (CoreException e) {
                task.setSyncState(previousState);
                throw e;
            }
            catch (OperationCanceledException operationCanceledException) {
                return true;
            }
        }
        return true;
    }

    public final boolean retrieveContext(TaskRepository repository, AbstractRepositoryTask task, RepositoryAttachment attachment, String destinationPath, IProgressMonitor monitor) throws CoreException {
        IAttachmentHandler attachmentHandler = this.getAttachmentHandler();
        if (attachmentHandler == null) {
            return false;
        }
        File destinationContextFile = ContextCorePlugin.getContextManager().getFileForContext(task.getHandleIdentifier());
        if (destinationContextFile.exists() && !destinationContextFile.delete()) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(destinationContextFile);
            try {
                attachmentHandler.downloadAttachment(repository, attachment, out, monitor);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Could not close context file", (boolean)false);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new MylarStatus(4, "org.eclipse.mylar.tasks.core", 7, "Could not create context file", e));
        }
        return true;
    }

    public void addTemplate(RepositoryTemplate template) {
        this.templates.add(template);
    }

    public Set<RepositoryTemplate> getTemplates() {
        return this.templates;
    }

    public void removeTemplate(RepositoryTemplate template) {
        this.templates.remove(template);
    }

    public RepositoryTemplate getTemplate(String label) {
        for (RepositoryTemplate template : this.getTemplates()) {
            if (!template.label.equals(label)) continue;
            return template;
        }
        return null;
    }

    public String getTaskIdPrefix() {
        return "task";
    }

    public abstract void updateAttributes(TaskRepository var1, IProgressMonitor var2) throws CoreException;

    public void setUserManaged(boolean userManaged) {
        this.userManaged = userManaged;
    }

    public boolean isUserManaged() {
        return this.userManaged;
    }

    public String getLastSyncTimestamp(TaskRepository repository, Set<AbstractRepositoryTask> changedTasks) {
        Date mostRecent = new Date(0L);
        String mostRecentTimeStamp = repository.getSyncTimeStamp();
        for (AbstractRepositoryTask task : changedTasks) {
            Date taskModifiedDate;
            if (this.getTaskData(task) == null || this.getTaskDataHandler() == null || this.getTaskData(task).getLastModified() == null || (taskModifiedDate = this.getTaskData(task).getAttributeFactory().getDateForAttributeType("task.common.date.modified", this.getTaskData(task).getLastModified())) == null || !taskModifiedDate.after(mostRecent)) continue;
            mostRecent = taskModifiedDate;
            mostRecentTimeStamp = this.getTaskData(task).getLastModified();
        }
        return mostRecentTimeStamp;
    }

    private RepositoryTaskData getTaskData(AbstractRepositoryTask task) {
        if (this.taskDataManager != null) {
            return this.taskDataManager.getNewTaskData(task.getHandleIdentifier());
        }
        return null;
    }

    private TaskDataManager getTaskDataManager() {
        return this.taskDataManager;
    }

    public void setTaskDataManager(TaskDataManager taskDataManager) {
        this.taskDataManager = taskDataManager;
    }
}

