/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.Task;
import org.eclipse.mylar.tasks.core.TaskList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryQuery
extends AbstractTaskContainer {
    protected String repositoryUrl;
    protected String lastRefreshTimeStamp = "<never>";
    private boolean currentlySynchronizing = false;
    protected IStatus status = null;

    public abstract String getRepositoryKind();

    public AbstractRepositoryQuery(String description, TaskList taskList) {
        super(description, taskList);
    }

    public boolean isArchive() {
        return false;
    }

    public void setIsArchive(boolean isArchive) {
    }

    public synchronized Set<AbstractRepositoryTask> getHits() {
        HashSet<AbstractRepositoryTask> repositoryTasks = new HashSet<AbstractRepositoryTask>();
        for (ITask task : super.getChildren()) {
            if (!(task instanceof AbstractRepositoryTask)) continue;
            repositoryTasks.add((AbstractRepositoryTask)task);
        }
        return repositoryTasks;
    }

    public synchronized void updateHits(Collection<AbstractRepositoryTask> newHits) {
        this.clear();
        for (AbstractRepositoryTask abstractRepositoryTask : newHits) {
            this.addHit(abstractRepositoryTask);
        }
    }

    public synchronized void addHit(AbstractRepositoryTask hit) {
        if (!this.taskList.getAllTasks().contains(hit)) {
            this.taskList.addTask(hit);
        }
        super.add(hit);
    }

    public synchronized void removeHit(AbstractRepositoryTask hit) {
        super.remove(hit);
    }

    @Override
    public synchronized String getPriority() {
        if (super.isEmpty()) {
            return Task.PriorityLevel.P1.toString();
        }
        String highestPriority = Task.PriorityLevel.P5.toString();
        for (AbstractRepositoryTask hit : this.getHits()) {
            if (highestPriority.compareTo(hit.getPriority()) <= 0) continue;
            highestPriority = hit.getPriority();
        }
        return highestPriority;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isCompleted() {
        return false;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String newRepositoryUrl) {
        if (this.repositoryUrl != null && this.url != null) {
            this.url = String.valueOf(newRepositoryUrl) + this.url.substring(this.repositoryUrl.length());
        }
        this.repositoryUrl = newRepositoryUrl;
    }

    public boolean isSynchronizing() {
        return this.currentlySynchronizing;
    }

    public void setCurrentlySynchronizing(boolean currentlySynchronizing) {
        this.currentlySynchronizing = currentlySynchronizing;
    }

    public String getLastRefreshTimeStamp() {
        return this.lastRefreshTimeStamp;
    }

    public void setLastRefreshTimeStamp(String lastRefreshTimeStamp) {
        this.lastRefreshTimeStamp = lastRefreshTimeStamp;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }
}

