/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylar.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylar.tasks.core.Task;

public abstract class AbstractRepositoryTask
extends Task {
    protected String lastSynchronizedDateStamp;
    protected String repositoryUrl;
    protected String taskId;
    protected String owner;
    protected boolean isNotifiedIncoming = false;
    protected RepositoryTaskSyncState syncState = RepositoryTaskSyncState.SYNCHRONIZED;
    protected IStatus errorStatus = null;
    protected boolean currentlySynchronizing;
    protected boolean submitting;

    public AbstractRepositoryTask(String repositoryUrl, String taskId, String summary) {
        super(null, summary);
        this.repositoryUrl = repositoryUrl;
        this.taskId = taskId;
    }

    public final String getHandleIdentifier() {
        return RepositoryTaskHandleUtil.getHandle(this.repositoryUrl, this.taskId);
    }

    public abstract String getRepositoryKind();

    public String getLastSyncDateStamp() {
        return this.lastSynchronizedDateStamp;
    }

    public void setLastSyncDateStamp(String lastSyncDateStamp) {
        this.lastSynchronizedDateStamp = lastSyncDateStamp;
    }

    public void setSyncState(RepositoryTaskSyncState syncState) {
        this.syncState = syncState;
    }

    public RepositoryTaskSyncState getSyncState() {
        return this.syncState;
    }

    public final boolean isLocal() {
        return false;
    }

    public boolean isSynchronizing() {
        return this.currentlySynchronizing;
    }

    public void setCurrentlySynchronizing(boolean currentlySychronizing) {
        this.currentlySynchronizing = currentlySychronizing;
    }

    public boolean isNotified() {
        return this.isNotifiedIncoming;
    }

    public void setNotified(boolean notified) {
        this.isNotifiedIncoming = notified;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public IStatus getStatus() {
        return this.errorStatus;
    }

    public void setStatus(IStatus status) {
        this.errorStatus = status;
    }

    public final String getTaskId() {
        return this.taskId;
    }

    public final String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public final void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public String getTaskKey() {
        return this.taskId;
    }

    public boolean isSubmitting() {
        return this.submitting;
    }

    public void setSubmitting(boolean submitting) {
        this.submitting = submitting;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepositoryTaskSyncState {
        OUTGOING,
        SYNCHRONIZED,
        INCOMING,
        CONFLICT;

    }
}

