/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.TaskList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTaskContainer
extends PlatformObject
implements ITaskListElement {
    private String handle = "";
    private Set<String> childHandles = new CopyOnWriteArraySet<String>();
    protected TaskList taskList;
    protected String url = null;

    public AbstractTaskContainer(String handleAndDescription, TaskList taskList) {
        assert (this.handle != null);
        this.handle = handleAndDescription;
        this.taskList = taskList;
    }

    public abstract boolean isLocal();

    public Set<ITask> getChildren() {
        HashSet<ITask> children = new HashSet<ITask>();
        for (String childHandle : this.childHandles) {
            ITask task = this.taskList.getTask(childHandle);
            if (task == null) continue;
            children.add(task);
        }
        return children;
    }

    public boolean contains(String handle) {
        return this.childHandles.contains(handle);
    }

    @Override
    public String getSummary() {
        return this.handle;
    }

    public boolean isEmpty() {
        return this.childHandles.isEmpty();
    }

    @Override
    public String getHandleIdentifier() {
        return this.handle;
    }

    public void setDescription(String description) {
        this.handle = description;
    }

    public void setHandleIdentifier(String handle) {
        this.handle = handle;
    }

    void add(ITask task) {
        this.childHandles.add(task.getHandleIdentifier());
    }

    void remove(ITask task) {
        this.childHandles.remove(task.getHandleIdentifier());
    }

    void clear() {
        this.childHandles.clear();
    }

    public boolean isCompleted() {
        return false;
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof AbstractTaskContainer) {
            AbstractTaskContainer compare = (AbstractTaskContainer)object;
            return this.getHandleIdentifier().equals(compare.getHandleIdentifier());
        }
        return false;
    }

    public String toString() {
        return "container: " + this.handle;
    }

    public boolean canRename() {
        return true;
    }

    @Override
    public int compareTo(ITaskListElement taskListElement) {
        return this.getHandleIdentifier().compareTo(((AbstractTaskContainer)taskListElement).getHandleIdentifier());
    }
}

