/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylar.tasks.core.RepositoryTaskAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeContainer
implements Serializable {
    public static final String ERROR_NO_ATTRIBUTE_FACTORY = "Attribute factory not available.";
    private static final long serialVersionUID = 3538078709450471836L;
    private ArrayList<String> attributeKeys;
    private HashMap<String, RepositoryTaskAttribute> attributes;
    private transient AbstractAttributeFactory attributeFactory;

    public AttributeContainer(AbstractAttributeFactory attributeFactory) {
        this.attributeFactory = attributeFactory;
        this.attributeKeys = new ArrayList();
        this.attributes = new HashMap();
    }

    public void setAttributeFactory(AbstractAttributeFactory factory) {
        this.attributeFactory = factory;
    }

    public void addAttribute(String key, RepositoryTaskAttribute attribute) {
        if (this.attributeFactory == null) {
            MylarStatusHandler.log((String)ERROR_NO_ATTRIBUTE_FACTORY, (Object)this);
            return;
        }
        String mapped = this.attributeFactory.mapCommonAttributeKey(key);
        if (mapped == null) {
            MylarStatusHandler.log((String)("Mylar Error: mapped value for " + key + " returned null."), (Object)this);
            return;
        }
        if (!this.attributes.containsKey(mapped)) {
            this.attributeKeys.add(mapped);
        }
        this.attributes.put(mapped, attribute);
    }

    public RepositoryTaskAttribute getAttribute(String key) {
        if (this.attributeFactory == null) {
            MylarStatusHandler.log((String)ERROR_NO_ATTRIBUTE_FACTORY, (Object)this);
            return null;
        }
        String mapped = this.attributeFactory.mapCommonAttributeKey(key);
        return this.attributes.get(mapped);
    }

    public void removeAttribute(Object key) {
        this.attributeKeys.remove(key);
        this.attributes.remove(key);
    }

    public List<RepositoryTaskAttribute> getAttributes() {
        ArrayList<RepositoryTaskAttribute> attributeEntries = new ArrayList<RepositoryTaskAttribute>(this.attributeKeys.size());
        for (String key : this.attributeKeys) {
            RepositoryTaskAttribute attribute = this.attributes.get(key);
            attributeEntries.add(attribute);
        }
        return attributeEntries;
    }

    public void removeAllAttributes() {
        this.attributeKeys.clear();
        this.attributes.clear();
    }

    public void addAttributeValue(String key, String value) {
        if (this.attributeFactory == null) {
            MylarStatusHandler.log((String)ERROR_NO_ATTRIBUTE_FACTORY, (Object)this);
            return;
        }
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            attrib.addValue(value);
        } else {
            attrib = this.attributeFactory.createAttribute(key);
            attrib.addValue(value);
            this.addAttribute(key, attrib);
        }
    }

    public void setAttributeValue(String key, String value) {
        if (this.attributeFactory == null) {
            MylarStatusHandler.log((String)ERROR_NO_ATTRIBUTE_FACTORY, (Object)this);
            return;
        }
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib == null) {
            attrib = this.attributeFactory.createAttribute(key);
            this.addAttribute(key, attrib);
        }
        attrib.setValue(value);
    }

    public String getAttributeValue(String key) {
        if (this.attributeFactory == null) {
            MylarStatusHandler.log((String)ERROR_NO_ATTRIBUTE_FACTORY, (Object)this);
            return "";
        }
        String returnValue = "";
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            returnValue = attrib.getValue();
        }
        return returnValue;
    }

    public List<String> getAttributeValues(String key) {
        List<String> returnValue = new ArrayList<String>();
        if (this.attributeFactory == null) {
            MylarStatusHandler.log((String)ERROR_NO_ATTRIBUTE_FACTORY, (Object)this);
            return returnValue;
        }
        RepositoryTaskAttribute attrib = this.getAttribute(key);
        if (attrib != null) {
            returnValue = attrib.getValues();
        }
        return returnValue;
    }

    public AbstractAttributeFactory getAttributeFactory() {
        return this.attributeFactory;
    }
}

