/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.DateRangeActivityDelegate;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.TaskList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRangeContainer
extends AbstractTaskContainer {
    private Set<DateRangeActivityDelegate> dateRangeDelegates = new HashSet<DateRangeActivityDelegate>();
    private Map<DateRangeActivityDelegate, Long> taskToDuration = new HashMap<DateRangeActivityDelegate, Long>();
    private Calendar startDate;
    private Calendar endDate;
    private long totalElapsed = 0L;
    private long totalEstimated = 0L;

    public DateRangeContainer(GregorianCalendar startDate, GregorianCalendar endDate, String description, TaskList taskList) {
        super(description, taskList);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public DateRangeContainer(Calendar startDate, Calendar endDate, String description, TaskList taskList) {
        super(description, taskList);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public DateRangeContainer(GregorianCalendar startDate, GregorianCalendar endDate, TaskList taskList) {
        super(String.valueOf(DateFormat.getDateInstance(0).format(startDate.getTime())) + " to " + DateFormat.getDateInstance(0).format(endDate.getTime()), taskList);
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public DateRangeContainer(Date time, Date time2, String description, TaskList taskList) {
        super(description, taskList);
        this.startDate = new GregorianCalendar();
        this.startDate.setTime(time);
        this.endDate = new GregorianCalendar();
        this.endDate.setTime(time2);
    }

    public boolean includes(Calendar cal) {
        return this.startDate.getTimeInMillis() <= cal.getTimeInMillis() && this.endDate.getTimeInMillis() >= cal.getTimeInMillis();
    }

    @Override
    public void clear() {
        this.totalEstimated = 0L;
        this.totalElapsed = 0L;
        this.taskToDuration.clear();
        this.dateRangeDelegates.clear();
        super.clear();
    }

    public void addTask(DateRangeActivityDelegate taskWrapper) {
        long taskActivity = taskWrapper.getActivity();
        if (taskActivity < 0L) {
            taskActivity = 0L;
        }
        this.totalElapsed += taskActivity;
        this.dateRangeDelegates.remove(taskWrapper);
        this.dateRangeDelegates.add(taskWrapper);
        if (this.taskToDuration.containsKey(taskWrapper)) {
            long previous = this.taskToDuration.get(taskWrapper);
            long newDuration = previous + taskActivity;
            this.taskToDuration.put(taskWrapper, newDuration);
        } else {
            this.taskToDuration.put(taskWrapper, taskActivity);
        }
        super.add(taskWrapper.getCorrespondingTask());
    }

    public void remove(DateRangeActivityDelegate taskWrapper) {
        this.dateRangeDelegates.remove(taskWrapper);
        super.remove(taskWrapper.getCorrespondingTask());
    }

    public Calendar getStart() {
        return this.startDate;
    }

    public Calendar getEnd() {
        return this.endDate;
    }

    public long getTotalElapsed() {
        return this.totalElapsed;
    }

    public long getElapsed(DateRangeActivityDelegate taskWrapper) {
        if (this.taskToDuration.containsKey(taskWrapper)) {
            return this.taskToDuration.get(taskWrapper);
        }
        return 0L;
    }

    public long getTotalEstimated() {
        this.totalEstimated = 0L;
        for (ITask iTask : this.dateRangeDelegates) {
            this.totalEstimated += (long)iTask.getEstimateTimeHours();
        }
        return this.totalEstimated;
    }

    public boolean isArchive() {
        return false;
    }

    public void setIsArchive(boolean isArchive) {
    }

    @Override
    public String getPriority() {
        return "";
    }

    @Override
    public void setHandleIdentifier(String id) {
    }

    public Set<DateRangeActivityDelegate> getDateRangeDelegates() {
        return this.dateRangeDelegates;
    }

    public boolean isFuture() {
        return !this.isPresent() && this.getStart().after(Calendar.getInstance());
    }

    public boolean isPresent() {
        return this.getStart().before(Calendar.getInstance()) && this.getEnd().after(Calendar.getInstance());
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateRangeContainer other = (DateRangeContainer)obj;
        if (this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate)) {
            return false;
        }
        return !(this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate));
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public int compareTo(ITaskListElement taskListElement) {
        return this.startDate.compareTo(((DateRangeContainer)taskListElement).startDate);
    }
}

