/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylar.tasks.core.AbstractQueryHit;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListExternalizer;
import org.eclipse.mylar.tasks.core.Task;
import org.eclipse.mylar.tasks.core.TaskArchive;
import org.eclipse.mylar.tasks.core.TaskCategory;
import org.eclipse.mylar.tasks.core.TaskExternalizationException;
import org.eclipse.mylar.tasks.core.TaskList;
import org.eclipse.mylar.tasks.core.UncategorizedCategory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingTaskExternalizer
implements ITaskListExternalizer {
    private static final String DEFAULT_PRIORITY = Task.PriorityLevel.P3.toString();
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S z";
    public static final String KEY_QUERY = "Query";
    public static final String KEY_QUERY_HIT = "QueryHit";
    public static final String KEY_QUERY_STRING = "QueryString";
    public static final String KEY_NOTIFIED_INCOMING = "NotifiedIncoming";
    public static final String KEY_LAST_REFRESH = "LastRefreshTimeStamp";
    public static final String KEY_LABEL = "Label";
    public static final String KEY_HANDLE = "Handle";
    public static final String KEY_REPOSITORY_URL = "RepositoryUrl";
    public static final String KEY_CATEGORY = "Category";
    public static final String VAL_ROOT = "Root";
    public static final String KEY_TASK = "Task";
    public static final String KEY_SUBTASK = "SubTask";
    public static final String KEY_KIND = "Kind";
    public static final String KEY_TASK_CATEGORY = "TaskCategory";
    public static final String KEY_LINK = "Link";
    public static final String KEY_PLAN = "Plan";
    public static final String KEY_TIME_ESTIMATED = "Estimated";
    public static final String KEY_ISSUEURL = "IssueURL";
    public static final String KEY_NOTES = "Notes";
    public static final String KEY_ACTIVE = "Active";
    public static final String KEY_COMPLETE = "Complete";
    public static final String KEY_PRIORITY = "Priority";
    public static final String KEY_PATH = "Path";
    public static final String VAL_FALSE = "false";
    public static final String VAL_TRUE = "true";
    public static final String KEY_NAME = "Name";
    public static final String KEY_DATE_END = "EndDate";
    public static final String KEY_DATE_CREATION = "CreationDate";
    public static final String KEY_DATE_REMINDER = "ReminderDate";
    public static final String KEY_DATE_DUE = "DueDate";
    public static final String KEY_REMINDED = "Reminded";
    public static final String KEY_LAST_MOD_DATE = "LastModified";
    public static final String KEY_DIRTY = "Dirty";
    public static final String KEY_SYNC_STATE = "offlineSyncState";
    public static final String KEY_OWNER = "Owner";
    private List<ITaskListExternalizer> delegateExternalizers = new ArrayList<ITaskListExternalizer>();

    public void setDelegateExternalizers(List<ITaskListExternalizer> externalizers) {
        this.delegateExternalizers = externalizers;
    }

    @Override
    public Element createCategoryElement(AbstractTaskContainer category, Document doc, Element parent) {
        if (category instanceof TaskArchive) {
            return parent;
        }
        if (category instanceof UncategorizedCategory) {
            return parent;
        }
        Element node = doc.createElement(this.getCategoryTagName());
        node.setAttribute(KEY_NAME, category.getSummary());
        parent.appendChild(node);
        return node;
    }

    @Override
    public boolean canCreateElementFor(ITask task) {
        return false;
    }

    @Override
    public Element createTaskElement(ITask task, Document doc, Element parent) {
        Element node = doc.createElement(this.getTaskTagName());
        node.setAttribute(KEY_LABEL, this.stripControlCharacters(task.getSummary()));
        node.setAttribute(KEY_HANDLE, task.getHandleIdentifier());
        if (task.getContainer() != null) {
            if (task.getContainer().getHandleIdentifier().equals("uncategorized")) {
                node.setAttribute(KEY_CATEGORY, VAL_ROOT);
            } else {
                node.setAttribute(KEY_CATEGORY, task.getContainer().getHandleIdentifier());
            }
        }
        node.setAttribute(KEY_PRIORITY, task.getPriority());
        node.setAttribute(KEY_KIND, task.getTaskKind());
        if (task.isCompleted()) {
            node.setAttribute(KEY_COMPLETE, VAL_TRUE);
        } else {
            node.setAttribute(KEY_COMPLETE, VAL_FALSE);
        }
        if (task.isActive()) {
            node.setAttribute(KEY_ACTIVE, VAL_TRUE);
        } else {
            node.setAttribute(KEY_ACTIVE, VAL_FALSE);
        }
        if (task.getTaskUrl() != null) {
            node.setAttribute(KEY_ISSUEURL, task.getTaskUrl());
        }
        node.setAttribute(KEY_NOTES, this.stripControlCharacters(task.getNotes()));
        node.setAttribute(KEY_TIME_ESTIMATED, "" + task.getEstimateTimeHours());
        node.setAttribute(KEY_DATE_END, this.formatExternDate(task.getCompletionDate()));
        node.setAttribute(KEY_DATE_CREATION, this.formatExternDate(task.getCreationDate()));
        node.setAttribute(KEY_DATE_DUE, this.formatExternDate(task.getDueDate()));
        node.setAttribute(KEY_DATE_REMINDER, this.formatExternDate(task.getScheduledForDate()));
        if (task.hasBeenReminded()) {
            node.setAttribute(KEY_REMINDED, VAL_TRUE);
        } else {
            node.setAttribute(KEY_REMINDED, VAL_FALSE);
        }
        if (task instanceof AbstractRepositoryTask) {
            AbstractRepositoryTask abstractTask = (AbstractRepositoryTask)task;
            if (abstractTask.getLastSyncDateStamp() != null) {
                node.setAttribute(KEY_LAST_MOD_DATE, abstractTask.getLastSyncDateStamp());
            }
            if (abstractTask.isNotified()) {
                node.setAttribute(KEY_NOTIFIED_INCOMING, VAL_TRUE);
            } else {
                node.setAttribute(KEY_NOTIFIED_INCOMING, VAL_FALSE);
            }
            if (abstractTask.getSyncState() != null) {
                node.setAttribute(KEY_SYNC_STATE, abstractTask.getSyncState().toString());
            } else {
                node.setAttribute(KEY_SYNC_STATE, AbstractRepositoryTask.RepositoryTaskSyncState.SYNCHRONIZED.toString());
            }
            if (abstractTask.getOwner() != null) {
                node.setAttribute(KEY_OWNER, abstractTask.getOwner());
            }
        }
        for (ITask t : task.getChildren()) {
            this.createSubTaskElement(t, doc, node);
        }
        parent.appendChild(node);
        return node;
    }

    public void readSubTasks(ITask task, NodeList nodes, TaskList tasklist) {
        int j = 0;
        while (j < nodes.getLength()) {
            String handle;
            ITask subTask;
            Node child = nodes.item(j);
            Element element = (Element)child;
            if (element.hasAttribute(KEY_HANDLE) && (subTask = tasklist.getTask(handle = element.getAttribute(KEY_HANDLE))) != null) {
                task.addSubTask(subTask);
            }
            ++j;
        }
    }

    public void createSubTaskElement(ITask task, Document doc, Element parent) {
        Element node = doc.createElement(KEY_SUBTASK);
        node.setAttribute(KEY_HANDLE, task.getHandleIdentifier());
        parent.appendChild(node);
    }

    protected String stripControlCharacters(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder(text.length());
        int x = 0;
        while (x < text.length()) {
            char temp = text.charAt(x);
            if (!Character.isISOControl(temp) || temp == '\n' || temp == '\r' || temp == '\t') {
                builder.append(temp);
            }
            ++x;
        }
        return builder.toString();
    }

    protected String formatExternDate(Date date) {
        if (date == null) {
            return "";
        }
        String f = DATE_FORMAT;
        SimpleDateFormat format = new SimpleDateFormat(f, Locale.ENGLISH);
        return format.format(date);
    }

    @Override
    public boolean canReadCategory(Node node) {
        return node.getNodeName().equals(this.getCategoryTagName());
    }

    @Override
    public void readCategory(Node node, TaskList taskList) throws TaskExternalizationException {
        AbstractTaskContainer category;
        boolean hasCaughtException = false;
        Element element = (Element)node;
        if (element.hasAttribute(KEY_NAME)) {
            category = new TaskCategory(element.getAttribute(KEY_NAME), taskList);
            taskList.internalAddCategory(category);
        } else {
            category = taskList.getArchiveContainer();
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            try {
                category.add(this.readTask(child, taskList, category, null));
            }
            catch (Throwable throwable) {
                hasCaughtException = true;
            }
            ++i;
        }
        if (hasCaughtException) {
            throw new TaskExternalizationException("Failed to load all tasks");
        }
    }

    public final ITask readTask(Node node, TaskList taskList, AbstractTaskContainer category, ITask parent) throws TaskExternalizationException {
        ITask task = null;
        String taskId = null;
        String repositoryUrl = null;
        String summary = "";
        boolean alreadyRead = false;
        Element element = (Element)node;
        if (!element.hasAttribute(KEY_HANDLE)) {
            throw new TaskExternalizationException("Handle not stored for repository task");
        }
        String handle = element.getAttribute(KEY_HANDLE);
        repositoryUrl = RepositoryTaskHandleUtil.getRepositoryUrl(handle);
        taskId = RepositoryTaskHandleUtil.getTaskId(handle);
        if (element.hasAttribute(KEY_LABEL)) {
            summary = element.getAttribute(KEY_LABEL);
        }
        for (ITaskListExternalizer externalizer : this.delegateExternalizers) {
            if (alreadyRead || !externalizer.canReadTask(node)) continue;
            task = externalizer.createTask(repositoryUrl, taskId, summary, element, taskList, category, parent);
            alreadyRead = true;
        }
        if (!alreadyRead && this.canReadTask(node)) {
            task = this.createTask(repositoryUrl, taskId, summary, element, taskList, category, parent);
            alreadyRead = true;
        }
        if (task != null) {
            this.readTaskInfo(task, taskList, element, parent, category);
        }
        return task;
    }

    @Override
    public boolean canReadTask(Node node) {
        return node.getNodeName().equals(this.getTaskTagName());
    }

    @Override
    public ITask createTask(String repositoryUrl, String taskId, String summary, Element element, TaskList taskList, AbstractTaskContainer category, ITask parent) throws TaskExternalizationException {
        if (!element.hasAttribute(KEY_HANDLE)) {
            throw new TaskExternalizationException("Handle not stored for task");
        }
        String handle = element.getAttribute(KEY_HANDLE);
        Task task = new Task(handle, summary);
        return task;
    }

    private void readTaskInfo(ITask task, TaskList taskList, Element element, ITask parent, AbstractTaskContainer legacyCategory) throws TaskExternalizationException {
        String categoryHandle = null;
        if (element.hasAttribute(KEY_CATEGORY)) {
            categoryHandle = element.getAttribute(KEY_CATEGORY);
            AbstractTaskContainer category = null;
            if (categoryHandle != null) {
                category = taskList.getContainerForHandle(categoryHandle);
            }
            if (category != null) {
                taskList.internalAddTask(task, category);
            } else if (parent == null) {
                taskList.internalAddRootTask(task);
            }
        } else if (legacyCategory != null && !(legacyCategory instanceof TaskArchive)) {
            task.setContainer(legacyCategory);
            legacyCategory.add(task);
        } else if (legacyCategory == null && parent == null) {
            if (task instanceof AbstractRepositoryTask) {
                taskList.internalAddTask(task, taskList.getArchiveContainer());
            } else {
                taskList.internalAddRootTask(task);
            }
        } else if (parent != null) {
            task.setParent(parent);
        } else {
            taskList.internalAddTask(task, taskList.getArchiveContainer());
        }
        if (element.hasAttribute(KEY_PRIORITY)) {
            task.setPriority(element.getAttribute(KEY_PRIORITY));
        } else {
            task.setPriority(DEFAULT_PRIORITY);
        }
        if (element.hasAttribute(KEY_KIND)) {
            task.setKind(element.getAttribute(KEY_KIND));
        }
        if (element.getAttribute(KEY_ACTIVE).compareTo(VAL_TRUE) == 0) {
            task.setActive(true);
            taskList.setActive(task, true);
        } else {
            task.setActive(false);
        }
        if (element.hasAttribute(KEY_ISSUEURL)) {
            task.setTaskUrl(element.getAttribute(KEY_ISSUEURL));
        } else {
            task.setTaskUrl("");
        }
        if (element.hasAttribute(KEY_NOTES)) {
            task.setNotes(element.getAttribute(KEY_NOTES));
        } else {
            task.setNotes("");
        }
        if (element.hasAttribute(KEY_TIME_ESTIMATED)) {
            String est = element.getAttribute(KEY_TIME_ESTIMATED);
            try {
                int estimate = Integer.parseInt(est);
                task.setEstimatedTimeHours(estimate);
            }
            catch (Exception exception) {
                task.setEstimatedTimeHours(0);
            }
        } else {
            task.setEstimatedTimeHours(0);
        }
        if (element.getAttribute(KEY_COMPLETE).compareTo(VAL_TRUE) == 0) {
            task.setCompleted(true);
        } else {
            task.setCompleted(false);
        }
        if (element.hasAttribute(KEY_DATE_END)) {
            task.setCompletionDate(this.getDateFromString(element.getAttribute(KEY_DATE_END)));
        } else {
            task.setCompletionDate(null);
        }
        if (element.hasAttribute(KEY_DATE_CREATION)) {
            task.setCreationDate(this.getDateFromString(element.getAttribute(KEY_DATE_CREATION)));
        } else {
            task.setCreationDate(Calendar.getInstance().getTime());
        }
        if (element.hasAttribute(KEY_DATE_DUE)) {
            task.setDueDate(this.getDateFromString(element.getAttribute(KEY_DATE_DUE)));
        } else {
            task.setDueDate(null);
        }
        if (element.hasAttribute(KEY_DATE_REMINDER)) {
            task.setScheduledForDate(this.getDateFromString(element.getAttribute(KEY_DATE_REMINDER)));
        } else {
            task.setScheduledForDate(null);
        }
        if (element.hasAttribute(KEY_REMINDED) && element.getAttribute(KEY_REMINDED).compareTo(VAL_TRUE) == 0) {
            task.setReminded(true);
        } else {
            task.setReminded(false);
        }
        if (task instanceof AbstractRepositoryTask) {
            AbstractRepositoryTask abstractTask = (AbstractRepositoryTask)task;
            abstractTask.setCurrentlySynchronizing(false);
            if (element.hasAttribute(KEY_REPOSITORY_URL)) {
                abstractTask.setRepositoryUrl(element.getAttribute(KEY_REPOSITORY_URL));
            }
            if (element.hasAttribute(KEY_LAST_MOD_DATE) && !element.getAttribute(KEY_LAST_MOD_DATE).equals("")) {
                abstractTask.setLastSyncDateStamp(element.getAttribute(KEY_LAST_MOD_DATE));
            }
            if (element.hasAttribute(KEY_OWNER)) {
                abstractTask.setOwner(element.getAttribute(KEY_OWNER));
            }
            if (VAL_TRUE.equals(element.getAttribute(KEY_NOTIFIED_INCOMING))) {
                abstractTask.setNotified(true);
            } else {
                abstractTask.setNotified(false);
            }
            if (element.hasAttribute(KEY_SYNC_STATE)) {
                String syncState = element.getAttribute(KEY_SYNC_STATE);
                if (syncState.compareTo(AbstractRepositoryTask.RepositoryTaskSyncState.SYNCHRONIZED.toString()) == 0) {
                    abstractTask.setSyncState(AbstractRepositoryTask.RepositoryTaskSyncState.SYNCHRONIZED);
                } else if (syncState.compareTo(AbstractRepositoryTask.RepositoryTaskSyncState.INCOMING.toString()) == 0) {
                    abstractTask.setSyncState(AbstractRepositoryTask.RepositoryTaskSyncState.INCOMING);
                } else if (syncState.compareTo(AbstractRepositoryTask.RepositoryTaskSyncState.OUTGOING.toString()) == 0) {
                    abstractTask.setSyncState(AbstractRepositoryTask.RepositoryTaskSyncState.OUTGOING);
                } else if (syncState.compareTo(AbstractRepositoryTask.RepositoryTaskSyncState.CONFLICT.toString()) == 0) {
                    abstractTask.setSyncState(AbstractRepositoryTask.RepositoryTaskSyncState.CONFLICT);
                }
            }
        }
    }

    protected Date getDateFromString(String dateString) {
        Date date = null;
        if ("".equals(dateString)) {
            return null;
        }
        String formatString = DATE_FORMAT;
        SimpleDateFormat format = new SimpleDateFormat(formatString, Locale.ENGLISH);
        try {
            date = format.parse(dateString);
        }
        catch (ParseException e) {
            MylarStatusHandler.fail((Throwable)e, (String)"Could not parse end date", (boolean)false);
        }
        return date;
    }

    @Override
    public String getCategoryTagName() {
        return KEY_TASK_CATEGORY;
    }

    @Override
    public String getTaskTagName() {
        return KEY_TASK;
    }

    @Override
    public boolean canCreateElementFor(AbstractRepositoryQuery query) {
        return false;
    }

    @Override
    public Element createQueryElement(AbstractRepositoryQuery query, Document doc, Element parent) {
        String queryTagName = this.getQueryTagNameForElement(query);
        Element node = doc.createElement(queryTagName);
        node.setAttribute(KEY_NAME, query.getSummary());
        node.setAttribute(KEY_QUERY_STRING, query.getUrl());
        node.setAttribute(KEY_REPOSITORY_URL, query.getRepositoryUrl());
        if (query.getLastRefreshTimeStamp() != null) {
            node.setAttribute(KEY_LAST_REFRESH, query.getLastRefreshTimeStamp());
        }
        for (AbstractRepositoryTask hit : query.getHits()) {
            try {
                this.createQueryHitElement(hit, doc, node);
            }
            catch (Exception e) {
                MylarStatusHandler.log((Throwable)e, (String)e.getMessage());
            }
        }
        parent.appendChild(node);
        return node;
    }

    @Override
    public boolean canReadQuery(Node node) {
        return false;
    }

    @Override
    public AbstractRepositoryQuery readQuery(Node node, TaskList tlist) throws TaskExternalizationException {
        return null;
    }

    @Override
    public String getQueryTagNameForElement(AbstractRepositoryQuery query) {
        return KEY_QUERY;
    }

    private String getQueryHitTagName() {
        return KEY_QUERY_HIT;
    }

    @Override
    public boolean canCreateElementFor(AbstractQueryHit queryHit) {
        return false;
    }

    public Element createQueryHitElement(AbstractRepositoryTask queryHit, Document doc, Element parent) {
        Element node = doc.createElement(this.getQueryHitTagName());
        node.setAttribute(KEY_HANDLE, queryHit.getHandleIdentifier());
        parent.appendChild(node);
        return node;
    }

    public boolean canReadQueryHit(Node node) {
        return false;
    }

    public final void readQueryHit(Element element, TaskList taskList, AbstractRepositoryQuery query) throws TaskExternalizationException {
        if (element.hasAttribute(KEY_HANDLE)) {
            String handle = element.getAttribute(KEY_HANDLE);
            ITask hit = taskList.getTask(handle);
            if (hit != null) {
                query.addHit((AbstractRepositoryTask)hit);
            }
        } else {
            throw new TaskExternalizationException("Handle not stored for repository task");
        }
    }

    public List<ITaskListExternalizer> getDelegateExternalizers() {
        return this.delegateExternalizers;
    }
}

