/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import org.eclipse.core.runtime.Status;
import org.eclipse.mylar.tasks.core.IMylarStatusConstants;

public class MylarStatus
extends Status
implements IMylarStatusConstants {
    private String htmlMessage;

    public MylarStatus(int severity, String pluginId, int code, String message) {
        super(severity, pluginId, code, message, null);
    }

    public MylarStatus(int severity, String pluginId, int code, String message, Throwable e) {
        super(severity, pluginId, code, message, e);
    }

    public String getMessage() {
        String message = super.getMessage();
        if (message != null && !"".equals(message)) {
            return message;
        }
        Throwable exception = this.getException();
        if (exception != null) {
            if (exception.getMessage() != null) {
                return exception.getMessage();
            }
            return exception.toString();
        }
        return "";
    }

    protected void setMessage(String message) {
        super.setMessage(message != null ? message : "");
    }

    protected void setHtmlMessage(String htmlMessage) {
        this.htmlMessage = htmlMessage;
    }

    public String getHtmlMessage() {
        return this.htmlMessage;
    }

    public boolean isHtmlMessage() {
        return this.htmlMessage != null;
    }

    public static MylarStatus createInternalError(String pluginId, String message, Throwable t) {
        return new MylarStatus(4, pluginId, 7, message, t);
    }

    public static MylarStatus createHtmlStatus(int severity, String pluginId, int code, String message, String htmlMessage) {
        if (htmlMessage == null) {
            throw new IllegalArgumentException("htmlMessage must not be null");
        }
        MylarStatus status = new MylarStatus(severity, pluginId, code, message);
        status.setHtmlMessage(htmlMessage);
        return status;
    }
}

