/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryOperation
implements Serializable {
    private static final long serialVersionUID = 3256442508174045236L;
    private String knob_name;
    private String optionName;
    private List<String> optionNames;
    private Map<String, String> options;
    private boolean hasOptions = false;
    private String op_name;
    private String op_sel;
    private boolean isChecked = false;
    private boolean isInput = false;
    private String inputName = null;
    private String inputValue = "";

    public RepositoryOperation(String knobName, String operationName) {
        this.knob_name = knobName;
        this.op_name = operationName;
    }

    public String getKnobName() {
        return this.knob_name;
    }

    public String getOperationName() {
        return this.op_name;
    }

    public boolean hasOptions() {
        return this.hasOptions;
    }

    public void setUpOptions(String optionName) {
        this.hasOptions = true;
        this.optionName = optionName;
        this.options = new HashMap<String, String>();
        this.optionNames = new ArrayList<String>();
    }

    public void addOption(String name, String value) {
        this.options.put(name, value);
        if (this.options.size() == 1) {
            this.op_sel = name;
        }
        this.optionNames.add(name);
    }

    public List<String> getOptionNames() {
        return this.optionNames;
    }

    public String getOptionSelection() {
        return this.op_sel;
    }

    public void setOptionSelection(String string) {
        this.op_sel = string;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean b) {
        this.isChecked = b;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public String getOptionValue(String option) {
        return this.options.get(option);
    }

    public boolean isInput() {
        return this.isInput;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.isInput = true;
        this.inputName = inputName;
    }

    public String getInputValue() {
        return this.inputValue == null ? "" : this.inputValue;
    }

    public void setInputValue(String inputValue) {
        this.inputValue = inputValue;
    }
}

