/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import org.eclipse.mylar.tasks.core.MylarStatus;
import org.eclipse.mylar.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;

public class RepositoryStatus
extends MylarStatus {
    private String repositoryUrl;

    public RepositoryStatus(TaskRepository repository, int severity, String pluginId, int code, String message) {
        this(repository.getUrl(), severity, pluginId, code, message, null);
    }

    public RepositoryStatus(TaskRepository repository, int severity, String pluginId, int code, String message, Throwable e) {
        this(repository.getUrl(), severity, pluginId, code, message, e);
    }

    public RepositoryStatus(String repositoryUrl, int severity, String pluginId, int code, String message) {
        this(repositoryUrl, severity, pluginId, code, message, null);
    }

    public RepositoryStatus(String repositoryUrl, int severity, String pluginId, int code, String message, Throwable e) {
        super(severity, pluginId, code, message, e);
        if (repositoryUrl == null) {
            throw new IllegalArgumentException("repositoryUrl must not be null");
        }
        this.repositoryUrl = repositoryUrl;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public static RepositoryStatus createStatus(TaskRepository repository, int severity, String pluginId, String message) {
        return RepositoryStatus.createStatus(repository.getUrl(), severity, pluginId, message);
    }

    public static RepositoryStatus createStatus(String repositoryUrl, int severity, String pluginId, String message) {
        return new RepositoryStatus(repositoryUrl, severity, pluginId, 1, message);
    }

    public static RepositoryStatus createLoginError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 3, NLS.bind((String)"Unable to login to {0}. Please validate credentials via Task Repositories view.", (Object)repositoryUrl));
    }

    public static RepositoryStatus createNotFoundError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 4, NLS.bind((String)"Repository {0} could not be found.", (Object)repositoryUrl));
    }

    public static RepositoryStatus createCollisionError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 6, NLS.bind((String)"Mid-air collision occurred while submitting to {0}.\n\nSynchronize task and re-submit changes.", (Object)repositoryUrl));
    }

    public static RepositoryStatus createCommentRequiredError(String repositoryUrl, String pluginId) {
        return new RepositoryStatus(repositoryUrl, 4, pluginId, 9, "You have to specify a new comment when making this change. Please comment on the reason for this change.");
    }

    public static RepositoryStatus createHtmlStatus(String repositoryUrl, int severity, String pluginId, int code, String message, String htmlMessage) {
        if (htmlMessage == null) {
            throw new IllegalArgumentException("htmlMessage must not be null");
        }
        RepositoryStatus status = new RepositoryStatus(repositoryUrl, severity, pluginId, code, message);
        status.setHtmlMessage(htmlMessage);
        return status;
    }
}

