/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task
extends PlatformObject
implements ITask {
    private static final String REPOSITORY_KIND_LOCAL = "local";
    public static final String DEFAULT_TASK_KIND = "task";
    private String handleIdentifier = "-1";
    private boolean active = false;
    private boolean category = false;
    private boolean hasReminded = false;
    private String summary;
    private String priority = PriorityLevel.getDefault().toString();
    private String notes = "";
    private int estimatedTimeHours = 1;
    private boolean completed;
    private String taskUrl = "";
    private AbstractTaskContainer parentCategory = null;
    private Date completionDate = null;
    private Date creationDate = null;
    private Date scheduledForDate = null;
    private Date dueDate = null;
    private transient ITask parent;
    private Set<ITask> children = new HashSet<ITask>();
    protected String kind = "task";

    public String toString() {
        return this.summary;
    }

    public Task(String handle, String summary) {
        this.handleIdentifier = handle;
        this.summary = summary;
    }

    @Override
    public String getHandleIdentifier() {
        return this.handleIdentifier;
    }

    @Override
    public ITask getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITask parent) {
        this.parent = parent;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Task && obj != null) {
            return this.getHandleIdentifier().compareTo(((Task)obj).getHandleIdentifier()) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.getHandleIdentifier().hashCode();
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public void setCompleted(boolean completed) {
        this.completed = completed;
        this.completionDate = completed ? new Date() : null;
    }

    public boolean isCategory() {
        return this.category;
    }

    public void setIsCategory(boolean category) {
        this.category = category;
    }

    @Override
    public String getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(String priority) {
        this.priority = priority;
    }

    @Override
    public void setTaskUrl(String url) {
        this.taskUrl = url;
    }

    @Override
    public String getTaskUrl() {
        return this.taskUrl;
    }

    @Override
    public String getNotes() {
        if (this.notes == null) {
            this.notes = "";
        }
        return this.notes;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public int getEstimateTimeHours() {
        return this.estimatedTimeHours;
    }

    @Override
    public void setEstimatedTimeHours(int estimated) {
        this.estimatedTimeHours = estimated;
    }

    @Override
    public Set<ITask> getChildren() {
        return this.children;
    }

    @Override
    public void addSubTask(ITask t) {
        this.children.add(t);
    }

    @Override
    public void removeSubTask(ITask t) {
        this.children.remove(t);
    }

    public void dropSubTasks() {
        this.children.clear();
    }

    @Override
    public void setContainer(AbstractTaskContainer cat) {
        this.parentCategory = cat;
    }

    @Override
    public AbstractTaskContainer getContainer() {
        return this.parentCategory;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    public boolean isLocal() {
        return true;
    }

    @Override
    public Date getCompletionDate() {
        return this.completionDate;
    }

    @Override
    public void setScheduledForDate(Date date) {
        this.scheduledForDate = date;
    }

    @Override
    public Date getScheduledForDate() {
        return this.scheduledForDate;
    }

    @Override
    public boolean hasBeenReminded() {
        return this.hasReminded;
    }

    @Override
    public void setReminded(boolean reminded) {
        this.hasReminded = reminded;
    }

    @Override
    public Date getCreationDate() {
        if (this.creationDate == null) {
            this.creationDate = new Date();
        }
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    @Override
    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    @Override
    public boolean isPastReminder() {
        if (this.scheduledForDate == null) {
            return false;
        }
        Date now = new Date();
        return this.scheduledForDate.compareTo(now) < 0;
    }

    @Override
    public boolean hasValidUrl() {
        String taskUrl = this.getTaskUrl();
        if (!(taskUrl == null || taskUrl.equals("") || taskUrl.equals("http://") || taskUrl.equals("https://"))) {
            try {
                new URL(taskUrl);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return false;
    }

    public String getRepositoryKind() {
        return REPOSITORY_KIND_LOCAL;
    }

    @Override
    public String getTaskKind() {
        return this.kind;
    }

    @Override
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    public int compareTo(ITaskListElement taskListElement) {
        return this.summary.compareTo(((Task)taskListElement).summary);
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public void setDueDate(Date date) {
        this.dueDate = date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PriorityLevel {
        P1,
        P2,
        P3,
        P4,
        P5;


        public String toString() {
            switch (this) {
                case P1: {
                    return "P1";
                }
                case P2: {
                    return "P2";
                }
                case P3: {
                    return "P3";
                }
                case P4: {
                    return "P4";
                }
                case P5: {
                    return "P5";
                }
            }
            return "P3";
        }

        public String getDescription() {
            switch (this) {
                case P1: {
                    return "Very High";
                }
                case P2: {
                    return "High";
                }
                case P3: {
                    return "Normal";
                }
                case P4: {
                    return "Low";
                }
                case P5: {
                    return "Very Low";
                }
            }
            return "";
        }

        public static PriorityLevel fromString(String string) {
            if (string.equals("P1")) {
                return P1;
            }
            if (string.equals("P2")) {
                return P2;
            }
            if (string.equals("P3")) {
                return P3;
            }
            if (string.equals("P4")) {
                return P4;
            }
            if (string.equals("P5")) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel fromDescription(String string) {
            if (string == null) {
                return null;
            }
            if (string.equals("Very High")) {
                return P1;
            }
            if (string.equals("High")) {
                return P2;
            }
            if (string.equals("Normal")) {
                return P3;
            }
            if (string.equals("Low")) {
                return P4;
            }
            if (string.equals("Very Low")) {
                return P5;
            }
            return PriorityLevel.getDefault();
        }

        public static PriorityLevel getDefault() {
            return P3;
        }
    }
}

