/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylar.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.AbstractTaskContainer;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskListChangeListener;
import org.eclipse.mylar.tasks.core.ITaskListElement;
import org.eclipse.mylar.tasks.core.Task;
import org.eclipse.mylar.tasks.core.TaskArchive;
import org.eclipse.mylar.tasks.core.TaskCategory;
import org.eclipse.mylar.tasks.core.UncategorizedCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskList {
    private int lastTaskNum = 0;
    private Set<ITaskListChangeListener> changeListeners = new CopyOnWriteArraySet<ITaskListChangeListener>();
    private Map<String, ITask> tasks;
    private Map<String, AbstractTaskContainer> categories;
    private Map<String, AbstractRepositoryQuery> queries;
    private TaskArchive archiveContainer;
    private UncategorizedCategory uncategorizedCategory;
    private List<ITask> activeTasks;

    public TaskList() {
        this.reset();
    }

    public void reset() {
        this.tasks = new ConcurrentHashMap<String, ITask>();
        this.categories = new ConcurrentHashMap<String, AbstractTaskContainer>();
        this.queries = new ConcurrentHashMap<String, AbstractRepositoryQuery>();
        this.archiveContainer = new TaskArchive(this);
        this.uncategorizedCategory = new UncategorizedCategory(this);
        this.activeTasks = new CopyOnWriteArrayList<ITask>();
        this.lastTaskNum = 0;
        this.categories.put(this.uncategorizedCategory.getHandleIdentifier(), this.uncategorizedCategory);
        this.categories.put(this.archiveContainer.getHandleIdentifier(), this.archiveContainer);
    }

    public void addTask(ITask task) {
        this.addTask(task, this.archiveContainer);
        for (ITask subTask : task.getChildren()) {
            this.addTask(subTask, this.archiveContainer);
        }
    }

    public Set<ITask> getTasks(Set<String> handles) {
        HashSet<ITask> result = new HashSet<ITask>();
        Map<String, ITask> tempTasks = Collections.unmodifiableMap(this.tasks);
        for (String handle : handles) {
            ITask tempTask = tempTasks.get(handle);
            if (tempTask == null) continue;
            result.add(tempTask);
        }
        return result;
    }

    public void addTask(ITask task, AbstractTaskContainer category) {
        this.tasks.put(task.getHandleIdentifier(), task);
        if (category != null) {
            category.add(task);
            task.setContainer(category);
        } else {
            this.uncategorizedCategory.add(task);
            task.setContainer(this.uncategorizedCategory);
        }
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.taskAdded(task);
        }
    }

    public void refactorRepositoryUrl(String oldRepositoryUrl, String newRepositoryUrl) {
        for (ITask task : this.tasks.values()) {
            AbstractRepositoryTask repositoryTask;
            if (!(task instanceof AbstractRepositoryTask) || !oldRepositoryUrl.equals(RepositoryTaskHandleUtil.getRepositoryUrl((repositoryTask = (AbstractRepositoryTask)task).getHandleIdentifier()))) continue;
            this.tasks.remove(repositoryTask.getHandleIdentifier());
            repositoryTask.setRepositoryUrl(newRepositoryUrl);
            this.tasks.put(repositoryTask.getHandleIdentifier(), repositoryTask);
            String taskUrl = repositoryTask.getTaskUrl();
            if (!taskUrl.startsWith(oldRepositoryUrl)) continue;
            repositoryTask.setTaskUrl(String.valueOf(newRepositoryUrl) + taskUrl.substring(oldRepositoryUrl.length()));
        }
        for (AbstractRepositoryQuery query : this.queries.values()) {
            if (!query.getRepositoryUrl().equals(oldRepositoryUrl)) continue;
            query.setRepositoryUrl(newRepositoryUrl);
            for (ITaskListChangeListener listener : this.changeListeners) {
                listener.containerInfoChanged(query);
            }
        }
    }

    public void moveToRoot(ITask task) {
        this.moveToContainer(this.uncategorizedCategory, task);
    }

    public void moveToContainer(AbstractTaskContainer toContainer, ITask task) {
        AbstractTaskContainer fromContainer;
        if (!this.tasks.containsKey(task.getHandleIdentifier())) {
            this.tasks.put(task.getHandleIdentifier(), task);
        }
        if ((fromContainer = task.getContainer()) instanceof AbstractTaskContainer) {
            fromContainer.remove(task);
        }
        if (toContainer != null) {
            this.internalAddTask(task, toContainer);
        } else {
            this.internalAddTask(task, this.archiveContainer);
        }
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.taskMoved(task, fromContainer, toContainer);
        }
    }

    public void addCategory(AbstractTaskContainer category) {
        this.categories.put(category.getHandleIdentifier(), category);
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containerAdded(category);
        }
    }

    public void removeFromCategory(TaskCategory category, ITask task) {
        this.moveToContainer(this.archiveContainer, task);
    }

    public void removeFromRoot(ITask task) {
        this.moveToContainer(this.archiveContainer, task);
    }

    public void renameTask(Task task, String description) {
        task.setSummary(description);
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.localInfoChanged(task);
        }
    }

    public void renameContainer(AbstractTaskContainer container, String newDescription) {
        if (!(container instanceof TaskArchive) && !(container instanceof UncategorizedCategory)) {
            if (this.queries.remove(container.getHandleIdentifier()) != null) {
                container.setDescription(newDescription);
                if (container instanceof AbstractRepositoryQuery) {
                    this.addQuery((AbstractRepositoryQuery)container);
                }
            } else if (this.categories.remove(container.getHandleIdentifier()) != null) {
                container.setDescription(newDescription);
                this.addCategory(container);
            }
        }
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containerInfoChanged(container);
        }
    }

    public void addQuery(AbstractRepositoryQuery query) {
        this.queries.put(query.getHandleIdentifier(), query);
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containerAdded(query);
        }
    }

    public void deleteTask(ITask task) {
        this.archiveContainer.remove(task);
        this.uncategorizedCategory.remove(task);
        if (task.getContainer() != null) {
            task.getContainer().remove(task);
            task.setContainer(null);
        }
        this.tasks.remove(task.getHandleIdentifier());
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.taskDeleted(task);
        }
    }

    public void deleteCategory(AbstractTaskContainer category) {
        for (ITask task : category.getChildren()) {
            this.uncategorizedCategory.add(task);
        }
        this.categories.remove(category.getHandleIdentifier());
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containerDeleted(category);
        }
    }

    public void deleteQuery(AbstractRepositoryQuery query) {
        this.queries.remove(query.getHandleIdentifier());
        for (ITaskListChangeListener listener : this.changeListeners) {
            listener.containerDeleted(query);
        }
    }

    public void markComplete(ITask task, boolean complete) {
        task.setCompleted(complete);
        for (ITaskListChangeListener listener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            listener.localInfoChanged(task);
        }
    }

    public void addChangeListener(ITaskListChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ITaskListChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void internalAddCategory(AbstractTaskContainer category) {
        this.categories.put(category.getHandleIdentifier(), category);
    }

    public void internalAddTask(ITask task, AbstractTaskContainer container) {
        this.tasks.put(task.getHandleIdentifier(), task);
        if (container != null) {
            task.setContainer(container);
            container.add(task);
        } else {
            task.setContainer(this.uncategorizedCategory);
            this.uncategorizedCategory.add(task);
        }
    }

    public void internalAddRootTask(ITask task) {
        this.internalAddTask(task, this.uncategorizedCategory);
    }

    public void internalAddQuery(AbstractRepositoryQuery query) {
        this.queries.put(query.getHandleIdentifier(), query);
    }

    public void setActive(ITask task, boolean active) {
        task.setActive(active);
        if (active && !this.activeTasks.contains(task)) {
            this.activeTasks.add(task);
        } else if (!active) {
            this.activeTasks.remove(task);
        }
    }

    public List<ITask> getActiveTasks() {
        return this.activeTasks;
    }

    public ITask getActiveTask() {
        if (this.activeTasks.size() > 0) {
            return this.activeTasks.get(0);
        }
        return null;
    }

    public Set<ITask> getRootTasks() {
        return Collections.unmodifiableSet(this.uncategorizedCategory.getChildren());
    }

    public Set<AbstractTaskContainer> getCategories() {
        return Collections.unmodifiableSet(new HashSet<AbstractTaskContainer>(this.categories.values()));
    }

    public List<AbstractTaskContainer> getUserCategories() {
        ArrayList<AbstractTaskContainer> included = new ArrayList<AbstractTaskContainer>();
        for (AbstractTaskContainer category : this.categories.values()) {
            if (category instanceof TaskArchive) continue;
            included.add(category);
        }
        return included;
    }

    public Set<AbstractRepositoryQuery> getQueries() {
        return Collections.unmodifiableSet(new HashSet<AbstractRepositoryQuery>(this.queries.values()));
    }

    public Set<ITaskListElement> getRootElements() {
        HashSet<ITaskListElement> roots = new HashSet<ITaskListElement>();
        roots.add(this.uncategorizedCategory);
        for (AbstractTaskContainer cat : this.categories.values()) {
            roots.add(cat);
        }
        for (AbstractRepositoryQuery query : this.queries.values()) {
            roots.add(query);
        }
        return roots;
    }

    public Collection<ITask> getAllTasks() {
        return Collections.unmodifiableCollection(this.tasks.values());
    }

    public Set<AbstractTaskContainer> getTaskContainers() {
        HashSet<AbstractTaskContainer> containers = new HashSet<AbstractTaskContainer>();
        for (AbstractTaskContainer container : this.categories.values()) {
            if (!(container instanceof TaskCategory) && !(container instanceof TaskArchive) && !(container instanceof UncategorizedCategory)) continue;
            containers.add(container);
        }
        return containers;
    }

    public AbstractRepositoryQuery getQueryForHandle(String handle) {
        if (handle == null) {
            return null;
        }
        for (AbstractRepositoryQuery query : this.queries.values()) {
            if (!query.contains(handle)) continue;
            return query;
        }
        return null;
    }

    public boolean isEmpty() {
        boolean archiveIsEmpty;
        boolean bl = archiveIsEmpty = this.getCategories().size() == 2 && this.getCategories().iterator().next().equals(this.archiveContainer) && this.archiveContainer.getChildren().isEmpty();
        return this.getAllTasks().size() == 0 && archiveIsEmpty && this.getQueries().size() == 0;
    }

    public ITask getTask(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        return this.tasks.get(handleIdentifier);
    }

    public AbstractRepositoryTask getTask(String repositoryUrl, String taskId) {
        String handle = RepositoryTaskHandleUtil.getHandle(repositoryUrl, taskId);
        ITask task = this.getTask(handle);
        if (task instanceof AbstractRepositoryTask) {
            return (AbstractRepositoryTask)task;
        }
        return null;
    }

    public AbstractRepositoryTask getRepositoryTask(String taskUrl) {
        for (ITask currTask : this.tasks.values()) {
            String currUrl;
            if (!(currTask instanceof AbstractRepositoryTask) || (currUrl = ((AbstractRepositoryTask)currTask).getTaskUrl()) == null || currUrl.equals("") || !currUrl.equals(taskUrl)) continue;
            return (AbstractRepositoryTask)currTask;
        }
        return null;
    }

    public AbstractTaskContainer getContainerForHandle(String categoryHandle) {
        for (AbstractTaskContainer cat : this.categories.values()) {
            if (!(cat instanceof AbstractTaskContainer) || !cat.getHandleIdentifier().equals(categoryHandle)) continue;
            return cat;
        }
        return null;
    }

    public AbstractTaskContainer getUncategorizedCategory() {
        return this.uncategorizedCategory;
    }

    public TaskArchive getArchiveContainer() {
        return this.archiveContainer;
    }

    public Set<AbstractRepositoryQuery> getQueriesForHandle(String handle) {
        if (handle == null) {
            return Collections.emptySet();
        }
        HashSet<AbstractRepositoryQuery> queriesForHandle = new HashSet<AbstractRepositoryQuery>();
        for (AbstractRepositoryQuery query : this.queries.values()) {
            if (!query.contains(handle)) continue;
            queriesForHandle.add(query);
        }
        return queriesForHandle;
    }

    public Set<AbstractRepositoryQuery> getRepositoryQueries(String repositoryUrl) {
        HashSet<AbstractRepositoryQuery> repositoryQueries = new HashSet<AbstractRepositoryQuery>();
        if (repositoryUrl != null) {
            for (AbstractRepositoryQuery query : this.queries.values()) {
                if (!query.getRepositoryUrl().equals(repositoryUrl)) continue;
                repositoryQueries.add(query);
            }
        }
        return repositoryQueries;
    }

    public Set<AbstractRepositoryTask> getRepositoryTasks(String repositoryUrl) {
        HashSet<AbstractRepositoryTask> repositoryTasks = new HashSet<AbstractRepositoryTask>();
        if (repositoryUrl != null) {
            for (ITask task : this.tasks.values()) {
                AbstractRepositoryTask repositoryTask;
                if (!(task instanceof AbstractRepositoryTask) || !(repositoryTask = (AbstractRepositoryTask)task).getRepositoryUrl().equals(repositoryUrl)) continue;
                repositoryTasks.add(repositoryTask);
            }
        }
        return repositoryTasks;
    }

    public Set<ITaskListChangeListener> getChangeListeners() {
        return Collections.unmodifiableSet(this.changeListeners);
    }

    public void notifyLocalInfoChanged(ITask task) {
        for (ITaskListChangeListener listener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            try {
                listener.localInfoChanged(task);
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)("notification failed for: " + listener), (boolean)false);
            }
        }
    }

    public void notifyRepositoryInfoChanged(ITask task) {
        for (ITaskListChangeListener listener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            try {
                listener.repositoryInfoChanged(task);
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)("notification failed for: " + listener), (boolean)false);
            }
        }
    }

    public void notifyContainerUpdated(AbstractTaskContainer container) {
        for (ITaskListChangeListener listener : new ArrayList<ITaskListChangeListener>(this.changeListeners)) {
            try {
                listener.containerInfoChanged(container);
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)("notification failed for: " + listener), (boolean)false);
            }
        }
    }

    public int getNextTaskNum() {
        return ++this.lastTaskNum;
    }

    public void setLastTaskNum(int lastTaskNum) {
        this.lastTaskNum = lastTaskNum;
    }

    public int getLastTaskNum() {
        return this.lastTaskNum;
    }

    public int findLargestTaskHandle() {
        int max = 0;
        max = Math.max(this.largestTaskHandleHelper(this.tasks.values()), max);
        for (AbstractTaskContainer cat : this.getTaskContainers()) {
            max = Math.max(this.largestTaskHandleHelper(cat.getChildren()), max);
        }
        return max;
    }

    private int largestTaskHandleHelper(Collection<ITask> tasks) {
        int ihandle = 0;
        int max = 0;
        for (ITask task : tasks) {
            if (!(task instanceof AbstractRepositoryTask)) {
                String string = task.getHandleIdentifier().substring(task.getHandleIdentifier().lastIndexOf(45) + 1, task.getHandleIdentifier().length());
                try {
                    ihandle = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            max = Math.max(ihandle, max);
            ihandle = this.largestTaskHandleHelper(task.getChildren());
            max = Math.max(ihandle, max);
        }
        return max;
    }
}

