/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.core.net.WebClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepository {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    public static final String AUTH_PASSWORD = "org.eclipse.mylar.tasklist.repositories.password";
    public static final String AUTH_USERNAME = "org.eclipse.mylar.tasklist.repositories.username";
    public static final String ANONYMOUS_LOGIN = "org.eclipse.mylar.tasklist.repositories.anonymous";
    public static final String AUTH_HTTP_PASSWORD = "org.eclipse.mylar.tasklist.repositories.httpauth.password";
    public static final String AUTH_HTTP_USERNAME = "org.eclipse.mylar.tasklist.repositories.httpauth.username";
    public static final String NO_VERSION_SPECIFIED = "unknown";
    private static final String AUTH_SCHEME = "Basic";
    private static final String AUTH_REALM = "";
    private static final URL DEFAULT_URL;
    public static final String PROXY_USEDEFAULT = "org.eclipse.mylar.tasklist.repositories.proxy.usedefault";
    public static final String PROXY_HOSTNAME = "org.eclipse.mylar.tasklist.repositories.proxy.hostname";
    public static final String PROXY_PORT = "org.eclipse.mylar.tasklist.repositories.proxy.port";
    public static final String PROXY_USERNAME = "org.eclipse.mylar.tasklist.repositories.proxy.username";
    public static final String PROXY_PASSWORD = "org.eclipse.mylar.tasklist.repositories.proxy.password";
    private static final Object LOCK;
    private static Map<String, Map<String, String>> credentials;
    private boolean isCachedUserName;
    private String cachedUserName;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private boolean isBugRepository = false;

    static {
        LOCK = new Object();
        credentials = new HashMap<String, Map<String, String>>();
        URL url = null;
        try {
            url = new URL("http://eclipse.org/mylar");
        }
        catch (Exception exception) {}
        DEFAULT_URL = url;
    }

    public TaskRepository(String kind, String serverUrl) {
        this(kind, serverUrl, NO_VERSION_SPECIFIED);
    }

    public TaskRepository(String kind, String serverUrl, String version) {
        this(kind, serverUrl, version, DEFAULT_CHARACTER_ENCODING, TimeZone.getDefault().getID());
    }

    public TaskRepository(String kind, String serverUrl, String version, String encoding, String timeZoneId) {
        this.properties.put("kind", kind);
        this.properties.put("url", serverUrl);
        this.properties.put("version", version);
        this.properties.put("encoding", encoding);
        this.properties.put("timezone", timeZoneId);
    }

    public TaskRepository(String kind, String serverUrl, Map<String, String> properties) {
        this.properties.put("kind", kind);
        this.properties.put("url", serverUrl);
        this.properties.putAll(properties);
    }

    public String getUrl() {
        return this.properties.get("url");
    }

    public void setUrl(String newUrl) {
        this.properties.put("url", newUrl);
    }

    public boolean hasCredentials() {
        String username = this.getUserName();
        String password = this.getPassword();
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }

    public String getUserName() {
        if (!this.isCachedUserName) {
            this.cachedUserName = this.getUserNameFromKeyRing();
            this.isCachedUserName = true;
        }
        return this.cachedUserName;
    }

    private String getUserNameFromKeyRing() {
        return this.getAuthInfo(AUTH_USERNAME);
    }

    public String getPassword() {
        return this.getAuthInfo(AUTH_PASSWORD);
    }

    public String getProxyUsername() {
        return this.getAuthInfo(PROXY_USERNAME);
    }

    public String getProxyPassword() {
        return this.getAuthInfo(PROXY_PASSWORD);
    }

    public String getHttpUser() {
        return this.getAuthInfo(AUTH_HTTP_USERNAME);
    }

    public String getHttpPassword() {
        return this.getAuthInfo(AUTH_HTTP_PASSWORD);
    }

    public void setAuthenticationCredentials(String username, String password) {
        this.setCredentials(username, password, AUTH_USERNAME, AUTH_PASSWORD);
        this.cachedUserName = username;
        this.isCachedUserName = true;
    }

    public void setProxyAuthenticationCredentials(String username, String password) {
        this.setCredentials(username, password, PROXY_USERNAME, PROXY_PASSWORD);
    }

    public void setHttpAuthenticationCredentials(String username, String password) {
        this.setCredentials(username, password, AUTH_HTTP_USERNAME, AUTH_HTTP_PASSWORD);
    }

    private void setCredentials(String username, String password, String userProperty, String passwordProperty) {
        Map<String, String> map = this.getAuthInfo();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (username != null) {
            map.put(userProperty, username);
        }
        if (password != null) {
            map.put(passwordProperty, password);
        }
        this.addAuthInfo(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAuthenticationCredentials() {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (Platform.isRunning()) {
                    try {
                        Platform.flushAuthorizationInfo((URL)new URL(this.getUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Platform.flushAuthorizationInfo((URL)DEFAULT_URL, (String)this.getUrl(), (String)AUTH_SCHEME);
                    }
                } else {
                    Map<String, String> headlessCreds = this.getAuthInfo();
                    headlessCreds.clear();
                }
                this.isCachedUserName = false;
            }
            catch (CoreException e) {
                MylarStatusHandler.fail((Throwable)e, (String)"could not flush authorization credentials", (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthInfo(Map<String, String> map) {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (Platform.isRunning()) {
                    try {
                        Platform.addAuthorizationInfo((URL)new URL(this.getUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME, map);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Platform.addAuthorizationInfo((URL)DEFAULT_URL, (String)this.getUrl(), (String)AUTH_SCHEME, map);
                    }
                } else {
                    Map<String, String> headlessCreds = this.getAuthInfo();
                    headlessCreds.putAll(map);
                }
            }
            catch (CoreException e) {
                MylarStatusHandler.fail((Throwable)e, (String)"Could not set authorization credentials", (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAuthInfo() {
        Object object = LOCK;
        synchronized (object) {
            if (Platform.isRunning()) {
                try {
                    return Platform.getAuthorizationInfo((URL)new URL(this.getUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                }
                catch (MalformedURLException malformedURLException) {
                    return Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)this.getUrl(), (String)AUTH_SCHEME);
                }
                catch (Exception e) {
                    MylarStatusHandler.fail((Throwable)e, (String)"Could not retrieve authentication credentials", (boolean)false);
                }
            } else {
                Map<String, String> headlessCreds = credentials.get(this.getUrl());
                if (headlessCreds == null) {
                    headlessCreds = new HashMap<String, String>();
                    credentials.put(this.getUrl(), headlessCreds);
                }
                return headlessCreds;
            }
            return null;
        }
    }

    private String getAuthInfo(String property) {
        Map<String, String> map = this.getAuthInfo();
        return map == null ? null : map.get(property);
    }

    public void clearCredentials() {
    }

    public boolean equals(Object object) {
        if (object instanceof TaskRepository && this.getUrl() != null) {
            return this.getUrl().equals(((TaskRepository)object).getUrl());
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.getUrl() != null) {
            return this.getUrl().hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return this.getUrl();
    }

    public String getKind() {
        String kind = this.properties.get("kind");
        if (kind != null) {
            return kind;
        }
        return "<unknown>";
    }

    public String getVersion() {
        String version = this.properties.get("version");
        return version == null || AUTH_REALM.equals(version) ? NO_VERSION_SPECIFIED : version;
    }

    public void setVersion(String ver) {
        this.properties.put("version", ver == null ? NO_VERSION_SPECIFIED : ver);
    }

    public String getCharacterEncoding() {
        String encoding = this.properties.get("encoding");
        return encoding == null || AUTH_REALM.equals(encoding) ? DEFAULT_CHARACTER_ENCODING : encoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.properties.put("encoding", characterEncoding == null ? DEFAULT_CHARACTER_ENCODING : characterEncoding);
    }

    public String getTimeZoneId() {
        String timeZoneId = this.properties.get("timezone");
        return timeZoneId == null || AUTH_REALM.equals(timeZoneId) ? TimeZone.getDefault().getID() : timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.properties.put("timezone", timeZoneId == null ? TimeZone.getDefault().getID() : timeZoneId);
    }

    public String getSyncTimeStamp() {
        return this.properties.get("lastsynctimestamp");
    }

    public void setSyncTimeStamp(String syncTime) {
        this.properties.put("lastsynctimestamp", syncTime);
    }

    public void setRepositoryLabel(String repositoryLabel) {
        this.properties.put("label", repositoryLabel);
    }

    public String getRepositoryLabel() {
        String label = this.properties.get("label");
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getUrl();
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean hasProperty(String name) {
        String value = this.getProperty(name);
        return value != null && value.trim().length() > 0;
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public Proxy getProxy() {
        Proxy proxy = Proxy.NO_PROXY;
        if (this.useDefaultProxy()) {
            proxy = WebClientUtil.getPlatformProxy();
        } else {
            String proxyHost = this.getProperty(PROXY_HOSTNAME);
            String proxyPort = this.getProperty(PROXY_PORT);
            String proxyUsername = AUTH_REALM;
            String proxyPassword = AUTH_REALM;
            if (proxyHost != null && proxyHost.length() > 0) {
                proxyUsername = this.getProxyUsername();
                proxyPassword = this.getProxyPassword();
            }
            proxy = WebClientUtil.getProxy((String)proxyHost, (String)proxyPort, (String)proxyUsername, (String)proxyPassword);
        }
        return proxy;
    }

    public boolean useDefaultProxy() {
        return "true".equals(this.getProperty(PROXY_USEDEFAULT));
    }

    public void setAnonymous(boolean b) {
        this.properties.put(ANONYMOUS_LOGIN, String.valueOf(b));
    }

    public boolean isAnonymous() {
        return this.getProperty(ANONYMOUS_LOGIN) == null || "true".equals(this.getProperty(ANONYMOUS_LOGIN));
    }

    public boolean isBugRepository() {
        return this.isBugRepository;
    }

    public void setBugRepository(boolean isBugRepository) {
        this.isBugRepository = isBugRepository;
    }
}

