/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylar.tasks.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylar.core.MylarStatusHandler;
import org.eclipse.mylar.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylar.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylar.tasks.core.AbstractRepositoryTask;
import org.eclipse.mylar.tasks.core.ITask;
import org.eclipse.mylar.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylar.tasks.core.TaskList;
import org.eclipse.mylar.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepositoryManager {
    public static final String OLD_REPOSITORIES_FILE = "repositories.xml";
    public static final String DEFAULT_REPOSITORIES_FILE = "repositories.xml.zip";
    public static final String PREF_REPOSITORIES = "org.eclipse.mylar.tasklist.repositories.";
    private Map<String, AbstractRepositoryConnector> repositoryConnectors = new HashMap<String, AbstractRepositoryConnector>();
    private Map<String, Set<TaskRepository>> repositoryMap = new HashMap<String, Set<TaskRepository>>();
    private Set<ITaskRepositoryListener> listeners = new HashSet<ITaskRepositoryListener>();
    private Set<TaskRepository> orphanedRepositories = new HashSet<TaskRepository>();
    public static final String MESSAGE_NO_REPOSITORY = "No repository available, please add one using the Task Repositories view.";
    public static final String PREFIX_LOCAL = "local-";
    private TaskRepositoriesExternalizer externalizer = new TaskRepositoriesExternalizer();
    private TaskList taskList;

    public TaskRepositoryManager(TaskList taskList) {
        this.taskList = taskList;
    }

    public Collection<AbstractRepositoryConnector> getRepositoryConnectors() {
        return Collections.unmodifiableCollection(this.repositoryConnectors.values());
    }

    public AbstractRepositoryConnector getRepositoryConnector(String kind) {
        return this.repositoryConnectors.get(kind);
    }

    public AbstractRepositoryConnector getRepositoryConnector(AbstractRepositoryTask task) {
        return this.getRepositoryConnector(task.getRepositoryKind());
    }

    public void addRepositoryConnector(AbstractRepositoryConnector repositoryConnector) {
        if (!this.repositoryConnectors.values().contains(repositoryConnector)) {
            repositoryConnector.init(this.taskList);
            this.repositoryConnectors.put(repositoryConnector.getRepositoryType(), repositoryConnector);
        }
    }

    public boolean hasUserManagedRepositoryConnectors() {
        for (AbstractRepositoryConnector connector : this.repositoryConnectors.values()) {
            if (!connector.isUserManaged()) continue;
            return true;
        }
        return false;
    }

    public void addRepository(TaskRepository repository, String repositoryFilePath) {
        Set<Object> repositories;
        if (!this.repositoryMap.containsKey(repository.getKind())) {
            repositories = new HashSet();
            this.repositoryMap.put(repository.getKind(), repositories);
        } else {
            repositories = this.repositoryMap.get(repository.getKind());
        }
        repositories.add(repository);
        this.saveRepositories(repositoryFilePath);
        for (ITaskRepositoryListener listener : this.listeners) {
            listener.repositoryAdded(repository);
        }
    }

    public void removeRepository(TaskRepository repository, String repositoryFilePath) {
        Set<TaskRepository> repositories = this.repositoryMap.get(repository.getKind());
        if (repositories != null) {
            repository.flushAuthenticationCredentials();
            repositories.remove(repository);
        }
        this.saveRepositories(repositoryFilePath);
        for (ITaskRepositoryListener listener : this.listeners) {
            listener.repositoryRemoved(repository);
        }
    }

    public void addListener(ITaskRepositoryListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITaskRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public static String stripSlashes(String url) {
        StringBuilder sb = new StringBuilder(url.trim());
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public TaskRepository getRepository(String kind, String urlString) {
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        if (this.repositoryMap.containsKey(kind)) {
            for (TaskRepository repository : this.repositoryMap.get(kind)) {
                if (!repository.getUrl().equals(urlString)) continue;
                return repository;
            }
        }
        return null;
    }

    public TaskRepository getRepository(String urlString) {
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        for (String kind : this.repositoryMap.keySet()) {
            for (TaskRepository repository : this.repositoryMap.get(kind)) {
                if (!repository.getUrl().equals(urlString)) continue;
                return repository;
            }
        }
        return null;
    }

    public AbstractRepositoryConnector getConnectorForRepositoryTaskUrl(String url) {
        for (AbstractRepositoryConnector connector : this.getRepositoryConnectors()) {
            if (connector.getRepositoryUrlFromTaskUrl(url) == null) continue;
            for (TaskRepository repository : this.getRepositories(connector.getRepositoryType())) {
                if (!url.startsWith(repository.getUrl())) continue;
                return connector;
            }
        }
        return null;
    }

    public Set<TaskRepository> getRepositories(String kind) {
        if (this.repositoryMap.containsKey(kind)) {
            return this.repositoryMap.get(kind);
        }
        return Collections.emptySet();
    }

    public List<TaskRepository> getAllRepositories() {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
            if (!this.repositoryMap.containsKey(repositoryConnector.getRepositoryType())) continue;
            repositories.addAll((Collection<TaskRepository>)this.repositoryMap.get(repositoryConnector.getRepositoryType()));
        }
        return repositories;
    }

    public TaskRepository getRepositoryForActiveTask(String repositoryKind, TaskList taskList) {
        ITask activeTask;
        List<ITask> activeTasks = taskList.getActiveTasks();
        if (activeTasks.size() == 1 && (activeTask = activeTasks.get(0)) instanceof AbstractRepositoryTask) {
            String repositoryUrl = ((AbstractRepositoryTask)activeTask).getRepositoryUrl();
            for (TaskRepository repository : this.getRepositories(repositoryKind)) {
                if (!repository.getUrl().equals(repositoryUrl)) continue;
                return repository;
            }
        }
        return null;
    }

    public TaskRepository getDefaultRepository(String kind) {
        if (this.repositoryMap.containsKey(kind)) {
            Iterator<TaskRepository> iterator = this.repositoryMap.get(kind).iterator();
            if (iterator.hasNext()) {
                TaskRepository repository = iterator.next();
                return repository;
            }
        } else {
            Collection<Set<TaskRepository>> values = this.repositoryMap.values();
            if (!values.isEmpty()) {
                Set<TaskRepository> repoistorySet = values.iterator().next();
                return repoistorySet.iterator().next();
            }
        }
        return null;
    }

    public Map<String, Set<TaskRepository>> readRepositories(String repositoriesFilePath) {
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
        this.loadRepositories(repositoriesFilePath);
        for (ITaskRepositoryListener listener : this.listeners) {
            try {
                listener.repositoriesRead();
            }
            catch (Throwable t) {
                MylarStatusHandler.fail((Throwable)t, (String)"repository listener failed", (boolean)false);
            }
        }
        return this.repositoryMap;
    }

    private void loadRepositories(String repositoriesFilePath) {
        try {
            boolean migration = false;
            File repositoriesFile = new File(repositoriesFilePath);
            for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
                this.repositoryMap.put(repositoryConnector.getRepositoryType(), new HashSet());
            }
            if (repositoriesFile.exists()) {
                Set<TaskRepository> repositories = this.externalizer.readRepositoriesFromXML(repositoriesFile);
                if (repositories != null && repositories.size() > 0) {
                    for (TaskRepository repository : repositories) {
                        if (this.removeHttpAuthMigration(repository)) {
                            migration = true;
                        }
                        if (this.migrateAnonymousRepository(repository)) {
                            migration = true;
                        }
                        if (this.repositoryMap.containsKey(repository.getKind())) {
                            this.repositoryMap.get(repository.getKind()).add(repository);
                            continue;
                        }
                        this.orphanedRepositories.add(repository);
                    }
                }
                if (migration) {
                    this.saveRepositories(repositoriesFilePath);
                }
            }
        }
        catch (Throwable t) {
            MylarStatusHandler.fail((Throwable)t, (String)"could not load repositories", (boolean)false);
        }
    }

    private boolean removeHttpAuthMigration(TaskRepository repository) {
        String httpusername = repository.getProperty("org.eclipse.mylar.tasklist.repositories.httpauth.username");
        String httppassword = repository.getProperty("org.eclipse.mylar.tasklist.repositories.httpauth.password");
        if (httpusername != null && httppassword != null) {
            repository.removeProperty("org.eclipse.mylar.tasklist.repositories.httpauth.username");
            repository.removeProperty("org.eclipse.mylar.tasklist.repositories.httpauth.password");
            if (httpusername.length() > 0 && httppassword.length() > 0) {
                repository.setHttpAuthenticationCredentials(httpusername, httppassword);
            }
            return true;
        }
        return false;
    }

    private boolean migrateAnonymousRepository(TaskRepository repository) {
        if (repository.getProperty("org.eclipse.mylar.tasklist.repositories.anonymous") == null) {
            if (repository.getUserName() == null || repository.getPassword() == null || "".equals(repository.getUserName()) && "".equals(repository.getPassword())) {
                repository.setAnonymous(true);
            } else {
                repository.setAnonymous(false);
            }
            return true;
        }
        return false;
    }

    public void setVersion(TaskRepository repository, String version, String repositoriesFilePath) {
        repository.setVersion(version);
        this.saveRepositories(repositoriesFilePath);
    }

    public void setEncoding(TaskRepository repository, String encoding, String repositoriesFilePath) {
        repository.setCharacterEncoding(encoding);
        this.saveRepositories(repositoriesFilePath);
    }

    public void setTimeZoneId(TaskRepository repository, String timeZoneId, String repositoriesFilePath) {
        repository.setTimeZoneId(timeZoneId);
        this.saveRepositories(repositoriesFilePath);
    }

    public void setSyncTime(TaskRepository repository, String syncTime, String repositoriesFilePath) {
        repository.setSyncTimeStamp(syncTime);
        this.saveRepositories(repositoriesFilePath);
    }

    public synchronized boolean saveRepositories(String destinationPath) {
        if (!Platform.isRunning()) {
            return false;
        }
        HashSet<TaskRepository> repositoriesToWrite = new HashSet<TaskRepository>(this.getAllRepositories());
        for (TaskRepository repository : this.orphanedRepositories) {
            if (repositoriesToWrite.contains(repository)) continue;
            repositoriesToWrite.add(repository);
        }
        try {
            File repositoriesFile = new File(destinationPath);
            this.externalizer.writeRepositoriesToXML(repositoriesToWrite, repositoriesFile);
        }
        catch (Throwable t) {
            MylarStatusHandler.fail((Throwable)t, (String)"could not save repositories", (boolean)false);
            return false;
        }
        return true;
    }

    public void clearRepositories(String repositoriesFilePath) {
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
        this.saveRepositories(repositoriesFilePath);
    }

    public void notifyRepositorySettingsChagned(TaskRepository repository) {
        for (ITaskRepositoryListener listener : this.listeners) {
            listener.repositorySettingsChanged(repository);
        }
    }
}

