/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientFactory;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaStatus;
import org.eclipse.mylyn.internal.bugzilla.core.IBugzillaConstants;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BugzillaRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String TOOLTIP_AUTODETECTION_ENABLED = "Override auto detection of Platform and OS for new bug reports.";
    private static final String TOOLTIP_AUTODETECTION_DISABLED = "Available once repository has been created.";
    private static final String TOOLTIP_CACHED_CONFIGURATION = "Use for repositories that explicitly state that they support this customization.";
    private static final String LABEL_CACHED_CONFIGURATION = "Cached configuration:";
    private static final String LABEL_SHORT_LOGINS = "Local users enabled:";
    public static final String LABEL_AUTOMATIC_VERSION = "Automatic (Use Validate Settings)";
    private static final String TITLE = "Bugzilla Repository Settings";
    private static final String DESCRIPTION = "Example: https://bugs.eclipse.org/bugs (do not include index.cgi)";
    protected Combo repositoryVersionCombo;
    protected Button autodetectPlatformOS;
    protected Combo defaultPlatformCombo;
    protected Combo defaultOSCombo;
    private Button cleanQAContact;
    private Button cachedConfigButton;
    private RepositoryConfiguration repositoryConfiguration = null;
    private String platform = null;
    private String os = null;

    public BugzillaRepositorySettingsPage(AbstractRepositoryConnectorUi repositoryUi) {
        super(TITLE, DESCRIPTION, repositoryUi);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsEncoding(true);
        this.setNeedsTimeZone(false);
        this.setNeedsHttpAuth(true);
    }

    protected void createAdditionalControls(Composite parent) {
        for (RepositoryTemplate template : this.connector.getTemplates()) {
            this.serverUrlCombo.add(template.label);
        }
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = BugzillaRepositorySettingsPage.this.serverUrlCombo.getText();
                RepositoryTemplate template = BugzillaRepositorySettingsPage.this.connector.getTemplate(text);
                if (template != null) {
                    BugzillaRepositorySettingsPage.this.repositoryLabelEditor.setStringValue(template.label);
                    BugzillaRepositorySettingsPage.this.setUrl(template.repositoryUrl);
                    BugzillaRepositorySettingsPage.this.setBugzillaVersion(template.version);
                    if (template.characterEncoding != null) {
                        BugzillaRepositorySettingsPage.this.setEncoding(template.characterEncoding);
                    }
                    BugzillaRepositorySettingsPage.this.getContainer().updateButtons();
                    return;
                }
            }
        });
        Label repositoryVersionLabel = new Label(parent, 0);
        repositoryVersionLabel.setText("Repository version: ");
        this.repositoryVersionCombo = new Combo(parent, 8);
        this.repositoryVersionCombo.add(LABEL_AUTOMATIC_VERSION);
        IBugzillaConstants.BugzillaServerVersion[] bugzillaServerVersionArray = IBugzillaConstants.BugzillaServerVersion.values();
        int n = bugzillaServerVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBugzillaConstants.BugzillaServerVersion version = bugzillaServerVersionArray[n2];
            this.repositoryVersionCombo.add(version.toString());
            ++n2;
        }
        if (this.repository != null && this.repositoryVersionCombo.indexOf(this.repository.getVersion()) >= 0) {
            this.repositoryVersionCombo.select(this.repositoryVersionCombo.indexOf(this.repository.getVersion()));
        } else {
            int defaultIndex = this.repositoryVersionCombo.indexOf(IBugzillaConstants.SERVER_VERSION_DEFAULT.toString());
            if (defaultIndex != -1) {
                this.repositoryVersionCombo.select(defaultIndex);
                this.setVersion(IBugzillaConstants.SERVER_VERSION_DEFAULT.toString());
            } else {
                defaultIndex = this.repositoryVersionCombo.getItemCount() - 1;
            }
            this.repositoryVersionCombo.select(defaultIndex);
            this.setVersion(this.repositoryVersionCombo.getItem(defaultIndex));
            this.isPageComplete();
            if (this.getWizard() != null) {
                this.getWizard().getContainer().updateButtons();
            }
        }
        this.repositoryVersionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaRepositorySettingsPage.this.repositoryVersionCombo.getSelectionIndex() >= 0) {
                    BugzillaRepositorySettingsPage.this.setVersion(BugzillaRepositorySettingsPage.this.repositoryVersionCombo.getItem(BugzillaRepositorySettingsPage.this.repositoryVersionCombo.getSelectionIndex()));
                    BugzillaRepositorySettingsPage.this.isPageComplete();
                    if (BugzillaRepositorySettingsPage.this.getWizard() != null) {
                        BugzillaRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label shortLoginLabel = new Label(parent, 0);
        shortLoginLabel.setText(LABEL_SHORT_LOGINS);
        this.cleanQAContact = new Button(parent, 16416);
        if (this.repository != null) {
            boolean shortLogin = Boolean.parseBoolean(this.repository.getProperty("bugzilla.shortLoginEnabled"));
            this.cleanQAContact.setSelection(shortLogin);
        }
        Label cachedConfigLabel = new Label(parent, 0);
        cachedConfigLabel.setText(LABEL_CACHED_CONFIGURATION);
        cachedConfigLabel.setToolTipText(TOOLTIP_CACHED_CONFIGURATION);
        this.cachedConfigButton = new Button(parent, 16416);
        if (this.repository != null) {
            boolean isCached = true;
            String oldTimestamp = this.repository.getProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp");
            if (oldTimestamp != null && oldTimestamp.equals("n/a")) {
                isCached = false;
            }
            this.cachedConfigButton.setSelection(isCached);
        }
        if (this.repository != null) {
            this.repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration((String)this.repository.getUrl());
            this.platform = this.repository.getProperty("bugzilla.default.platform");
            this.os = this.repository.getProperty("bugzilla.default.os");
        }
        Label defaultPlatformLabel = new Label(parent, 0);
        defaultPlatformLabel.setText("Autodetect platform and os");
        if (this.repository == null) {
            defaultPlatformLabel.setToolTipText(TOOLTIP_AUTODETECTION_DISABLED);
        } else {
            defaultPlatformLabel.setToolTipText(TOOLTIP_AUTODETECTION_ENABLED);
        }
        Composite platformOSContainer = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        platformOSContainer.setLayout((Layout)gridLayout);
        this.autodetectPlatformOS = new Button(platformOSContainer, 32);
        this.autodetectPlatformOS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BugzillaRepositorySettingsPage.this.autodetectPlatformOS.isEnabled() && BugzillaRepositorySettingsPage.this.repositoryConfiguration == null && !BugzillaRepositorySettingsPage.this.autodetectPlatformOS.getSelection()) {
                    try {
                        BugzillaRepositorySettingsPage.this.getWizard().getContainer().run(true, false, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    try {
                                        monitor.beginTask("Retrieving repository configuration", -1);
                                        BugzillaRepositorySettingsPage.this.repositoryConfiguration = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)BugzillaRepositorySettingsPage.this.repository, (boolean)false);
                                        if (BugzillaRepositorySettingsPage.this.repositoryConfiguration != null) {
                                            BugzillaRepositorySettingsPage.this.platform = BugzillaRepositorySettingsPage.this.repository.getProperty("bugzilla.default.platform");
                                            BugzillaRepositorySettingsPage.this.os = BugzillaRepositorySettingsPage.this.repository.getProperty("bugzilla.default.os");
                                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                                public void run() {
                                                    BugzillaRepositorySettingsPage.this.populatePlatformCombo();
                                                    BugzillaRepositorySettingsPage.this.populateOsCombo();
                                                }
                                            });
                                        }
                                    }
                                    catch (CoreException e) {
                                        throw new InvocationTargetException(e);
                                    }
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e1) {
                        if (e1.getCause() != null) {
                            BugzillaRepositorySettingsPage.this.setErrorMessage(e1.getCause().getMessage());
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                BugzillaRepositorySettingsPage.this.defaultPlatformCombo.setEnabled(!BugzillaRepositorySettingsPage.this.autodetectPlatformOS.getSelection());
                BugzillaRepositorySettingsPage.this.defaultOSCombo.setEnabled(!BugzillaRepositorySettingsPage.this.autodetectPlatformOS.getSelection());
            }
        });
        this.autodetectPlatformOS.setEnabled(this.repository != null);
        if (this.repository == null) {
            this.autodetectPlatformOS.setToolTipText(TOOLTIP_AUTODETECTION_DISABLED);
        } else {
            this.autodetectPlatformOS.setToolTipText(TOOLTIP_AUTODETECTION_ENABLED);
        }
        this.autodetectPlatformOS.setSelection(this.platform == null && this.os == null);
        this.defaultPlatformCombo = new Combo(platformOSContainer, 8);
        this.populatePlatformCombo();
        this.defaultOSCombo = new Combo(platformOSContainer, 8);
        this.populateOsCombo();
    }

    private void populateOsCombo() {
        if (this.repositoryConfiguration != null && this.defaultOSCombo != null) {
            this.defaultOSCombo.removeAll();
            List optionValues = this.repositoryConfiguration.getOSs();
            for (String option : optionValues) {
                this.defaultOSCombo.add(option.toString());
            }
            if (this.os != null && this.defaultOSCombo.indexOf(this.os) >= 0) {
                this.defaultOSCombo.select(this.defaultOSCombo.indexOf(this.os));
            } else {
                this.repository.removeProperty("bugzilla.default.os");
                this.defaultOSCombo.select(0);
            }
        } else {
            this.defaultOSCombo.add("All");
            this.defaultOSCombo.select(0);
        }
        this.defaultOSCombo.getParent().pack(true);
        this.defaultOSCombo.setEnabled(!this.autodetectPlatformOS.getSelection());
    }

    private void populatePlatformCombo() {
        if (this.repositoryConfiguration != null && this.defaultPlatformCombo != null) {
            this.defaultPlatformCombo.removeAll();
            List optionValues = this.repositoryConfiguration.getPlatforms();
            for (String option : optionValues) {
                this.defaultPlatformCombo.add(option.toString());
            }
            if (this.platform != null && this.defaultPlatformCombo.indexOf(this.platform) >= 0) {
                this.defaultPlatformCombo.select(this.defaultPlatformCombo.indexOf(this.platform));
            } else {
                this.repository.removeProperty("bugzilla.default.platform");
                this.defaultPlatformCombo.select(0);
            }
        } else {
            this.defaultPlatformCombo.add("All");
            this.defaultPlatformCombo.select(0);
        }
        this.defaultPlatformCombo.getParent().pack(true);
        this.defaultPlatformCombo.setEnabled(!this.autodetectPlatformOS.getSelection());
    }

    public void setBugzillaVersion(String version) {
        if (version == null) {
            this.repositoryVersionCombo.select(0);
        } else {
            int i = this.repositoryVersionCombo.indexOf(version.toString());
            if (i != -1) {
                this.repositoryVersionCombo.select(i);
                this.setVersion(version);
            } else {
                IBugzillaConstants.BugzillaServerVersion[] bugzillaServerVersionArray = IBugzillaConstants.BugzillaServerVersion.values();
                int n = bugzillaServerVersionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBugzillaConstants.BugzillaServerVersion serverVersion = bugzillaServerVersionArray[n2];
                    if (version.startsWith(serverVersion.toString()) && (i = this.repositoryVersionCombo.indexOf(serverVersion.toString())) != -1) {
                        this.repositoryVersionCombo.select(i);
                        this.setVersion(serverVersion.toString());
                        break;
                    }
                    ++n2;
                }
                if (i == -1) {
                    StatusHandler.log((String)("Could not resolve repository version: " + version), (Object)((Object)this));
                    i = this.repositoryVersionCombo.indexOf(IBugzillaConstants.SERVER_VERSION_DEFAULT.toString());
                    if (i != -1) {
                        this.repositoryVersionCombo.select(i);
                        this.setVersion(IBugzillaConstants.SERVER_VERSION_DEFAULT.toString());
                    }
                }
            }
        }
    }

    public void updateProperties(TaskRepository repository) {
        repository.setProperty("bugzilla.shortLoginEnabled", String.valueOf(this.cleanQAContact.getSelection()));
        if (this.cachedConfigButton.getSelection()) {
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", "");
        } else {
            repository.setProperty("org.eclipse.mylyn.tasklist.repositories.config.timestamp", "n/a");
        }
        if (!this.autodetectPlatformOS.getSelection()) {
            repository.setProperty("bugzilla.default.platform", String.valueOf(this.defaultPlatformCombo.getItem(this.defaultPlatformCombo.getSelectionIndex())));
            repository.setProperty("bugzilla.default.os", String.valueOf(this.defaultOSCombo.getItem(this.defaultOSCombo.getSelectionIndex())));
        } else {
            repository.removeProperty("bugzilla.default.platform");
            repository.removeProperty("bugzilla.default.os");
        }
    }

    public boolean isPageComplete() {
        boolean erg = super.isPageComplete();
        if (erg && this.getVersion().compareTo(LABEL_AUTOMATIC_VERSION) == 0) {
            this.setErrorMessage("Validate Settings or select repository version under Additional Settings section.");
            erg = false;
        }
        return erg;
    }

    protected boolean isValidUrl(String name) {
        if (name.startsWith("https://") || name.startsWith("http://")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        if (this.repositoryVersionCombo.getSelectionIndex() != 0) {
            return new BugzillaValidator(repository, this.repositoryVersionCombo.getItem(this.repositoryVersionCombo.getSelectionIndex()));
        }
        return new BugzillaValidator(repository, null);
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        super.applyValidatorResult(validator);
        if (((BugzillaValidator)validator).getResult() != null && ((BugzillaValidator)validator).getResult() != null) {
            this.setBugzillaVersion(((BugzillaValidator)validator).getResult());
        }
    }

    public class BugzillaValidator
    extends AbstractRepositorySettingsPage.Validator {
        final String serverUrl;
        final String newUserId;
        final String newPassword;
        final boolean isAnonymous;
        final String newEncoding;
        final String httpAuthUser;
        final String httpAuthPass;
        final Proxy proxy;
        private String[] versions;

        public BugzillaValidator(TaskRepository repository, String version) {
            super((AbstractRepositorySettingsPage)BugzillaRepositorySettingsPage.this);
            this.versions = new String[1];
            this.serverUrl = BugzillaRepositorySettingsPage.this.getServerUrl();
            this.newUserId = BugzillaRepositorySettingsPage.this.getUserName();
            this.newPassword = BugzillaRepositorySettingsPage.this.getPassword();
            this.isAnonymous = BugzillaRepositorySettingsPage.this.isAnonymousAccess();
            this.newEncoding = BugzillaRepositorySettingsPage.this.getCharacterEncoding();
            this.httpAuthUser = BugzillaRepositorySettingsPage.this.getHttpAuthUserId();
            this.httpAuthPass = BugzillaRepositorySettingsPage.this.getHttpAuthPassword();
            this.proxy = repository.getProxy();
            this.versions[0] = version;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                this.validate(monitor);
            }
            catch (Exception e) {
                this.displayError(this.serverUrl, e);
            }
        }

        private void displayError(String serverUrl, Throwable e) {
            Object status = e instanceof MalformedURLException ? new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 11, "Server URL is invalid.") : (e instanceof CoreException ? ((CoreException)e).getStatus() : (e instanceof IOException ? new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 5, serverUrl, e.getMessage()) : new BugzillaStatus(2, "org.eclipse.mylyn.bugzilla", 11, serverUrl, e.getMessage())));
            StatusHandler.displayStatus((String)"Validation failed", (IStatus)status);
            this.setStatus((IStatus)status);
        }

        public void validate(IProgressMonitor monitor) throws IOException, CoreException {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                RepositoryConfiguration config;
                boolean checkVersion;
                monitor.beginTask("Validating server settings", -1);
                BugzillaClient client = null;
                boolean bl = checkVersion = this.versions[0] == null;
                if (this.versions != null) {
                    client = BugzillaClientFactory.createClient((String)this.serverUrl, (String)this.newUserId, (String)this.newPassword, (String)this.httpAuthUser, (String)this.httpAuthPass, (Proxy)this.proxy, (String)this.newEncoding);
                    client.validate();
                }
                if (checkVersion && client != null && (config = client.getRepositoryConfiguration()) != null) {
                    this.versions[0] = config.getInstallVersion();
                }
            }
            finally {
                monitor.done();
            }
        }

        public String getResult() {
            return this.versions[0];
        }
    }
}

