/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.internal.context.ui.AbstractContextLabelProvider;
import org.eclipse.mylyn.internal.context.ui.ActiveSearchViewTracker;
import org.eclipse.mylyn.internal.context.ui.ColorMap;
import org.eclipse.mylyn.internal.context.ui.ContentOutlineManager;
import org.eclipse.mylyn.internal.context.ui.ContextPerspectiveManager;
import org.eclipse.mylyn.internal.context.ui.FocusedViewerManager;
import org.eclipse.mylyn.internal.context.ui.Highlighter;
import org.eclipse.mylyn.internal.context.ui.HighlighterList;
import org.eclipse.mylyn.internal.context.ui.actions.ContextRetrieveAction;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.ITaskHighlighter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskActivityListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUiPlugin
extends AbstractUIPlugin {
    private Map<String, AbstractContextUiBridge> bridges = new HashMap<String, AbstractContextUiBridge>();
    private Map<String, ILabelProvider> contextLabelProviders = new HashMap<String, ILabelProvider>();
    private static ContextUiPlugin INSTANCE;
    private HighlighterList highlighters = null;
    private ColorMap colorMap = new ColorMap();
    private FocusedViewerManager viewerManager;
    private ContextPerspectiveManager perspectiveManager = new ContextPerspectiveManager();
    private ContentOutlineManager contentOutlineManager = new ContentOutlineManager();
    private ActiveSearchViewTracker activeSearchViewTracker = new ActiveSearchViewTracker();
    private Map<AbstractContextUiBridge, ImageDescriptor> activeSearchIcons = new HashMap<AbstractContextUiBridge, ImageDescriptor>();
    private Map<AbstractContextUiBridge, String> activeSearchLabels = new HashMap<AbstractContextUiBridge, String>();
    private Map<String, Set<Class<?>>> preservedFilterClasses = new HashMap();
    private Map<String, Set<String>> preservedFilterIds = new HashMap<String, Set<String>>();
    private final ITaskHighlighter DEFAULT_HIGHLIGHTER = new ITaskHighlighter(){

        public Color getHighlightColor(AbstractTask task) {
            Highlighter highlighter = ContextUiPlugin.this.getHighlighterForContextId(task.getHandleIdentifier());
            if (highlighter != null) {
                return highlighter.getHighlightColor();
            }
            return null;
        }
    };
    private static final AbstractContextLabelProvider DEFAULT_LABEL_PROVIDER;
    private static final AbstractContextUiBridge DEFAULT_UI_BRIDGE;
    private static final ITaskActivityListener TASK_ACTIVATION_LISTENER;

    static {
        DEFAULT_LABEL_PROVIDER = new AbstractContextLabelProvider(){

            protected Image getImage(IInteractionElement node) {
                return null;
            }

            protected Image getImage(IInteractionRelation edge) {
                return null;
            }

            protected String getText(IInteractionElement node) {
                return "? " + node;
            }

            protected String getText(IInteractionRelation edge) {
                return "? " + edge;
            }

            protected Image getImageForObject(Object object) {
                return null;
            }

            protected String getTextForObject(Object node) {
                return "? " + node;
            }
        };
        DEFAULT_UI_BRIDGE = new AbstractContextUiBridge(){

            @Override
            public void open(IInteractionElement node) {
            }

            @Override
            public void close(IInteractionElement node) {
            }

            @Override
            public boolean acceptsEditor(IEditorPart editorPart) {
                return false;
            }

            @Override
            public List<TreeViewer> getContentOutlineViewers(IEditorPart editor) {
                return Collections.emptyList();
            }

            @Override
            public Object getObjectForTextSelection(TextSelection selection, IEditorPart editor) {
                return null;
            }

            @Override
            public IInteractionElement getElement(IEditorInput input) {
                return null;
            }

            @Override
            public String getContentType() {
                return null;
            }
        };
        TASK_ACTIVATION_LISTENER = new ITaskActivityListener(){

            public void activityChanged(ScheduledTaskContainer week) {
            }

            public void taskActivated(AbstractTask task) {
                boolean hasLocalContext = ContextCorePlugin.getContextManager().hasContext(task.getHandleIdentifier());
                if (!hasLocalContext) {
                    boolean getRemote;
                    AbstractTask repositoryTask = task;
                    AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryTask);
                    TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getRepositoryUrl());
                    if (connector != null && connector.getAttachmentHandler() != null && connector.getAttachmentHandler().hasRepositoryContext(repository, repositoryTask) && (getRemote = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"No local task context exists.  Retrieve from repository?"))) {
                        new ContextRetrieveAction().run(repositoryTask);
                    }
                }
            }

            public void taskDeactivated(AbstractTask task) {
            }

            public void taskListRead() {
            }
        };
    }

    public ContextUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializeDefaultPreferences(this.getPreferenceStore());
        this.initializeHighlighters();
        this.initializeActions();
        this.viewerManager = new FocusedViewerManager();
        this.perspectiveManager.addManagedPerspective("org.eclipse.mylyn.tasks.ui.perspectives.planning");
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)ContextUiPlugin.this.viewerManager);
                    MonitorUiPlugin.getDefault().addWindowPartListener((IPartListener)ContextUiPlugin.this.contentOutlineManager);
                    TasksUiPlugin.getDefault().setHighlighter(ContextUiPlugin.this.DEFAULT_HIGHLIGHTER);
                    TasksUiPlugin.getTaskListManager().addActivityListener((ITaskActivityListener)ContextUiPlugin.this.perspectiveManager);
                    MonitorUiPlugin.getDefault().addWindowPerspectiveListener((IPerspectiveListener)ContextUiPlugin.this.perspectiveManager);
                    TasksUiPlugin.getTaskListManager().addActivityListener(TASK_ACTIVATION_LISTENER);
                    workbench.addWindowListener((IWindowListener)ContextUiPlugin.this.activeSearchViewTracker);
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        windows[i].addPageListener((IPageListener)ContextUiPlugin.this.activeSearchViewTracker);
                        IWorkbenchPage[] pages = windows[i].getPages();
                        int j = 0;
                        while (j < pages.length) {
                            pages[j].addPartListener((IPartListener2)ContextUiPlugin.this.activeSearchViewTracker);
                            ++j;
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    StatusHandler.fail((Throwable)e, (String)"Context UI initialization failed", (boolean)true);
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            this.perspectiveManager.removeManagedPerspective("org.eclipse.mylyn.tasks.ui.perspectives.planning");
            ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.viewerManager);
            MonitorUiPlugin.getDefault().removeWindowPartListener((IPartListener)this.contentOutlineManager);
            TasksUiPlugin.getTaskListManager().removeActivityListener((ITaskActivityListener)this.perspectiveManager);
            MonitorUiPlugin.getDefault().removeWindowPerspectiveListener((IPerspectiveListener)this.perspectiveManager);
            TasksUiPlugin.getTaskListManager().removeActivityListener(TASK_ACTIVATION_LISTENER);
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null) {
                workbench.removeWindowListener((IWindowListener)this.activeSearchViewTracker);
                IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchPage[] pages = windows[i].getPages();
                    windows[i].removePageListener((IPageListener)this.activeSearchViewTracker);
                    int j = 0;
                    while (j < pages.length) {
                        pages[j].removePartListener((IPartListener2)this.activeSearchViewTracker);
                        ++j;
                    }
                    ++i;
                }
            }
            this.viewerManager.dispose();
            this.colorMap.dispose();
            this.highlighters.dispose();
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"Context UI stop failed", (boolean)false);
        }
    }

    private void initializeActions() {
    }

    private void initializeHighlighters() {
        String hlist = this.getPreferenceStore().getString("org.eclipse.mylyn.ui.interest.highlighters");
        if (hlist != null && hlist.length() != 0) {
            this.highlighters = new HighlighterList(hlist);
        } else {
            this.highlighters = new HighlighterList();
            this.highlighters.setToDefaultList();
            this.getPreferenceStore().setValue("org.eclipse.mylyn.ui.interest.highlighters", this.highlighters.externalizeToString());
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable", true);
        store.setDefault("org.eclipse.mylyn.ide.ui.perspectives.auto.manage", false);
        store.setDefault("org.eclipse.mylyn.context.ui.editors.auto.manage", true);
        store.setDefault("org.eclipse.mylyn.ide.ui.expansion.auto.manage", true);
        store.setDefault("org.eclipse.mylyn.context.ui.close.action.manage", true);
        store.setDefault("org.eclipse.mylyn.context.ui.close.action.manage.warning", true);
        store.setDefault("org.eclipse.mylyn.ui.gamma.lightened", false);
        store.setDefault("org.eclipse.mylyn.ui.gamma.standard", true);
        store.setDefault("org.eclipse.mylyn.ui.gamma.darkened", false);
    }

    public void setHighlighterMapping(String id, String name) {
        String prefId = "org.eclipse.mylyn.ui.interest.highlighters.task." + id;
        this.getPreferenceStore().putValue(prefId, name);
    }

    public static ContextUiPlugin getDefault() {
        return INSTANCE;
    }

    @Deprecated
    public static String getResourceString(String key) {
        ResourceBundle bundle = ContextUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    @Deprecated
    public static String getMessage(String key) {
        ResourceBundle bundle = ContextUiPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    @Deprecated
    public ResourceBundle getResourceBundle() {
        return null;
    }

    public List<AbstractContextUiBridge> getUiBridges() {
        UiExtensionPointReader.initExtensions();
        return new ArrayList<AbstractContextUiBridge>(this.bridges.values());
    }

    public AbstractContextUiBridge getUiBridge(String contentType) {
        UiExtensionPointReader.initExtensions();
        AbstractContextUiBridge bridge = this.bridges.get(contentType);
        if (bridge != null) {
            return bridge;
        }
        return DEFAULT_UI_BRIDGE;
    }

    public AbstractContextUiBridge getUiBridgeForEditor(IEditorPart editorPart) {
        UiExtensionPointReader.initExtensions();
        AbstractContextUiBridge foundBridge = null;
        for (AbstractContextUiBridge bridge : this.bridges.values()) {
            if (!bridge.acceptsEditor(editorPart)) continue;
            foundBridge = bridge;
            break;
        }
        if (foundBridge != null) {
            return foundBridge;
        }
        return DEFAULT_UI_BRIDGE;
    }

    private void internalAddBridge(String extension, AbstractContextUiBridge bridge) {
        this.bridges.put(extension, bridge);
    }

    public ILabelProvider getContextLabelProvider(String extension) {
        ILabelProvider provider = this.contextLabelProviders.get(extension);
        if (provider != null) {
            return provider;
        }
        return DEFAULT_LABEL_PROVIDER;
    }

    private void internalAddContextLabelProvider(String extension, ILabelProvider provider) {
        this.contextLabelProviders.put(extension, provider);
    }

    public Highlighter getHighlighter(String name) {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters.getHighlighter(name);
    }

    public Highlighter getHighlighterForContextId(String id) {
        String prefId = "org.eclipse.mylyn.ui.interest.highlighters.task." + id;
        String highlighterName = this.getPreferenceStore().getString(prefId);
        return this.getHighlighter(highlighterName);
    }

    public HighlighterList getHighlighterList() {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters;
    }

    public List<Highlighter> getHighlighters() {
        if (this.highlighters == null) {
            this.initializeHighlighters();
        }
        return this.highlighters.getHighlighters();
    }

    public static FocusedViewerManager getViewerManager() {
        return ContextUiPlugin.INSTANCE.viewerManager;
    }

    public String getPerspectiveIdFor(AbstractTask task) {
        if (task != null) {
            return this.getPreferenceStore().getString("org.eclipse.mylyn.ui.perspectives.task." + task.getHandleIdentifier());
        }
        return this.getPreferenceStore().getString("org.eclipse.mylyn.ui.perspectives.task.none");
    }

    public void setPerspectiveIdFor(AbstractTask task, String perspectiveId) {
        if (task != null) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.ui.perspectives.task." + task.getHandleIdentifier(), perspectiveId);
        } else {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.ui.perspectives.task.none", perspectiveId);
        }
    }

    private void setActiveSearchIcon(AbstractContextUiBridge bridge, ImageDescriptor descriptor) {
        this.activeSearchIcons.put(bridge, descriptor);
    }

    public ImageDescriptor getActiveSearchIcon(AbstractContextUiBridge bridge) {
        UiExtensionPointReader.initExtensions();
        return this.activeSearchIcons.get(bridge);
    }

    private void setActiveSearchLabel(AbstractContextUiBridge bridge, String label) {
        this.activeSearchLabels.put(bridge, label);
    }

    public String getActiveSearchLabel(AbstractContextUiBridge bridge) {
        UiExtensionPointReader.initExtensions();
        return this.activeSearchLabels.get(bridge);
    }

    public void addPreservedFilterClass(String viewId, ViewerFilter filter) {
        Set<Class<?>> preservedList = this.preservedFilterClasses.get(viewId);
        if (preservedList == null) {
            preservedList = new HashSet();
            this.preservedFilterClasses.put(viewId, preservedList);
        }
        preservedList.add(filter.getClass());
    }

    public Set<Class<?>> getPreservedFilterClasses(String viewId) {
        UiExtensionPointReader.initExtensions();
        if (this.preservedFilterClasses.containsKey(viewId)) {
            return this.preservedFilterClasses.get(viewId);
        }
        return Collections.emptySet();
    }

    public void addPreservedFilterId(String viewId, String filterId) {
        Set<String> preservedList = this.preservedFilterIds.get(viewId);
        if (preservedList == null) {
            preservedList = new HashSet<String>();
            this.preservedFilterIds.put(viewId, preservedList);
        }
        preservedList.add(filterId);
    }

    public Set<String> getPreservedFilterIds(String viewId) {
        UiExtensionPointReader.initExtensions();
        if (this.preservedFilterIds.containsKey(viewId)) {
            return this.preservedFilterIds.get(viewId);
        }
        return Collections.emptySet();
    }

    public static ContextPerspectiveManager getPerspectiveManager() {
        return ContextUiPlugin.INSTANCE.perspectiveManager;
    }

    static class UiExtensionPointReader {
        private static boolean extensionsRead = false;
        private static UiExtensionPointReader thisReader = new UiExtensionPointReader();
        public static final String EXTENSION_ID_CONTEXT = "org.eclipse.mylyn.context.ui.bridges";
        public static final String ELEMENT_UI_BRIDGE = "uiBridge";
        public static final String ELEMENT_PRESERVED_FILTERS = "preservedFilters";
        public static final String ELEMENT_VIEW_ID = "viewId";
        public static final String ELEMENT_ID = "id";
        public static final String ELEMENT_FILTER = "filter";
        public static final String ELEMENT_CLASS = "class";
        public static final String ELEMENT_UI_CONTEXT_LABEL_PROVIDER = "labelProvider";
        public static final String ELEMENT_UI_BRIDGE_CONTENT_TYPE = "contentType";
        public static final String ELEMENT_STRUCTURE_BRIDGE_SEARCH_ICON = "activeSearchIcon";
        public static final String ELEMENT_STRUCTURE_BRIDGE_SEARCH_LABEL = "activeSearchLabel";

        UiExtensionPointReader() {
        }

        public static void initExtensions() {
            if (!extensionsRead) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_CONTEXT);
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j].getName().equals(ELEMENT_UI_BRIDGE)) {
                            UiExtensionPointReader.readBridge(elements[j]);
                        } else if (elements[j].getName().equals(ELEMENT_UI_CONTEXT_LABEL_PROVIDER)) {
                            UiExtensionPointReader.readLabelProvider(elements[j]);
                        } else if (elements[j].getName().equals(ELEMENT_PRESERVED_FILTERS)) {
                            UiExtensionPointReader.readPreservedFilters(elements[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
                extensionsRead = true;
            }
        }

        private static void readLabelProvider(IConfigurationElement element) {
            try {
                Object provider = element.createExecutableExtension(ELEMENT_CLASS);
                String contentType = element.getAttribute(ELEMENT_UI_BRIDGE_CONTENT_TYPE);
                if (provider instanceof ILabelProvider && contentType != null) {
                    ContextUiPlugin.getDefault().internalAddContextLabelProvider(contentType, (ILabelProvider)provider);
                } else {
                    StatusHandler.log((String)("Could not load label provider: " + provider.getClass().getCanonicalName() + " must implement " + ILabelProvider.class.getCanonicalName()), (Object)thisReader);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((Throwable)e, (String)"Could not load label provider extension");
            }
        }

        private static void readPreservedFilters(IConfigurationElement element) {
            IConfigurationElement[] children;
            String viewId = element.getAttribute(ELEMENT_VIEW_ID);
            IConfigurationElement[] iConfigurationElementArray = children = element.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals(ELEMENT_FILTER)) {
                    try {
                        Object filterClass = child.createExecutableExtension(ELEMENT_CLASS);
                        ContextUiPlugin.getDefault().addPreservedFilterClass(viewId, (ViewerFilter)filterClass);
                    }
                    catch (Exception exception) {
                        String filterId = child.getAttribute(ELEMENT_ID);
                        ContextUiPlugin.getDefault().addPreservedFilterId(viewId, filterId);
                    }
                }
                ++n2;
            }
        }

        private static void readBridge(IConfigurationElement element) {
            try {
                Object bridge = element.createExecutableExtension(ELEMENT_CLASS);
                String contentType = element.getAttribute(ELEMENT_UI_BRIDGE_CONTENT_TYPE);
                if (bridge instanceof AbstractContextUiBridge && contentType != null) {
                    String label;
                    ImageDescriptor descriptor;
                    ContextUiPlugin.getDefault().internalAddBridge(contentType, (AbstractContextUiBridge)bridge);
                    String iconPath = element.getAttribute(ELEMENT_STRUCTURE_BRIDGE_SEARCH_ICON);
                    if (iconPath != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getDeclaringExtension().getNamespace(), (String)iconPath)) != null) {
                        ContextUiPlugin.getDefault().setActiveSearchIcon((AbstractContextUiBridge)bridge, descriptor);
                    }
                    if ((label = element.getAttribute(ELEMENT_STRUCTURE_BRIDGE_SEARCH_LABEL)) != null) {
                        ContextUiPlugin.getDefault().setActiveSearchLabel((AbstractContextUiBridge)bridge, label);
                    }
                } else {
                    StatusHandler.log((String)("Could not load bridge: " + bridge.getClass().getCanonicalName() + " must implement " + AbstractContextUiBridge.class.getCanonicalName()), (Object)thisReader);
                }
            }
            catch (CoreException e) {
                StatusHandler.log((Throwable)e, (String)"Could not load bridge extension");
            }
        }
    }
}

