/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextWorkingSetManager
implements IWorkingSetUpdater,
IInteractionContextListener {
    private static ContextWorkingSetManager INSTANCE = new ContextWorkingSetManager();
    private List<ContextWorkingSetManager> workingSetUpdaters = null;
    private List<IWorkingSet> workingSets = new ArrayList<IWorkingSet>();

    public void addWorkingSetManager(ContextWorkingSetManager updater) {
        if (this.workingSetUpdaters == null) {
            this.workingSetUpdaters = new ArrayList<ContextWorkingSetManager>();
        }
        this.workingSetUpdaters.add(updater);
        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)updater);
    }

    public ContextWorkingSetManager getWorkingSetUpdater() {
        if (this.workingSetUpdaters == null) {
            return null;
        }
        return this.workingSetUpdaters.get(0);
    }

    public void add(IWorkingSet workingSet) {
        this.workingSets.add(workingSet);
    }

    public boolean remove(IWorkingSet workingSet) {
        return this.workingSets.remove(workingSet);
    }

    public boolean contains(IWorkingSet workingSet) {
        return this.workingSets.contains(workingSet);
    }

    public void dispose() {
    }

    public void contextActivated(IInteractionContext context) {
        this.updateWorkingSet();
    }

    public void contextDeactivated(IInteractionContext context) {
        this.updateWorkingSet();
    }

    public void contextCleared(IInteractionContext context) {
        this.updateWorkingSet();
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        this.updateWorkingSet();
    }

    public void elementDeleted(IInteractionElement node) {
        this.updateWorkingSet();
    }

    public void landmarkAdded(IInteractionElement node) {
        this.updateWorkingSet();
    }

    public void landmarkRemoved(IInteractionElement node) {
        this.updateWorkingSet();
    }

    public void relationsChanged(IInteractionElement node) {
    }

    private void updateWorkingSet() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ContextWorkingSetManager.this.workingSets.size() <= 0) {
                    return;
                }
                IWorkingSet set = (IWorkingSet)ContextWorkingSetManager.this.workingSets.get(0);
                set.setElements(new IAdaptable[0]);
                ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>();
                ContextWorkingSetManager.getElementsFromTaskscape(elements);
                set.setElements(elements.toArray(new IAdaptable[elements.size()]));
            }
        });
    }

    public static void getElementsFromTaskscape(List<IAdaptable> elements) {
        for (IInteractionElement node : ContextCorePlugin.getContextManager().getInterestingDocuments()) {
            Object o;
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
            if (bridge.getContentType().equals("bugzilla") || !((o = bridge.getObjectForHandle(node.getHandleIdentifier())) instanceof IAdaptable)) continue;
            elements.add((IAdaptable)o);
        }
    }

    public IWorkingSet getWorkingSet() {
        return this.workingSets.get(0);
    }

    public static ContextWorkingSetManager getDefault() {
        return INSTANCE;
    }
}

