/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.Calendar;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskListInterestFilter
extends AbstractTaskListFilter {
    public boolean select(Object parent, Object object) {
        block6: {
            AbstractTask task;
            block7: {
                if (object instanceof ScheduledTaskContainer) {
                    ScheduledTaskContainer dateRangeTaskContainer = (ScheduledTaskContainer)object;
                    return this.isDateRangeInteresting(dateRangeTaskContainer);
                }
                if (!(object instanceof AbstractTask)) break block6;
                task = null;
                if (object instanceof AbstractTask) {
                    task = (AbstractTask)object;
                }
                if (task == null) break block6;
                if (!this.isUninteresting(parent, task)) break block7;
                return false;
            }
            try {
                if (this.isInteresting(parent, task)) {
                    return true;
                }
            }
            catch (Throwable t) {
                StatusHandler.fail((Throwable)t, (String)"interest filter failed", (boolean)false);
            }
        }
        return false;
    }

    private boolean isDateRangeInteresting(ScheduledTaskContainer container) {
        return TasksUiPlugin.getTaskActivityManager().isWeekDay(container);
    }

    protected boolean isUninteresting(Object parent, AbstractTask task) {
        return !task.isActive() && !this.hasInterestingSubTasks(parent, task, true) && (task.isCompleted() && !TaskActivityManager.getInstance().isCompletedToday(task) && !TaskListInterestFilter.hasChanges(parent, task) || TaskActivityManager.getInstance().isScheduledAfterThisWeek(task) && !TaskListInterestFilter.hasChanges(parent, task));
    }

    protected boolean isInteresting(Object parent, AbstractTask task) {
        return this.shouldAlwaysShow(parent, task, TasksUiPlugin.getDefault().groupSubtasks((AbstractTaskContainer)task));
    }

    public boolean shouldAlwaysShow(Object parent, AbstractTask task, boolean checkSubTasks) {
        return super.shouldAlwaysShow(parent, task, checkSubTasks) || TaskListInterestFilter.hasChanges(parent, task) || TaskActivityManager.getInstance().isCompletedToday(task) || TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task) || TaskListInterestFilter.isInterestingForThisWeek(parent, task) && !task.isCompleted() || TaskActivityManager.getInstance().isOverdue(task) || this.hasInterestingSubTasks(parent, task, checkSubTasks) || "New Task".equals(task.getSummary());
    }

    private boolean hasInterestingSubTasks(Object parent, AbstractTask task, boolean checkSubTasks) {
        if (!checkSubTasks) {
            return false;
        }
        if (!TasksUiPlugin.getDefault().groupSubtasks((AbstractTaskContainer)task)) {
            return false;
        }
        if (task.getChildren() != null && task.getChildren().size() > 0) {
            for (AbstractTask subTask : task.getChildren()) {
                if (!this.shouldAlwaysShow(parent, subTask, false)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean shouldShowInFocusedWorkweekDateContainer(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            if (!TasksUiPlugin.getTaskActivityManager().isWeekDay((ScheduledTaskContainer)parent)) {
                return false;
            }
            if (TaskActivityManager.getInstance().isOverdue(task) || task.isPastReminder()) {
                return true;
            }
            ScheduledTaskContainer container = (ScheduledTaskContainer)parent;
            Calendar previousCal = TasksUiPlugin.getTaskActivityManager().getActivityPrevious().getEnd();
            Calendar nextCal = TasksUiPlugin.getTaskActivityManager().getActivityNextWeek().getStart();
            if (container.getEnd().compareTo(previousCal) > 0 && container.getStart().compareTo(nextCal) < 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInterestingForThisWeek(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            return TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task);
        }
        return TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task) || TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task) || task.isPastReminder() || TasksUiPlugin.getTaskActivityManager().isDueThisWeek(task);
    }

    public static boolean hasChanges(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer && !TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task)) {
            return false;
        }
        boolean result = false;
        if (task != null) {
            if (task.getLastReadTimeStamp() == null) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof ScheduledTaskContainer)) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                return true;
            }
            return TaskListInterestFilter.hasChangesHelper(parent, (AbstractTaskContainer)task);
        }
        return result;
    }

    private static boolean hasChangesHelper(Object parent, AbstractTaskContainer container) {
        boolean result = false;
        for (AbstractTask task : container.getChildren()) {
            if (task == null) continue;
            if (task.getLastReadTimeStamp() == null) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof ScheduledTaskContainer)) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                result = true;
                continue;
            }
            if (task.getChildren() == null || task.getChildren().size() <= 0) continue;
            result = TaskListInterestFilter.hasChangesHelper(parent, (AbstractTaskContainer)task);
        }
        return result;
    }
}

