/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskArchive;
import org.eclipse.mylyn.internal.tasks.core.UnfiledCategory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListTableSorter;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskListInterestSorter
extends ViewerSorter {
    private TaskKeyComparator taskKeyComparator = new TaskKeyComparator();

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        if (o1 instanceof AbstractTaskContainer && o2 instanceof TaskArchive) {
            return -1;
        }
        if (o2 instanceof AbstractTaskContainer && o1 instanceof TaskArchive) {
            return 1;
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
            ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
            return -1 * dateRangeTaskContainer2.getStart().compareTo(dateRangeTaskContainer1.getStart());
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof ScheduledTaskContainer) {
            return -1;
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof AbstractTaskContainer) {
            return 1;
        }
        if (o1 instanceof UnfiledCategory && o2 instanceof AbstractTaskContainer) {
            return -1;
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof UnfiledCategory) {
            return 1;
        }
        if (!(o1 instanceof AbstractTask) && o2 instanceof AbstractTask) {
            return 1;
        }
        if (!(o1 instanceof AbstractTask)) {
            if (!(o2 instanceof AbstractTask)) {
                return ((AbstractTaskContainer)o1).getSummary().compareToIgnoreCase(((AbstractTaskContainer)o2).getSummary());
            }
            return -1;
        }
        if (o1 instanceof AbstractTaskContainer) {
            if (!(o2 instanceof AbstractTask)) {
                return -1;
            }
            if (o2 instanceof AbstractTaskContainer) {
                AbstractTaskContainer element1 = (AbstractTaskContainer)o1;
                AbstractTaskContainer element2 = (AbstractTaskContainer)o2;
                AbstractTask task1 = null;
                AbstractTask task2 = null;
                if (element1 instanceof AbstractTask) {
                    task1 = (AbstractTask)element1;
                }
                if (element2 instanceof AbstractTask) {
                    task2 = (AbstractTask)element2;
                }
                if (task1 == null && task2 == null) {
                    return this.comparePrioritiesAndKeys(element1, element2);
                }
                if (task1 == null) {
                    return 1;
                }
                if (task2 == null) {
                    return -1;
                }
                int complete = this.compareCompleted(task1, task2);
                if (complete != 0) {
                    return complete;
                }
                int overdue = this.compareOverdue(task1, task2);
                if (overdue != 0) {
                    return overdue;
                }
                int thisWeek = this.compareThisWeek(task1, task2);
                if (thisWeek != 0) {
                    return thisWeek;
                }
                int today = this.compareToday(task1, task2);
                if (today != 0) {
                    return today;
                }
                return this.comparePrioritiesAndKeys(element1, element2);
            }
        }
        return 0;
    }

    private int compareOverdue(AbstractTask task1, AbstractTask task2) {
        if (task1.isPastReminder() && !task2.isPastReminder()) {
            return -1;
        }
        if (!task1.isPastReminder() && task2.isPastReminder()) {
            return 1;
        }
        return 0;
    }

    private int compareToday(AbstractTask task1, AbstractTask task2) {
        if (TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task1) && !TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task2)) {
            return -1;
        }
        if (!TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task1) && TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task2)) {
            return 1;
        }
        return 0;
    }

    private int compareThisWeek(AbstractTask task1, AbstractTask task2) {
        if (TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task1) && !TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task2)) {
            return 1;
        }
        if (!TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task1) && TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task2)) {
            return -1;
        }
        return 0;
    }

    private int compareCompleted(AbstractTask task1, AbstractTask task2) {
        if (task1.isCompleted() && !task2.isCompleted()) {
            return 1;
        }
        if (!task1.isCompleted() && task2.isCompleted()) {
            return -1;
        }
        return 0;
    }

    private int comparePrioritiesAndKeys(AbstractTaskContainer element1, AbstractTaskContainer element2) {
        int priority = this.comparePriorities(element1, element2);
        if (priority != 0) {
            return priority;
        }
        int description = this.compareKeys(element1, element2);
        if (description != 0) {
            return description;
        }
        return 0;
    }

    private int compareKeys(AbstractTaskContainer element1, AbstractTaskContainer element2) {
        String summary1 = TaskListTableSorter.getSortableSummaryFromElement((AbstractTaskContainer)element1);
        String summary2 = TaskListTableSorter.getSortableSummaryFromElement((AbstractTaskContainer)element2);
        return this.taskKeyComparator.compare(summary1, summary2);
    }

    private int comparePriorities(AbstractTaskContainer element1, AbstractTaskContainer element2) {
        return element1.getPriority().compareTo(element2.getPriority());
    }
}

