/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.views;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.ui.views.CommonNavigatorPatternFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.AdaptiveRefreshPolicy;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class CommonNavigatorFilterBar
extends Composite {
    private InterestFilter suppressedFilter = null;
    private AdaptiveRefreshPolicy refreshPolicy;
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected TreeViewer treeViewer;
    protected Composite filterComposite;
    private CommonNavigatorPatternFilter patternFilter;
    protected String initialText = "";
    private Job refreshJob;
    protected Composite parent;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DCLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private String previousFilterText;
    private boolean narrowingDown;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.gif")) != null) {
            JFaceResources.getImageRegistry().put(DCLEAR_ICON, descriptor);
        }
    }

    public CommonNavigatorFilterBar(TreeViewer treeViewer, Composite parent, CommonNavigatorPatternFilter filter) {
        super(parent, 0);
        this.treeViewer = treeViewer;
        this.patternFilter = filter;
        this.createControl(parent, 0x10000800);
        this.createRefreshJob();
        this.setInitialText("");
        this.setFont(parent.getFont());
        this.refreshPolicy = new AdaptiveRefreshPolicy(this.refreshJob, this.filterText);
    }

    protected void textChanged() {
        if (this.filterText == null) {
            return;
        }
        int textLength = this.filterText.getText().length();
        InterestFilter interestFilter = this.getInterestFilters();
        List<ViewerFilter> existingFilters = Arrays.asList(this.getViewer().getFilters());
        if (textLength > 0 && interestFilter != null && this.suppressedFilter == null) {
            this.suppressedFilter = interestFilter;
            this.getViewer().removeFilter((ViewerFilter)interestFilter);
        } else if (textLength == 0 && this.suppressedFilter != null) {
            if (!existingFilters.contains((Object)interestFilter)) {
                this.getViewer().addFilter((ViewerFilter)this.suppressedFilter);
            }
            this.getViewer().expandAll();
            this.suppressedFilter = null;
        }
        if (this.refreshPolicy != null) {
            this.refreshPolicy.textChanged(this.filterText.getText());
        } else {
            this.defaultTextChanged();
        }
    }

    protected void defaultTextChanged() {
        this.narrowingDown = this.previousFilterText == null || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    private InterestFilter getInterestFilters() {
        if (this.getViewer() == null) {
            return null;
        }
        ViewerFilter[] filters = this.getViewer().getFilters();
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (filter instanceof InterestFilter) {
                return (InterestFilter)filter;
            }
            ++i;
        }
        return null;
    }

    public AdaptiveRefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    private void createClearText(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(parent);
            Action clearTextAction = new Action("", 1){

                public void run() {
                    CommonNavigatorFilterBar.this.clearText();
                }
            };
            clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearTextAction.setImageDescriptor(TasksUiImages.FIND_CLEAR);
            clearTextAction.setDisabledImageDescriptor(TasksUiImages.FIND_CLEAR_DISABLED);
            this.filterToolBar.add((IAction)clearTextAction);
        }
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.filterComposite = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        this.filterComposite.setLayout((Layout)filterLayout);
        this.filterComposite.setFont(parent.getFont());
        this.createFilterControls(this.filterComposite);
        this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void init(int treeStyle, CommonNavigatorPatternFilter filter) {
        this.patternFilter = filter;
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(this.parent, treeStyle);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(this.parent.getFont());
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        this.createClearText(parent);
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            this.filterToolBar.getControl().setVisible(false);
        }
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    CommonNavigatorFilterBar.this.setFilterText("");
                }
            }
        });
        return parent;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommonNavigatorFilterBar.this.refreshJob.cancel();
            }
        });
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new TreeViewer(parent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        int i = 0;
        if (i < items.length) {
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, items[i].getData()) && this.patternFilter.isElementSelectable(items[i].getData())) {
                return items[i];
            }
            return this.getFirstMatchingItem(items[i].getItems());
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (CommonNavigatorFilterBar.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = CommonNavigatorFilterBar.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = CommonNavigatorFilterBar.this.initialText != null && CommonNavigatorFilterBar.this.initialText.equals(text);
                if (initial) {
                    CommonNavigatorFilterBar.this.patternFilter.setPattern(null);
                } else {
                    CommonNavigatorFilterBar.this.patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = CommonNavigatorFilterBar.this.treeComposite != null ? CommonNavigatorFilterBar.this.treeComposite : CommonNavigatorFilterBar.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!CommonNavigatorFilterBar.this.narrowingDown) {
                        TreeItem[] is = CommonNavigatorFilterBar.this.treeViewer.getTree().getItems();
                        int i = 0;
                        while (i < is.length) {
                            TreeItem item = is[i];
                            if (item.getExpanded()) {
                                CommonNavigatorFilterBar.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++i;
                        }
                    }
                    CommonNavigatorFilterBar.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        CommonNavigatorFilterBar.this.updateToolbar(true);
                        TreeItem[] items = CommonNavigatorFilterBar.this.getViewer().getTree().getItems();
                        int treeHeight = CommonNavigatorFilterBar.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / CommonNavigatorFilterBar.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        CommonNavigatorFilterBar.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = CommonNavigatorFilterBar.this.getViewer().getTree().getItems();
                    if (items.length > 0 && CommonNavigatorFilterBar.this.getViewer().getTree().getSelectionCount() == 0) {
                        CommonNavigatorFilterBar.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                CommonNavigatorFilterBar.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
        this.refreshJob.setSystem(true);
    }

    protected void updateToolbar(boolean visible) {
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(visible);
        }
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = CommonNavigatorFilterBar.this.filterText.getText();
                e.result = filterTextString.length() == 0 ? CommonNavigatorFilterBar.this.initialText : filterTextString;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = CommonNavigatorFilterBar.this.filterText.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!(this).CommonNavigatorFilterBar.this.filterText.isDisposed() && CommonNavigatorFilterBar.this.getInitialText().equals((this).CommonNavigatorFilterBar.this.filterText.getText().trim())) {
                            (this).CommonNavigatorFilterBar.this.filterText.selectAll();
                        }
                    }
                });
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = CommonNavigatorFilterBar.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    CommonNavigatorFilterBar.this.treeViewer.getTree().setFocus();
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    e.doit = false;
                    if (CommonNavigatorFilterBar.this.getViewer().getTree().getItemCount() == 0) {
                        Display.getCurrent().beep();
                    } else {
                        TreeItem item;
                        boolean textChanged;
                        boolean hasFocus = CommonNavigatorFilterBar.this.getViewer().getTree().setFocus();
                        boolean bl = textChanged = !CommonNavigatorFilterBar.this.getInitialText().equals(CommonNavigatorFilterBar.this.filterText.getText().trim());
                        if (hasFocus && textChanged && CommonNavigatorFilterBar.this.filterText.getText().trim().length() > 0 && (item = CommonNavigatorFilterBar.this.getFirstMatchingItem(CommonNavigatorFilterBar.this.getViewer().getTree().getItems())) != null) {
                            CommonNavigatorFilterBar.this.getViewer().getTree().setSelection(new TreeItem[]{item});
                            ISelection sel = CommonNavigatorFilterBar.this.getViewer().getSelection();
                            CommonNavigatorFilterBar.this.getViewer().setSelection(sel, true);
                        }
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CommonNavigatorFilterBar.this.textChanged();
            }
        });
        GridData gridData = new GridData(4, 1, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2436);
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null) {
            this.filterComposite.setBackground(background);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(background);
        }
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    public void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        this.setFilterText(this.initialText);
        this.textChanged();
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }
}

