/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextManager;
import org.eclipse.mylyn.internal.team.ui.ContextChangeSet;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.team.ui.AbstractActiveChangeSetProvider;
import org.eclipse.mylyn.team.ui.AbstractContextChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.IChangeSetChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextActiveChangeSetManager
extends AbstractContextChangeSetManager {
    private List<ActiveChangeSetManager> changeSetManagers = new ArrayList<ActiveChangeSetManager>();
    private Map<String, ContextChangeSet> activeChangeSets = new HashMap<String, ContextChangeSet>();
    private final IChangeSetChangeListener CHANGE_SET_LISTENER = new IChangeSetChangeListener(){

        public void setRemoved(ChangeSet set) {
            ContextChangeSet contextChangeSet;
            if (set instanceof ContextChangeSet && (contextChangeSet = (ContextChangeSet)set).getTask() != null && contextChangeSet.getTask().isActive()) {
                for (ActiveChangeSetManager collector : ContextActiveChangeSetManager.this.changeSetManagers) {
                    collector.add((ChangeSet)contextChangeSet);
                }
            }
        }

        public void setAdded(ChangeSet set) {
        }

        public void defaultSetChanged(ChangeSet previousDefault, ChangeSet set) {
        }

        public void nameChanged(ChangeSet set) {
        }

        public void resourcesChanged(ChangeSet set, IPath[] paths) {
        }
    };

    public ContextActiveChangeSetManager() {
        Set<AbstractActiveChangeSetProvider> providerList = FocusedTeamUiPlugin.getDefault().getActiveChangeSetProviders();
        for (AbstractActiveChangeSetProvider provider : providerList) {
            ActiveChangeSetManager changeSetManager = provider.getActiveChangeSetManager();
            if (changeSetManager == null) continue;
            this.changeSetManagers.add(changeSetManager);
            changeSetManager.addListener(this.CHANGE_SET_LISTENER);
        }
    }

    @Override
    protected void updateChangeSetLabel(AbstractTask task) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                ContextChangeSet contextChangeSet;
                ChangeSet set = sets[i];
                if (set instanceof ContextChangeSet && (contextChangeSet = (ContextChangeSet)set).getTask().equals((Object)task)) {
                    contextChangeSet.initTitle();
                }
                ++i;
            }
        }
    }

    @Override
    public void enable() {
        super.enable();
        if (!this.isEnabled) {
            for (ActiveChangeSetManager collector : this.changeSetManagers) {
                collector.addListener(this.CHANGE_SET_LISTENER);
            }
        }
    }

    @Override
    public void disable() {
        super.disable();
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            collector.removeListener(this.CHANGE_SET_LISTENER);
        }
    }

    @Override
    protected void initContextChangeSets() {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                ChangeSet restoredSet = sets[i];
                if (!(restoredSet instanceof ContextChangeSet)) {
                    String encodedTitle = restoredSet.getName();
                    String taskHandle = ContextChangeSet.getHandleFromPersistedTitle(encodedTitle);
                    AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(taskHandle);
                    if (task != null) {
                        try {
                            ContextChangeSet contextChangeSet = new ContextChangeSet(task, collector);
                            contextChangeSet.restoreResources(restoredSet.getResources());
                            collector.remove(restoredSet);
                            collector.add((ChangeSet)contextChangeSet);
                        }
                        catch (Exception e) {
                            StatusHandler.fail((Throwable)e, (String)"could not restore change set", (boolean)false);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void clearActiveChangeSets() {
        this.activeChangeSets.clear();
    }

    public IResource[] getResources(AbstractTask task) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                ContextChangeSet contextChangeSet;
                ChangeSet set = sets[i];
                if (set instanceof ContextChangeSet && (contextChangeSet = (ContextChangeSet)set).getTask().equals((Object)task)) {
                    return contextChangeSet.getResources();
                }
                ++i;
            }
        }
        return null;
    }

    public void contextActivated(IInteractionContext context) {
        try {
            AbstractTask task = this.getTask(context);
            if (task != null && !this.activeChangeSets.containsKey(task.getHandleIdentifier())) {
                for (ActiveChangeSetManager collector : this.changeSetManagers) {
                    ContextChangeSet contextChangeSet = new ContextChangeSet(task, collector);
                    List interestingResources = ResourcesUiBridgePlugin.getDefault().getInterestingResources(context);
                    contextChangeSet.add(interestingResources.toArray(new IResource[interestingResources.size()]));
                    this.activeChangeSets.put(task.getHandleIdentifier(), contextChangeSet);
                    if (collector.contains((ChangeSet)contextChangeSet)) continue;
                    collector.add((ChangeSet)contextChangeSet);
                }
            }
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not update change set", (boolean)false);
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        for (ActiveChangeSetManager collector : this.changeSetManagers) {
            ChangeSet[] sets = collector.getSets();
            int i = 0;
            while (i < sets.length) {
                IResource[] resources;
                ChangeSet set = sets[i];
                if (set instanceof ContextChangeSet && ((resources = set.getResources()) == null || resources.length == 0)) {
                    collector.remove(set);
                }
                ++i;
            }
        }
        this.activeChangeSets.clear();
    }

    public void contextCleared(IInteractionContext context) {
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
            try {
                IResource resource;
                if (!bridge.isDocument(element.getHandleIdentifier()) || (resource = ResourcesUiBridgePlugin.getDefault().getResourceForElement(element, false)) == null || !resource.exists()) continue;
                for (ContextChangeSet activeContextChangeSet : this.getActiveChangeSets()) {
                    if (activeContextChangeSet.contains(resource) || !element.getInterest().isInteresting()) continue;
                    activeContextChangeSet.add(new IResource[]{resource});
                }
                if (!this.shouldRemove(element)) continue;
                for (ActiveChangeSetManager collector : this.changeSetManagers) {
                    ChangeSet[] sets = collector.getSets();
                    int i = 0;
                    while (i < sets.length) {
                        if (sets[i] instanceof ContextChangeSet) {
                            sets[i].remove(resource);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)"could not manipulate change set resources", (boolean)false);
            }
        }
    }

    public List<ContextChangeSet> getActiveChangeSets() {
        return new ArrayList<ContextChangeSet>(this.activeChangeSets.values());
    }

    private AbstractTask getTask(IInteractionContext context) {
        return TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask();
    }

    private boolean shouldRemove(IInteractionElement element) {
        return element.getInterest().getValue() + element.getInterest().getDecayValue() < InteractionContextManager.getScalingFactors().getInteresting();
    }
}

