/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamExtensionPointReader;
import org.eclipse.mylyn.internal.team.ui.templates.CommitTemplateManager;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.team.ui.AbstractActiveChangeSetProvider;
import org.eclipse.mylyn.team.ui.AbstractContextChangeSetManager;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusedTeamUiPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.team.ui";
    private static FocusedTeamUiPlugin INSTANCE;
    private Set<AbstractContextChangeSetManager> changeSetManagers = new HashSet<AbstractContextChangeSetManager>();
    private Set<AbstractActiveChangeSetProvider> activeChangeSetProviders = new HashSet<AbstractActiveChangeSetProvider>();
    private CommitTemplateManager commitTemplateManager;
    public static final String CHANGE_SET_MANAGE = "org.eclipse.mylyn.team.changesets.manage";
    public static final String COMMIT_TEMPLATE = "org.eclipse.mylyn.team.commit.template";
    public static final String DEFAULT_COMMIT_TEMPLATE = "${task.status} - ${connector.task.prefix} ${task.key}: ${task.description} \n${task.url}";
    private static final String OLD_DEFAULT_COMMIT_TEMPLATE = "${task.status} - ${connector.task.prefix} ${task.id}: ${task.description} \n${task.url}";
    private static final String OLD_DEFAULT_COMMIT_TEMPLATE2 = "${task.status} - ${connector.task.prefix} ${task.id}: ${task.description} \r\n${task.url}";

    public FocusedTeamUiPlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initPreferenceDefaults();
        this.commitTemplateManager = new CommitTemplateManager();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    FocusedTeamExtensionPointReader extensionPointReader = new FocusedTeamExtensionPointReader();
                    extensionPointReader.readExtensions();
                    if (FocusedTeamUiPlugin.this.getPreferenceStore().getBoolean(FocusedTeamUiPlugin.CHANGE_SET_MANAGE)) {
                        for (AbstractContextChangeSetManager changeSetManager : FocusedTeamUiPlugin.this.changeSetManagers) {
                            changeSetManager.enable();
                        }
                    }
                }
                catch (Exception e) {
                    StatusHandler.fail((Throwable)e, (String)"Mylyn Team start failed", (boolean)false);
                }
            }
        });
    }

    public void earlyStartup() {
    }

    public void stop(BundleContext context) throws Exception {
        INSTANCE = null;
        super.stop(context);
        for (AbstractContextChangeSetManager changeSetManager : this.changeSetManagers) {
            changeSetManager.disable();
        }
    }

    private void initPreferenceDefaults() {
        this.getPreferenceStore().setDefault(CHANGE_SET_MANAGE, true);
        this.getPreferenceStore().setDefault(COMMIT_TEMPLATE, DEFAULT_COMMIT_TEMPLATE);
        if (this.getPreferenceStore().getString(COMMIT_TEMPLATE).equals(OLD_DEFAULT_COMMIT_TEMPLATE) || this.getPreferenceStore().getString(COMMIT_TEMPLATE).equals(OLD_DEFAULT_COMMIT_TEMPLATE2)) {
            this.getPreferenceStore().setValue(COMMIT_TEMPLATE, DEFAULT_COMMIT_TEMPLATE);
        }
    }

    public static FocusedTeamUiPlugin getDefault() {
        return INSTANCE;
    }

    public void addContextChangeSetManager(AbstractContextChangeSetManager changeSetManager) {
        this.changeSetManagers.add(changeSetManager);
    }

    public boolean removeContextChangeSetManager(AbstractContextChangeSetManager changeSetManager) {
        return this.changeSetManagers.remove(changeSetManager);
    }

    public void addActiveChangeSetProvider(AbstractActiveChangeSetProvider provider) {
        this.activeChangeSetProviders.add(provider);
    }

    public Set<AbstractActiveChangeSetProvider> getActiveChangeSetProviders() {
        return Collections.unmodifiableSet(this.activeChangeSetProviders);
    }

    public Set<AbstractContextChangeSetManager> getContextChangeSetManagers() {
        return Collections.unmodifiableSet(this.changeSetManagers);
    }

    public CommitTemplateManager getCommitTemplateManager() {
        return this.commitTemplateManager;
    }
}

