/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.templates;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.team.ui.AbstractCommitTemplateVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTemplateVariables {
    public static String implode(List<String> list, String separator) {
        StringBuilder builder = new StringBuilder();
        for (String cc : list) {
            if (builder.length() != 0) {
                builder.append(separator);
            }
            builder.append(cc);
        }
        return builder.toString();
    }

    public static RepositoryTaskData getTaskData(AbstractTask task) {
        return TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
    }

    protected static abstract class CommitTemplateDate
    extends AbstractCommitTemplateVariable {
        protected CommitTemplateDate() {
        }

        public String getValue(AbstractTask task) {
            Date date = this.getDate(task);
            return this.formatDate(date);
        }

        protected String formatDate(Date date) {
            return date.toString();
        }

        protected abstract Date getDate(AbstractTask var1);

        public static class TaskCompletion
        extends CommitTemplateDate {
            protected Date getDate(AbstractTask task) {
                return task.getCompletionDate();
            }
        }

        public static class TaskCreation
        extends CommitTemplateDate {
            protected Date getDate(AbstractTask task) {
                return task.getCreationDate();
            }
        }

        public static class TaskReminder
        extends CommitTemplateDate {
            protected Date getDate(AbstractTask task) {
                return task.getScheduledForDate();
            }
        }
    }

    public static class ConnectorTaskPrefix
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            AbstractRepositoryConnector connector;
            if (task != null && (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(task)) != null) {
                return connector.getTaskIdPrefix();
            }
            return null;
        }
    }

    public static class RepositoryKind
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return task.getConnectorKind();
            }
            return null;
        }
    }

    public static class RepositoryUrl
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return task.getRepositoryUrl();
            }
            return null;
        }
    }

    public static class TaskAssignee
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return CommitTemplateVariables.getTaskData(task).getAssignedTo();
            }
            return null;
        }
    }

    public static class TaskCc
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                List list = CommitTemplateVariables.getTaskData(task).getCc();
                return CommitTemplateVariables.implode(list, ", ");
            }
            return null;
        }
    }

    public static class TaskDescription
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            return task.getSummary();
        }
    }

    public static class TaskId
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return task.getTaskId();
            }
            return null;
        }
    }

    public static class TaskKey
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                String value = task.getTaskKey();
                if (value == null) {
                    value = task.getTaskId();
                }
                return value;
            }
            return null;
        }
    }

    public static class TaskKeywords
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                List list = CommitTemplateVariables.getTaskData(task).getKeywords();
                return CommitTemplateVariables.implode(list, ", ");
            }
            return null;
        }
    }

    public static class TaskLastModified
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return CommitTemplateVariables.getTaskData(task).getLastModified();
            }
            return null;
        }
    }

    public static class TaskNotes
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            return task.getNotes();
        }
    }

    public static class TaskPriority
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            return task.getPriority();
        }
    }

    public static class TaskProduct
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return CommitTemplateVariables.getTaskData(task).getProduct();
            }
            return null;
        }
    }

    public static class TaskReporter
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return CommitTemplateVariables.getTaskData(task).getReporter();
            }
            return null;
        }
    }

    public static class TaskResolution
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return CommitTemplateVariables.getTaskData(task).getResolution();
            }
            return null;
        }
    }

    public static class TaskStatus
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null && CommitTemplateVariables.getTaskData(task) != null) {
                return CommitTemplateVariables.getTaskData(task).getStatus().toUpperCase(Locale.ENGLISH);
            }
            if (task != null && task.isCompleted()) {
                return "Complete";
            }
            return "Incomplete";
        }
    }

    public static class TaskSummary
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            if (task != null) {
                return CommitTemplateVariables.getTaskData(task).getSummary();
            }
            return "";
        }
    }

    public static class TaskType
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            return task.getTaskKind();
        }
    }

    public static class TaskURL
    extends AbstractCommitTemplateVariable {
        public String getValue(AbstractTask task) {
            return task.getUrl();
        }
    }
}

