/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.rmi.RemoteException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import javax.security.auth.login.LoginException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.xplanner.core.XPlannerCorePlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerAttributeFactory;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.xplanner.ui.XPlannerTask;
import org.eclipse.mylyn.xplanner.ui.XPlannerTaskDataHandler;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.PersonData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.TaskData;
import org.xplanner.soap.UserStoryData;

public class XPlannerRepositoryUtils {
    private static final String TYPE_FEATURE = "Feature";
    private static final String NO_TASK_NAME = "<no task name>";
    public static final String DISPOSITION_PLANNED = "planned";
    private static HashSet<String> validatedRepositoryUrls = new HashSet();

    private XPlannerRepositoryUtils() {
    }

    public static RepositoryTaskData createRepositoryTaskData(TaskRepository repository, XPlannerTask xplannerTask, XPlannerClient client) throws CoreException {
        RepositoryTaskData repositoryTaskData = null;
        try {
            if (XPlannerTask.Kind.TASK.toString().equals(xplannerTask.getTaskKind())) {
                TaskData taskData = client.getTask(Integer.valueOf(xplannerTask.getTaskId()).intValue());
                repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getUrl(), taskData, RepositoryTaskHandleUtil.getTaskId((String)xplannerTask.getHandleIdentifier()));
                xplannerTask.setCompleted(taskData.isCompleted());
            } else if (XPlannerTask.Kind.USER_STORY.toString().equals(xplannerTask.getTaskKind())) {
                UserStoryData userStory = client.getUserStory(Integer.valueOf(xplannerTask.getTaskId()).intValue());
                repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getUrl(), userStory, RepositoryTaskHandleUtil.getTaskId((String)xplannerTask.getHandleIdentifier()));
                xplannerTask.setCompleted(userStory.isCompleted());
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", 0, MessageFormat.format(Messages.XPlannerRepositoryUtils_TASK_DOWNLOAD_FAILED, xplannerTask.getRepositoryUrl(), "Task Repositories view"), (Throwable)e));
        }
        return repositoryTaskData;
    }

    public static RepositoryTaskData createRepositoryTaskData(TaskRepository repository, String taskId) throws CoreException {
        RepositoryTaskData repositoryTaskData = null;
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        try {
            TaskData taskData = client.getTask(Integer.valueOf(taskId).intValue());
            if (taskData != null) {
                repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getUrl(), taskData, taskId);
            } else {
                UserStoryData userStory = client.getUserStory(Integer.valueOf(taskId).intValue());
                if (userStory != null) {
                    repositoryTaskData = XPlannerRepositoryUtils.getXPlannerRepositoryTaskData(repository.getUrl(), userStory, taskId);
                }
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", 0, MessageFormat.format(Messages.XPlannerRepositoryUtils_TASK_DOWNLOAD_FAILED, repository.getUrl(), "Task Repositories view"), (Throwable)e));
        }
        return repositoryTaskData;
    }

    public static RepositoryTaskData getXPlannerRepositoryTaskData(String repositoryUrl, TaskData taskData, String id) throws IOException, MalformedURLException, LoginException, GeneralSecurityException, CoreException {
        RepositoryTaskData repositoryTaskData = new RepositoryTaskData((AbstractAttributeFactory)new XPlannerAttributeFactory(), "xplanner", repositoryUrl, id, XPlannerTask.Kind.TASK.toString());
        XPlannerRepositoryUtils.setupTaskAttributes(taskData, repositoryTaskData);
        return repositoryTaskData;
    }

    public static RepositoryTaskData getXPlannerRepositoryTaskData(String repositoryUrl, UserStoryData userStory, String id) throws IOException, MalformedURLException, LoginException, GeneralSecurityException, CoreException {
        RepositoryTaskData repositoryTaskData = new RepositoryTaskData((AbstractAttributeFactory)new XPlannerAttributeFactory(), "xplanner", repositoryUrl, id, XPlannerTask.Kind.USER_STORY.toString());
        XPlannerRepositoryUtils.setupUserStoryAttributes(userStory, repositoryTaskData);
        return repositoryTaskData;
    }

    public static void setupTaskAttributes(TaskData taskData, RepositoryTaskData repositoryTaskData) throws CoreException {
        Date lastUpdatedDate;
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("xplanner", repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        repositoryTaskData.setAttributeValue("task.common.description", taskData.getDescription());
        repositoryTaskData.setAttributeValue("task.common.priority", XPlannerRepositoryUtils.getPriorityFromXPlannerObject(taskData, client));
        repositoryTaskData.setAttributeValue("task.common.status", taskData.getDispositionName());
        repositoryTaskData.setAttributeValue("task.common.summary", taskData.getName());
        repositoryTaskData.setAttributeValue("task.common.user.assigned", XPlannerRepositoryUtils.getPersonName(taskData.getAcceptorId(), client));
        if (taskData.getCreatedDate() != null) {
            Date createdDate = taskData.getCreatedDate().getTime();
            repositoryTaskData.setAttributeValue("task.common.date.created", XPlannerAttributeFactory.DATE_FORMAT.format(createdDate));
        }
        if ((lastUpdatedDate = taskData.getLastUpdateTime().getTime()) != null) {
            repositoryTaskData.setAttributeValue("task.common.date.modified", XPlannerAttributeFactory.TIME_DATE_FORMAT.format(lastUpdatedDate));
        }
        repositoryTaskData.setAttributeValue("estimatedHours", "" + taskData.getEstimatedHours());
        repositoryTaskData.setAttributeValue("actualHours", "" + taskData.getActualHours());
        repositoryTaskData.setAttributeValue("remainingHours", "" + taskData.getRemainingHours());
        repositoryTaskData.setAttributeValue("estimatedOriginalHours", "" + taskData.getEstimatedOriginalHours());
        repositoryTaskData.setAttributeValue("adjustedEstimatedHours", "" + taskData.getAdjustedEstimatedHours());
        repositoryTaskData.setAttributeValue("projectName", XPlannerRepositoryUtils.getProjectName(taskData, client));
        repositoryTaskData.setAttributeValue("iterationName", XPlannerRepositoryUtils.getIterationName(taskData, client));
        repositoryTaskData.setAttributeValue("userStoryName", XPlannerRepositoryUtils.getUserStoryName(taskData, client));
        repositoryTaskData.setAttributeValue("completed", taskData.isCompleted() ? "1" : "0");
    }

    public static void setupNewTaskAttributes(UserStoryData userStoryData, RepositoryTaskData repositoryTaskData) throws CoreException {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("xplanner", repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        repositoryTaskData.setAttributeValue("task.common.priority", XPlannerRepositoryUtils.getPriorityFromXPlannerObject(userStoryData, client));
        repositoryTaskData.setAttributeValue("task.common.status", userStoryData.getDispositionName());
        repositoryTaskData.setAttributeValue("task.common.user.assigned", XPlannerRepositoryUtils.getPersonName(userStoryData.getTrackerId(), client));
        repositoryTaskData.setAttributeValue("assignedId", "" + userStoryData.getTrackerId());
        repositoryTaskData.setAttributeValue("projectName", XPlannerRepositoryUtils.getProjectName(userStoryData, client));
        repositoryTaskData.setAttributeValue("projectId", "" + XPlannerRepositoryUtils.getProjectId(userStoryData, client));
        repositoryTaskData.setAttributeValue("iterationName", XPlannerRepositoryUtils.getIterationName(userStoryData, client));
        repositoryTaskData.setAttributeValue("iterationId", "" + XPlannerRepositoryUtils.getIterationId(userStoryData, client));
        repositoryTaskData.setAttributeValue("userStoryName", userStoryData.getName());
        repositoryTaskData.setAttributeValue("userStoryId", "" + userStoryData.getId());
        repositoryTaskData.setAttributeValue("completed", "0");
        repositoryTaskData.setAttributeValue("estimatedHours", "0.0");
        repositoryTaskData.setAttributeValue("actualHours", "0.0");
        repositoryTaskData.setAttributeValue("estimatedOriginalHours", "0.0");
        repositoryTaskData.setAttributeValue("remainingHours", "0.0");
        repositoryTaskData.setAttributeValue("adjustedEstimatedHours", "0.0");
    }

    public static TaskData createNewTaskData(RepositoryTaskData repositoryTaskData, XPlannerClient client) {
        TaskData taskData = new TaskData();
        String assignedToId = repositoryTaskData.getAttributeValue("assignedId");
        taskData.setAcceptorId(assignedToId == null || assignedToId.length() == 0 ? -1 : Integer.valueOf(assignedToId));
        String userStoryId = repositoryTaskData.getAttributeValue("userStoryId");
        taskData.setStoryId(userStoryId == null || userStoryId.length() == 0 ? -1 : Integer.valueOf(userStoryId));
        String completed = repositoryTaskData.getAttributeValue("completed");
        taskData.setCompleted(completed != null && !"0".equals(completed));
        taskData.setDispositionName(DISPOSITION_PLANNED);
        taskData.setType(TYPE_FEATURE);
        return taskData;
    }

    public static void ensureTaskDataValid(TaskData taskData) {
        if (taskData != null) {
            if (taskData.getDispositionName() == null || taskData.getDispositionName().length() == 0) {
                taskData.setDispositionName(DISPOSITION_PLANNED);
            }
            if (taskData.getName() == null || taskData.getName().length() == 0) {
                taskData.setName(NO_TASK_NAME);
            }
        }
    }

    public static void setupUserStoryAttributes(UserStoryData userStory, RepositoryTaskData repositoryTaskData) throws CoreException {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("xplanner", repositoryTaskData.getRepositoryUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        repositoryTaskData.setAttributeValue("task.common.description", userStory.getDescription());
        repositoryTaskData.setAttributeValue("task.common.priority", XPlannerRepositoryUtils.getPriorityFromXPlannerObject(userStory, client));
        repositoryTaskData.setAttributeValue("task.common.summary", userStory.getName());
        repositoryTaskData.setAttributeValue("task.common.status", userStory.getDispositionName());
        repositoryTaskData.setAttributeValue("task.common.user.assigned", XPlannerRepositoryUtils.getPersonName(userStory.getTrackerId(), client));
        Date lastUpdatedDate = userStory.getLastUpdateTime().getTime();
        if (lastUpdatedDate != null) {
            repositoryTaskData.setAttributeValue("task.common.date.modified", XPlannerAttributeFactory.TIME_DATE_FORMAT.format(lastUpdatedDate));
        }
        repositoryTaskData.setAttributeValue("estimatedHours", "" + userStory.getEstimatedHours());
        repositoryTaskData.setAttributeValue("actualHours", "" + userStory.getActualHours());
        repositoryTaskData.setAttributeValue("estimatedOriginalHours", "" + userStory.getEstimatedOriginalHours());
        repositoryTaskData.setAttributeValue("remainingHours", "" + userStory.getRemainingHours());
        repositoryTaskData.setAttributeValue("adjustedEstimatedHours", "" + userStory.getAdjustedEstimatedHours());
        repositoryTaskData.setAttributeValue("projectName", XPlannerRepositoryUtils.getProjectName(userStory, client));
        repositoryTaskData.setAttributeValue("iterationName", XPlannerRepositoryUtils.getIterationName(userStory, client));
    }

    public static String getProjectName(RepositoryTaskData repositoryTaskData) {
        return repositoryTaskData.getAttributeValue("projectName");
    }

    public static String getIterationName(RepositoryTaskData repositoryTaskData) {
        return repositoryTaskData.getAttributeValue("iterationName");
    }

    public static String getUserStoryName(RepositoryTaskData repositoryTaskData) {
        return repositoryTaskData.getAttributeValue("userStoryName");
    }

    public static String getPersonName(int personId, XPlannerClient client) {
        String personName = Messages.XPlannerRepositoryUtils_NO_PERSON_NAME;
        try {
            PersonData personData = client.getPerson(personId);
            if (personData != null) {
                personName = personData.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return personName;
    }

    public static double getActualHours(RepositoryTaskData repositoryTaskData) {
        String hours = repositoryTaskData.getAttributeValue("actualHours");
        return Double.valueOf(hours);
    }

    public static double getRemainingHours(RepositoryTaskData repositoryTaskData) {
        String hours = repositoryTaskData.getAttributeValue("remainingHours");
        return Double.valueOf(hours);
    }

    public static double getEstimatedHours(RepositoryTaskData repositoryTaskData) {
        String hours = repositoryTaskData.getAttributeValue("estimatedHours");
        return Double.valueOf(hours);
    }

    public static Double getAdjustedEstimatedHours(RepositoryTaskData repositoryTaskData) {
        String hours = repositoryTaskData.getAttributeValue("adjustedEstimatedHours");
        return (double)Double.valueOf(hours);
    }

    public static Double getEstimatedOriginalHours(RepositoryTaskData repositoryTaskData) {
        String hours = repositoryTaskData.getAttributeValue("estimatedOriginalHours");
        return (double)Double.valueOf(hours);
    }

    public static Date getCreatedDate(RepositoryTaskData repositoryTaskData) {
        Date createdDate = null;
        String dateString = repositoryTaskData.getAttributeValue("task.common.date.created");
        try {
            createdDate = XPlannerAttributeFactory.DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            XPlannerMylynUIPlugin.log(e.getCause(), "", false);
        }
        return createdDate;
    }

    public static String getProjectName(TaskData taskData, XPlannerClient client) {
        String projectName = Messages.XPlannerRepositoryUtils_NO_PROJECT_NAME;
        try {
            UserStoryData userStory = client.getUserStory(taskData.getStoryId());
            projectName = XPlannerRepositoryUtils.getProjectName(userStory, client);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return projectName;
    }

    public static String getProjectName(UserStoryData userStory, XPlannerClient client) {
        String projectName = Messages.XPlannerRepositoryUtils_NO_PROJECT_NAME;
        try {
            ProjectData project;
            IterationData iteration;
            if (userStory != null && (iteration = client.getIteration(userStory.getIterationId())) != null && (project = client.getProject(iteration.getProjectId())) != null) {
                projectName = project.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return projectName;
    }

    public static int getProjectId(UserStoryData userStory, XPlannerClient client) {
        int projectId = -1;
        try {
            IterationData iteration;
            if (userStory != null && (iteration = client.getIteration(userStory.getIterationId())) != null) {
                projectId = iteration.getProjectId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return projectId;
    }

    public static String getIterationName(TaskData taskData, XPlannerClient client) {
        String iterationName = Messages.XPlannerRepositoryUtils_NO_ITERATION_NAME;
        try {
            UserStoryData userStory = client.getUserStory(taskData.getStoryId());
            iterationName = XPlannerRepositoryUtils.getIterationName(userStory, client);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return iterationName;
    }

    public static String getIterationName(UserStoryData userStory, XPlannerClient client) {
        String iterationName = Messages.XPlannerRepositoryUtils_NO_ITERATION_NAME;
        try {
            IterationData iteration = client.getIteration(userStory.getIterationId());
            if (iteration != null) {
                iterationName = iteration.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterationName;
    }

    public static int getIterationId(UserStoryData userStory, XPlannerClient client) {
        int iterationId = -1;
        try {
            IterationData iteration = client.getIteration(userStory.getIterationId());
            if (iteration != null) {
                iterationId = iteration.getId();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterationId;
    }

    public static String getUserStoryName(TaskData taskData, XPlannerClient client) {
        String userStoryName = Messages.XPlannerRepositoryUtils_NO_USER_STORY_NAME;
        try {
            UserStoryData userStory = client.getUserStory(taskData.getStoryId());
            if (userStory != null) {
                userStoryName = userStory.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userStoryName;
    }

    public static String getDescription(RepositoryTaskData repositoryTaskData) {
        return repositoryTaskData.getAttributeValue("task.common.description");
    }

    public static boolean isCompleted(RepositoryTaskData repositoryTaskData) {
        return "1".equals(repositoryTaskData.getAttributeValue("completed"));
    }

    public static String getName(RepositoryTaskData repositoryTaskData) {
        return repositoryTaskData.getAttributeValue("task.common.summary");
    }

    public static String getPriorityFromXPlannerObject(Object xplannerObject, XPlannerClient client) {
        int priority = -1;
        UserStoryData userStory = null;
        try {
            if (xplannerObject instanceof TaskData) {
                userStory = client.getUserStory(((TaskData)xplannerObject).getStoryId());
            } else if (xplannerObject instanceof UserStoryData) {
                userStory = (UserStoryData)xplannerObject;
            }
            if (userStory != null) {
                priority = userStory.getPriority();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return priority == -1 ? "" : String.valueOf(priority);
    }

    public static boolean isRepositoryUrlValidated(String repositoryUrl) {
        return validatedRepositoryUrls.contains(repositoryUrl);
    }

    static void addValidatedRepositoryUrl(String url) {
        validatedRepositoryUrls.add(url);
    }

    static void removeValidatedRepositoryUrl(String url) {
        validatedRepositoryUrls.remove(url);
    }

    public static void checkRepositoryValidated(String repositoryUrl) throws CoreException {
        if (repositoryUrl == null) {
            return;
        }
        TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        if (taskRepository != null && !XPlannerRepositoryUtils.isRepositoryUrlValidated(taskRepository.getUrl())) {
            XPlannerRepositoryUtils.validateRepository(taskRepository);
        }
    }

    public static void validateRepository(TaskRepository taskRepository) throws CoreException {
        XPlannerRepositoryUtils.validateRepository(taskRepository.getUrl(), taskRepository.getUserName(), taskRepository.getPassword(), taskRepository.getProxy(), taskRepository.getHttpUser(), taskRepository.getHttpPassword());
    }

    public static void validateRepository(String url, String userName, String password) throws CoreException {
        XPlannerRepositoryUtils.validateRepository(url, userName, password, Proxy.NO_PROXY, null, null);
    }

    public static void validateRepository(String url, String userName, String password, Proxy proxy, String httpUser, String httpPassword) throws CoreException {
        try {
            XPlannerClientFacade.getDefault().validateServerAndCredentials(url, userName, password, proxy, httpUser, httpPassword);
        }
        catch (Exception e) {
            throw new CoreException(XPlannerCorePlugin.toStatus((Throwable)e));
        }
    }

    public static RepositoryTaskData getNewRepositoryTaskData(TaskRepository taskRepository, UserStoryData userStoryData) throws CoreException {
        if (taskRepository == null || userStoryData == null) {
            return null;
        }
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector("xplanner");
        XPlannerTaskDataHandler taskDataHandler = (XPlannerTaskDataHandler)connector.getTaskDataHandler();
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(taskRepository.getUrl(), taskRepository.getConnectorKind(), "task");
        RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, "xplanner", taskRepository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId(), XPlannerTask.Kind.TASK.toString());
        taskData.setNew(true);
        taskDataHandler.initializeTaskData(taskRepository, taskData, userStoryData);
        return taskData;
    }
}

