/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.xplanner.wsdl.soap.domain.DomainData;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.UserStoryData;

public class XPlannerTask
extends AbstractTask {
    private String key = null;

    public void setKind(DomainData data) {
        String tempKind = Kind.TASK.toString();
        if (data instanceof IterationData) {
            tempKind = Kind.ITERATION.toString();
        } else if (data instanceof UserStoryData) {
            tempKind = Kind.USER_STORY.toString();
        }
        this.setTaskKind(tempKind);
    }

    public XPlannerTask(String repositoryUrl, String id, String label) {
        super(repositoryUrl, id, label);
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public boolean isLocal() {
        return false;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        ITERATION,
        USER_STORY,
        TASK;


        public String toString() {
            switch (this) {
                case ITERATION: {
                    return "Iteration";
                }
                case USER_STORY: {
                    return "User Story";
                }
                case TASK: {
                    return "Task";
                }
            }
            return "";
        }

        public static Kind fromString(String kindValue) {
            Kind kind = null;
            if (kindValue.equals(TASK.toString())) {
                kind = TASK;
            } else if (kindValue.equals(USER_STORY.toString())) {
                kind = USER_STORY;
            } else if (kindValue.equals(ITERATION.toString())) {
                kind = ITERATION;
            }
            return kind;
        }
    }
}

