/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.editor;

import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.xplanner.ui.XPlannerTask;
import org.eclipse.mylyn.xplanner.ui.editor.Messages;
import org.eclipse.mylyn.xplanner.ui.editor.NewXPlannerTaskEditor;
import org.eclipse.mylyn.xplanner.ui.editor.XPlannerTaskEditor;
import org.eclipse.mylyn.xplanner.ui.editor.XPlannerUserStoryEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

public class XPlannerTaskEditorFactory
extends AbstractTaskEditorFactory {
    public boolean canCreateEditorFor(AbstractTask task) {
        return task instanceof XPlannerTask;
    }

    public IEditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        Object editor = null;
        String kind = null;
        if (editorInput instanceof RepositoryTaskEditorInput) {
            RepositoryTaskData taskData = ((RepositoryTaskEditorInput)editorInput).getTaskData();
            kind = taskData.getTaskKind();
        } else if (editorInput instanceof TaskEditorInput) {
            AbstractTask task = ((TaskEditorInput)editorInput).getTask();
            kind = task.getTaskKind();
        }
        if (XPlannerTask.Kind.TASK.toString().equals(kind)) {
            editor = editorInput instanceof RepositoryTaskEditorInput && ((RepositoryTaskEditorInput)editorInput).getTaskData().isNew() ? new NewXPlannerTaskEditor((FormEditor)parentEditor) : new XPlannerTaskEditor((FormEditor)parentEditor);
            ((AbstractRepositoryTaskEditor)editor).setParentEditor(parentEditor);
        } else if (XPlannerTask.Kind.USER_STORY.toString().equals(kind)) {
            editor = new XPlannerUserStoryEditor((FormEditor)parentEditor);
        }
        return editor;
    }

    public IEditorInput createEditorInput(AbstractTask task) {
        RepositoryTaskEditorInput input = null;
        if (task instanceof XPlannerTask) {
            XPlannerTask xplannerTask = (XPlannerTask)task;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(xplannerTask.getConnectorKind(), xplannerTask.getRepositoryUrl());
            try {
                input = new RepositoryTaskEditorInput(repository, xplannerTask.getTaskId(), xplannerTask.getUrl());
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)Messages.XPlannerTaskEditorFactory_COULD_NOT_CREATE_EDITOR_INPUT, (boolean)true);
            }
        }
        return input;
    }

    public String getTitle() {
        return Messages.XPlannerTaskEditorFactory_TITLE;
    }

    public boolean providesOutline() {
        return true;
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput existingInput = (RepositoryTaskEditorInput)input;
            return existingInput.getTaskData() != null && "xplanner".equals(existingInput.getRepository().getConnectorKind());
        }
        return false;
    }
}

