/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.web.tasks.WebQueryWizardPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class WebQueryWizard
extends Wizard {
    private static final String TITLE = "New Web Query";
    private final TaskRepository repository;
    private WebQueryWizardPage queryPage;

    public WebQueryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
    }

    public void addPages() {
        this.queryPage = new WebQueryWizardPage(this.repository);
        this.queryPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.queryPage);
    }

    public boolean performFinish() {
        AbstractRepositoryQuery query = this.queryPage.getQuery();
        if (query != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().addQuery(query);
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector != null) {
                TasksUiPlugin.getSynchronizationManager().synchronize(connector, query, null, true);
            }
        }
        return true;
    }

    public boolean canFinish() {
        if (this.queryPage.getNextPage() == null) {
            return this.queryPage.isPageComplete();
        }
        return this.queryPage.getNextPage().isPageComplete();
    }
}

