/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import com.sun.syndication.feed.module.DCModule;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.Proxy;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.ui.RetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.web.tasks.NamedPattern;
import org.eclipse.mylyn.internal.web.tasks.Util;
import org.eclipse.mylyn.internal.web.tasks.WebQuery;
import org.eclipse.mylyn.internal.web.tasks.WebTask;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.web.core.WebClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRepositoryConnector
extends AbstractRepositoryConnector {
    public static final String REPOSITORY_TYPE = "web";
    public static final String PROPERTY_TASK_CREATION_URL = "taskCreationUrl";
    public static final String PROPERTY_TASK_URL = "taskUrl";
    public static final String PROPERTY_QUERY_URL = "queryUrl";
    public static final String PROPERTY_QUERY_METHOD = "queryMethod";
    public static final String PROPERTY_QUERY_REGEXP = "queryPattern";
    public static final String PROPERTY_LOGIN_FORM_URL = "loginFormUrl";
    public static final String PROPERTY_LOGIN_TOKEN_REGEXP = "loginTokenPattern";
    public static final String PROPERTY_LOGIN_REQUEST_METHOD = "loginRequestMethod";
    public static final String PROPERTY_LOGIN_REQUEST_URL = "loginRequestUrl";
    public static final String PARAM_PREFIX = "param_";
    public static final String PARAM_SERVER_URL = "serverUrl";
    public static final String PARAM_USER_ID = "userId";
    public static final String PARAM_PASSWORD = "password";
    public static final String PARAM_LOGIN_TOKEN = "loginToken";
    public static final String REQUEST_POST = "POST";
    public static final String REQUEST_GET = "GET";
    private static final String COMPLETED_STATUSES = "completed|fixed|resolved|invalid|verified|deleted|closed|done";

    public String getConnectorKind() {
        return REPOSITORY_TYPE;
    }

    public String getLabel() {
        return "Generic web-based access (Advanced)";
    }

    public String[] getPepositoryPropertyNames() {
        return new String[]{PROPERTY_TASK_URL, PROPERTY_TASK_CREATION_URL};
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return repository.hasProperty(PROPERTY_TASK_CREATION_URL);
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return repository.hasProperty(PROPERTY_TASK_URL);
    }

    public AbstractTask createTaskFromExistingId(TaskRepository repository, String id, IProgressMonitor monitor) throws CoreException {
        if (REPOSITORY_TYPE.equals(repository.getConnectorKind())) {
            String taskPrefix = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            final WebTask task = new WebTask(id, id, taskPrefix, repository.getUrl(), REPOSITORY_TYPE);
            RetrieveTitleFromUrlJob job = new RetrieveTitleFromUrlJob(String.valueOf(taskPrefix) + id){

                protected void setTitle(String pageTitle) {
                    task.setSummary(pageTitle);
                    TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged((AbstractTask)task, false);
                }
            };
            job.schedule();
            return task;
        }
        return null;
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        for (TaskRepository repository : repositoryManager.getRepositories(this.getConnectorKind())) {
            String taskUrl = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            if (taskUrl == null || taskUrl.equals("") || !url.startsWith(taskUrl)) continue;
            return repository.getUrl();
        }
        for (AbstractRepositoryQuery query : TasksUiPlugin.getTaskListManager().getTaskList().getQueries()) {
            String queryUrl;
            WebQuery webQuery;
            TaskRepository repository;
            if (!(query instanceof WebQuery) || (repository = repositoryManager.getRepository((webQuery = (WebQuery)query).getRepositoryKind(), webQuery.getRepositoryUrl())) == null || (queryUrl = WebRepositoryConnector.evaluateParams(webQuery.getTaskPrefix(), webQuery.getQueryParameters(), repository)) == null || queryUrl.equals("") || !url.startsWith(queryUrl)) continue;
            return webQuery.getRepositoryUrl();
        }
        return null;
    }

    public String getTaskIdFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        for (TaskRepository repository : repositoryManager.getRepositories(this.getConnectorKind())) {
            String start = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            if (start == null || !url.startsWith(start)) continue;
            return url.substring(start.length());
        }
        return null;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        TaskRepository repository = repositoryManager.getRepository(this.getConnectorKind(), repositoryUrl);
        if (repository != null) {
            String prefix = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_TASK_URL), repository);
            return String.valueOf(prefix) + taskId;
        }
        return null;
    }

    public IStatus performQuery(AbstractRepositoryQuery query, TaskRepository repository, IProgressMonitor monitor, ITaskCollector resultCollector) {
        if (query instanceof WebQuery) {
            WebQuery webQuery = (WebQuery)query;
            Map<String, String> queryParameters = webQuery.getQueryParameters();
            String queryUrl = WebRepositoryConnector.evaluateParams(query.getUrl(), queryParameters, repository);
            try {
                if (webQuery.isRss()) {
                    return WebRepositoryConnector.performRssQuery(queryUrl, monitor, resultCollector, repository);
                }
                String taskPrefix = WebRepositoryConnector.evaluateParams(webQuery.getTaskPrefix(), queryParameters, repository);
                String queryPattern = WebRepositoryConnector.evaluateParams(webQuery.getQueryPattern(), queryParameters, repository);
                return WebRepositoryConnector.performQuery(WebRepositoryConnector.fetchResource(queryUrl, queryParameters, repository), queryPattern, taskPrefix, monitor, resultCollector, repository);
            }
            catch (IOException ex) {
                String msg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
                return new Status(4, "org.eclipse.mylyn.tasks.ui", 4, "Could not fetch resource: " + queryUrl + "\n" + msg, (Throwable)ex);
            }
        }
        return Status.OK_STATUS;
    }

    public boolean markStaleTasks(TaskRepository repository, Set<AbstractTask> tasks, IProgressMonitor monitor) {
        for (AbstractTask task : tasks) {
            task.setStale(true);
        }
        return true;
    }

    public AbstractAttachmentHandler getAttachmentHandler() {
        return null;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return null;
    }

    public void updateAttributes(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
    }

    public void updateTaskFromRepository(TaskRepository repository, AbstractTask repositoryTask, IProgressMonitor monitor) throws CoreException {
    }

    public AbstractTask createTask(String repositoryUrl, String id, String summary) {
        return null;
    }

    public void updateTaskFromTaskData(TaskRepository repository, AbstractTask repositoryTask, RepositoryTaskData taskData) {
    }

    public static IStatus performQuery(String resource, String regexp, String taskPrefix, IProgressMonitor monitor, ITaskCollector resultCollector, TaskRepository repository) {
        NamedPattern p = new NamedPattern(regexp, 234);
        Matcher matcher = p.matcher(resource);
        if (!matcher.find()) {
            return new Status(4, "org.eclipse.mylyn.tasks.ui", 4, "Unable to parse resource. Check query regexp", null);
        }
        boolean isCorrect = true;
        do {
            String description;
            String id;
            if (p.getGroups().isEmpty()) {
                if (matcher.groupCount() < 2) {
                    isCorrect = false;
                }
                if (matcher.groupCount() < 1) continue;
                id = matcher.group(1);
                description = matcher.groupCount() > 1 ? WebRepositoryConnector.cleanup(matcher.group(2), repository) : null;
                resultCollector.accept((AbstractTask)new WebTask(id, description, taskPrefix, repository.getUrl(), REPOSITORY_TYPE));
                continue;
            }
            id = p.group("Id", matcher);
            description = p.group("Description", matcher);
            if (id == null || description == null) {
                isCorrect = false;
            }
            if (id == null) continue;
            WebTask w = new WebTask(id, description, taskPrefix, repository.getUrl(), REPOSITORY_TYPE);
            String owner = WebRepositoryConnector.cleanup(p.group("Owner", matcher), repository);
            w.setOwner(owner);
            String type = WebRepositoryConnector.cleanup(p.group("Type", matcher), repository);
            w.setTaskKind(type);
            String status = p.group("Status", matcher);
            if (status != null) {
                w.setCompleted(COMPLETED_STATUSES.contains(status.toLowerCase()));
            }
            resultCollector.accept((AbstractTask)w);
        } while (matcher.find() && !monitor.isCanceled());
        if (isCorrect) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.mylyn.tasks.ui", 4, "Require two matching groups (taskId and summary). Check query regexp", null);
    }

    private static String cleanup(String text, TaskRepository repository) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("<!--.+?-->", "");
        String[] tokens = text.split(" |\\t|\\n|\\r");
        StringBuilder sb = new StringBuilder();
        String sep = "";
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.length() > 0) {
                sb.append(sep).append(token);
                sep = " ";
            }
            ++n2;
        }
        return sb.toString();
    }

    public static IStatus performRssQuery(String queryUrl, IProgressMonitor monitor, ITaskCollector resultCollector, TaskRepository repository) {
        SyndFeedInput input = new SyndFeedInput();
        try {
            SyndFeed feed = input.build((Reader)new XmlReader(new URL(queryUrl)));
            SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm");
            for (SyndEntry entry : feed.getEntries()) {
                String entryUri;
                Date date;
                String author = entry.getAuthor();
                if (author == null) {
                    DCModule module = (DCModule)entry.getModule("http://purl.org/dc/elements/1.1/");
                    author = module.getCreator();
                }
                if ((date = entry.getUpdatedDate()) == null) {
                    date = entry.getPublishedDate();
                }
                if (date == null) {
                    DCModule module = (DCModule)entry.getModule("http://purl.org/dc/elements/1.1/");
                    date = module.getDate();
                }
                if ((entryUri = entry.getLink()) == null) {
                    entryUri = entry.getUri();
                }
                String entrTitle = entry.getTitle();
                WebTask webTask = new WebTask(entryUri.replaceAll("-", "%2D"), String.valueOf(date == null ? "" : String.valueOf(df.format(date)) + " - ") + entrTitle, "", repository.getUrl(), REPOSITORY_TYPE);
                webTask.setCreationDate(date);
                webTask.setOwner(author);
                resultCollector.accept((AbstractTask)webTask);
            }
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            String msg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
            return new Status(4, "org.eclipse.mylyn.tasks.ui", 4, "Could not fetch resource: " + queryUrl + "\n" + msg, (Throwable)ex);
        }
    }

    public static String fetchResource(String url, Map<String, String> params, TaskRepository repository) throws IOException {
        HttpClient client = new HttpClient();
        WebClientUtil.setupHttpClient((HttpClient)client, (Proxy)repository.getProxy(), (String)url, (String)repository.getUserName(), (String)repository.getPassword());
        WebRepositoryConnector.loginRequestIfNeeded(client, params, repository);
        GetMethod method = new GetMethod(url);
        return WebRepositoryConnector.requestResource(url, client, (HttpMethod)method);
    }

    private static void loginRequestIfNeeded(HttpClient client, Map<String, String> params, TaskRepository repository) throws HttpException, IOException {
        Pattern p;
        Matcher m;
        GetMethod method;
        String loginFormPage;
        if (!(Util.isPresent(repository.getUserName()) && Util.isPresent(repository.getPassword()) && Util.isPresent(repository.getProperty(PROPERTY_LOGIN_REQUEST_URL)))) {
            return;
        }
        String loginFormUrl = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_LOGIN_FORM_URL), params, repository);
        String loginToken = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_LOGIN_TOKEN_REGEXP), params, repository);
        if ((Util.isPresent(loginFormUrl) || Util.isPresent(loginToken)) && (loginFormPage = WebRepositoryConnector.requestResource(loginFormUrl, client, (HttpMethod)(method = new GetMethod(loginFormUrl)))) != null && (m = (p = Pattern.compile(loginToken)).matcher(loginFormPage)).find()) {
            params.put("param_loginToken", m.group(1));
        }
        String loginRequestUrl = WebRepositoryConnector.evaluateParams(repository.getProperty(PROPERTY_LOGIN_REQUEST_URL), params, repository);
        String loginRequestMethod = repository.getProperty(PROPERTY_LOGIN_REQUEST_METHOD);
        GetMethod method2 = null;
        if (REQUEST_POST.equals(loginRequestMethod)) {
            int n = loginRequestUrl.indexOf(63);
            if (n == -1) {
                method2 = new PostMethod(loginRequestUrl);
            } else {
                String[] requestParams;
                PostMethod postMethod = new PostMethod(loginRequestUrl.substring(0, n));
                String[] stringArray = requestParams = loginRequestUrl.substring(n + 1).split("&");
                int n2 = requestParams.length;
                int n3 = 0;
                while (n3 < n2) {
                    String requestParam = stringArray[n3];
                    String[] nv = requestParam.split("=");
                    postMethod.addParameter(nv[0], nv.length == 1 ? "" : nv[1]);
                    ++n3;
                }
                method2 = postMethod;
            }
        } else {
            method2 = new GetMethod(loginRequestUrl);
        }
        WebRepositoryConnector.requestResource(loginRequestUrl, client, (HttpMethod)method2);
    }

    private static String requestResource(String url, HttpClient client, HttpMethod method) throws IOException, HttpException {
        String refreshUrl = null;
        try {
            client.executeMethod(method);
            refreshUrl = WebRepositoryConnector.getRefreshUrl(url, method);
            if (refreshUrl == null) {
                String string = method.getResponseBodyAsString();
                return string;
            }
        }
        finally {
            method.releaseConnection();
        }
        method = new GetMethod(refreshUrl);
        try {
            client.executeMethod(method);
            String string = method.getResponseBodyAsString();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    private static String getRefreshUrl(String url, HttpMethod method) {
        int requestPath;
        Header refreshHeader = method.getResponseHeader("Refresh");
        if (refreshHeader == null) {
            return null;
        }
        String value = refreshHeader.getValue();
        int n = value.indexOf(";url=");
        if (n == -1) {
            return null;
        }
        if ((value = value.substring(n + 5)).charAt(0) == '/') {
            int colonSlashSlash = url.indexOf("://");
            requestPath = url.indexOf(47, colonSlashSlash + 3);
        } else {
            requestPath = url.lastIndexOf(47);
        }
        String refreshUrl = requestPath == -1 ? String.valueOf(url) + "/" + value : String.valueOf(url.substring(0, requestPath + 1)) + value;
        return refreshUrl;
    }

    public static String evaluateParams(String value, Map<String, String> params, TaskRepository repository) {
        return WebRepositoryConnector.evaluateParams(WebRepositoryConnector.evaluateParams(value, params), repository);
    }

    public static String evaluateParams(String value, TaskRepository repository) {
        if (value != null && value.indexOf("${") > -1) {
            value = WebRepositoryConnector.evaluate(value, PARAM_SERVER_URL, repository.getUrl());
            value = WebRepositoryConnector.evaluate(value, PARAM_USER_ID, WebRepositoryConnector.encode(repository.getUserName()));
            value = WebRepositoryConnector.evaluate(value, PARAM_PASSWORD, WebRepositoryConnector.encode(repository.getPassword()));
            value = WebRepositoryConnector.evaluateParams(value, repository.getProperties());
        }
        return value;
    }

    public static String evaluateParams(String value, Map<String, String> params) {
        for (Map.Entry<String, String> e : params.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(PARAM_PREFIX)) continue;
            value = WebRepositoryConnector.evaluate(value, key.substring(PARAM_PREFIX.length()), WebRepositoryConnector.encode(e.getValue()));
        }
        return value;
    }

    private static String evaluate(String s, String var, String value) {
        return s.replaceAll("\\$\\{" + var + "\\}", value);
    }

    private static String encode(String value) {
        try {
            return new URLCodec().encode(value);
        }
        catch (EncoderException encoderException) {
            return value;
        }
    }

    public static List<String> getTemplateVariables(String value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> vars = new ArrayList<String>();
        Matcher m = Pattern.compile("\\$\\{(.+?)\\}").matcher(value);
        while (m.find()) {
            vars.add(m.group(1));
        }
        return vars;
    }
}

