/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import org.eclipse.mylyn.internal.web.tasks.BrowserEditorInput;
import org.eclipse.mylyn.internal.web.tasks.BrowserFormPage;
import org.eclipse.mylyn.internal.web.tasks.WebTask;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.part.EditorPart;

public class WebTaskEditorFactory
extends AbstractTaskEditorFactory {
    private static final String TITLE = "Browser";

    public IEditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        IEditorPart editor = null;
        if (editorInput instanceof TaskEditorInput) {
            TaskEditorInput taskInput = (TaskEditorInput)editorInput;
            return this.createBrowser(parentEditor, taskInput.getTask().getUrl());
        }
        return editor;
    }

    public IEditorInput createEditorInput(AbstractTask task) {
        if (task instanceof WebTask) {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("web", task.getRepositoryUrl());
            return new RepositoryTaskEditorInput(repository, task.getUrl(), task.getTaskId());
        }
        return null;
    }

    private EditorPart createBrowser(TaskEditor parentEditor, String url) {
        return new BrowserFormPage((FormEditor)parentEditor, TITLE);
    }

    public String getTitle() {
        return TITLE;
    }

    public boolean canCreateEditorFor(AbstractTask task) {
        return task instanceof WebTask;
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        return input instanceof BrowserEditorInput;
    }

    public boolean providesOutline() {
        return false;
    }
}

