/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.core.service;

import java.io.Serializable;
import java.net.Proxy;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.mylyn.xplanner.core.service.ServiceManager;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.core.service.XPlannerService;
import org.eclipse.mylyn.xplanner.wsdl.db.QueryException;
import org.xplanner.soap.IterationData;
import org.xplanner.soap.NoteData;
import org.xplanner.soap.PersonData;
import org.xplanner.soap.ProjectData;
import org.xplanner.soap.TaskData;
import org.xplanner.soap.TimeEntryData;
import org.xplanner.soap.UserStoryData;

public class CachedXPlannerClient
extends XPlannerClient
implements Serializable {
    public static final int INVALID_ID = -1;
    private static final long serialVersionUID = 1L;
    private String name;
    private String baseURL;
    private boolean hasSlowConnection;
    private String userName;
    private String password;
    private final boolean useCompression;
    private final transient Proxy proxy;
    private final String httpUser;
    private final String httpPassword;
    private transient XPlannerService serviceDelegate;

    public CachedXPlannerClient(String name, String baseURL, boolean hasSlowConnection, String userName, String password, boolean useCompression, Proxy proxy, String httpUser, String httpPassword) {
        this.name = name;
        this.baseURL = baseURL;
        this.hasSlowConnection = hasSlowConnection;
        this.userName = userName;
        this.password = password;
        this.useCompression = useCompression;
        this.proxy = proxy;
        this.httpUser = httpUser;
        this.httpPassword = httpPassword;
        this.serviceDelegate = ServiceManager.getXPlannerService(this);
        this.serviceDelegate.login(userName, password);
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getCurrentUserName() {
        return this.userName;
    }

    public String getCurrentUserPassword() {
        return this.password;
    }

    public int getMaximumNumberOfMatches() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasSlowConnection() {
        return this.hasSlowConnection;
    }

    public void setSlowConnection(boolean hasSlowConnection) {
        this.hasSlowConnection = hasSlowConnection;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public void setCurrentPassword(String password) {
        this.password = password;
    }

    public void setCurrentUserName(String userName) {
        this.userName = userName;
    }

    public String login(String username, String password) {
        return this.serviceDelegate.login(username, password);
    }

    public boolean logout() {
        boolean ok = true;
        if (this.serviceDelegate != null) {
            ok = this.serviceDelegate.logout();
        }
        return ok;
    }

    public IterationData addIteration(IterationData iteration) throws RemoteException {
        return this.serviceDelegate.addIteration(iteration);
    }

    public NoteData addNote(NoteData note) throws RemoteException {
        return this.serviceDelegate.addNote(note);
    }

    public PersonData addPerson(PersonData object) throws RemoteException {
        return this.serviceDelegate.addPerson(object);
    }

    public ProjectData addProject(ProjectData project) throws RemoteException {
        return this.serviceDelegate.addProject(project);
    }

    public TaskData addTask(TaskData task) throws RemoteException {
        return this.serviceDelegate.addTask(task);
    }

    public TimeEntryData addTimeEntry(TimeEntryData timeEntry) throws RemoteException {
        return this.serviceDelegate.addTimeEntry(timeEntry);
    }

    public UserStoryData addUserStory(UserStoryData story) throws RemoteException {
        return this.serviceDelegate.addUserStory(story);
    }

    public void deleteAttribute(int objectId, String key) throws RemoteException {
        this.serviceDelegate.deleteAttribute(objectId, key);
    }

    public boolean equals(Object obj) {
        return this == obj || this.serviceDelegate.equals(obj) || obj instanceof CachedXPlannerClient && ((CachedXPlannerClient)obj).serviceDelegate.equals(this.serviceDelegate);
    }

    public String getAttribute(int objectId, String key) throws RemoteException {
        return this.serviceDelegate.getAttribute(objectId, key);
    }

    public HashMap getAttributes(int objectId) throws RemoteException {
        return this.serviceDelegate.getAttributes(objectId);
    }

    public HashMap getAttributesWithPrefix(int objectId, String prefix) throws RemoteException {
        return this.serviceDelegate.getAttributesWithPrefix(objectId, prefix);
    }

    public IterationData getCurrentIteration(int projectId) throws RemoteException {
        return this.serviceDelegate.getCurrentIteration(projectId);
    }

    public TaskData[] getCurrentTasksForPerson(int personId) throws RemoteException, QueryException {
        return this.serviceDelegate.getCurrentTasksForPerson(personId);
    }

    public IterationData getIteration(int id) throws RemoteException {
        return this.serviceDelegate.getIteration(id);
    }

    public IterationData[] getIterations(int projectId) throws RemoteException {
        return this.serviceDelegate.getIterations(projectId);
    }

    public NoteData getNote(int id) throws RemoteException {
        return this.serviceDelegate.getNote(id);
    }

    public NoteData[] getNotesForObject(int attachedToId) throws RemoteException {
        return this.serviceDelegate.getNotesForObject(attachedToId);
    }

    public PersonData[] getPeople() throws RemoteException {
        return this.serviceDelegate.getPeople();
    }

    public PersonData getPerson(int id) throws RemoteException {
        return this.serviceDelegate.getPerson(id);
    }

    public TaskData[] getPlannedTasksForPerson(int personId) throws RemoteException, QueryException {
        return this.serviceDelegate.getPlannedTasksForPerson(personId);
    }

    public ProjectData getProject(int id) throws RemoteException {
        return this.serviceDelegate.getProject(id);
    }

    public ProjectData[] getProjects() throws RemoteException {
        return this.serviceDelegate.getProjects();
    }

    public TaskData getTask(int id) throws RemoteException {
        if (this.serviceDelegate == null) {
            System.out.println(" why is serivce Delegate null???");
        }
        return this.serviceDelegate.getTask(id);
    }

    public TaskData[] getTasks(int containerId) throws RemoteException {
        return this.serviceDelegate.getTasks(containerId);
    }

    public TimeEntryData[] getTimeEntries(int containerId) throws RemoteException {
        return this.serviceDelegate.getTimeEntries(containerId);
    }

    public TimeEntryData getTimeEntry(int id) throws RemoteException {
        return this.serviceDelegate.getTimeEntry(id);
    }

    public UserStoryData[] getUserStories(int containerId) throws RemoteException {
        return this.serviceDelegate.getUserStories(containerId);
    }

    public UserStoryData getUserStory(int id) throws RemoteException {
        return this.serviceDelegate.getUserStory(id);
    }

    public int hashCode() {
        return this.serviceDelegate.hashCode();
    }

    public void removeIteration(int id) throws RemoteException {
        this.serviceDelegate.removeIteration(id);
    }

    public void removeNote(int id) throws RemoteException {
        this.serviceDelegate.removeNote(id);
    }

    public void removePerson(int id) throws RemoteException {
        this.serviceDelegate.removePerson(id);
    }

    public void removeProject(int id) throws RemoteException {
        this.serviceDelegate.removeProject(id);
    }

    public void removeTask(int id) throws RemoteException {
        this.serviceDelegate.removeTask(id);
    }

    public void removeTimeEntry(int id) throws RemoteException {
        this.serviceDelegate.removeTimeEntry(id);
    }

    public void removeUserStory(int id) throws RemoteException {
        this.serviceDelegate.removeUserStory(id);
    }

    public void setAttribute(int objectId, String key, String value) throws RemoteException {
        this.serviceDelegate.setAttribute(objectId, key, value);
    }

    public void update(IterationData object) throws RemoteException {
        this.serviceDelegate.update(object);
    }

    public void update(NoteData note) throws RemoteException {
        this.serviceDelegate.update(note);
    }

    public void update(PersonData object) throws RemoteException {
        this.serviceDelegate.update(object);
    }

    public void update(ProjectData object) throws RemoteException {
        this.serviceDelegate.update(object);
    }

    public void update(TaskData object) throws RemoteException {
        this.serviceDelegate.update(object);
    }

    public void update(TimeEntryData object) throws RemoteException {
        this.serviceDelegate.update(object);
    }

    public void update(UserStoryData object) throws RemoteException {
        this.serviceDelegate.update(object);
    }

    public TaskData[] getUserStoryTasksForPerson(int personId, int userStoryId) {
        if (personId < 0 || userStoryId < 0) {
            return new TaskData[0];
        }
        ArrayList<TaskData> userStoryTasksForPerson = new ArrayList<TaskData>();
        try {
            TaskData[] iterationTasks = this.getTasks(userStoryId);
            int i = 0;
            while (i < iterationTasks.length) {
                TaskData taskData = iterationTasks[i];
                if (taskData.getAcceptorId() == personId) {
                    userStoryTasksForPerson.add(taskData);
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return userStoryTasksForPerson.toArray(new TaskData[userStoryTasksForPerson.size()]);
    }

    public UserStoryData[] getIterationUserStoriesForTracker(int trackerId, int iterationId) {
        if (trackerId < 0 || iterationId < 0) {
            return new UserStoryData[0];
        }
        ArrayList<UserStoryData> userStoriesForTracker = new ArrayList<UserStoryData>();
        try {
            UserStoryData[] userStories = this.getUserStories(iterationId);
            int i = 0;
            while (i < userStories.length) {
                UserStoryData userStory = userStories[i];
                if (userStory.getTrackerId() == trackerId) {
                    userStoriesForTracker.add(userStory);
                }
                ++i;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return userStoriesForTracker.toArray(new UserStoryData[userStoriesForTracker.size()]);
    }

    public int getCurrentPersonId() {
        int currentPersonId = -1;
        String userName = this.getCurrentUserName();
        if (userName != null) {
            try {
                PersonData[] people = this.getPeople();
                if (people != null) {
                    int i = 0;
                    while (i < people.length && currentPersonId == -1) {
                        PersonData person = people[i];
                        if (person.getUserId().equals(userName)) {
                            currentPersonId = person.getId();
                        }
                        ++i;
                    }
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return currentPersonId;
    }

    public UserStoryData[] getUserStoriesForProject(int projectId) {
        if (projectId == -1) {
            return new UserStoryData[0];
        }
        ArrayList projectUserStories = new ArrayList();
        try {
            IterationData[] projectIterations;
            IterationData[] iterationDataArray = projectIterations = this.getIterations(projectId);
            int n = projectIterations.length;
            int n2 = 0;
            while (n2 < n) {
                IterationData iteration = iterationDataArray[n2];
                UserStoryData[] iterationUserStories = this.getUserStories(iteration.getId());
                if (iterationUserStories.length > 0) {
                    projectUserStories.addAll(Arrays.asList(iterationUserStories));
                }
                ++n2;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return projectUserStories.toArray(new UserStoryData[projectUserStories.size()]);
    }

    public UserStoryData[] getUserStoriesForProject(int projectId, int trackerId) {
        UserStoryData[] projectUserStories;
        if (projectId == -1) {
            return new UserStoryData[0];
        }
        ArrayList<UserStoryData> projectTrackerUserStories = new ArrayList<UserStoryData>();
        UserStoryData[] userStoryDataArray = projectUserStories = this.getUserStoriesForProject(projectId);
        int n = projectUserStories.length;
        int n2 = 0;
        while (n2 < n) {
            UserStoryData userStory = userStoryDataArray[n2];
            if (userStory.getTrackerId() == trackerId) {
                projectTrackerUserStories.add(userStory);
            }
            ++n2;
        }
        return projectTrackerUserStories.toArray(new UserStoryData[projectTrackerUserStories.size()]);
    }

    public TaskData[] getTasksForProject(int projectId) {
        if (projectId == -1) {
            return new TaskData[0];
        }
        ArrayList projectTasks = new ArrayList();
        try {
            UserStoryData[] userStories;
            UserStoryData[] userStoryDataArray = userStories = this.getUserStoriesForProject(projectId);
            int n = userStories.length;
            int n2 = 0;
            while (n2 < n) {
                UserStoryData userStory = userStoryDataArray[n2];
                TaskData[] userStoryTasks = this.getTasks(userStory.getId());
                if (userStoryTasks.length > 0) {
                    projectTasks.addAll(Arrays.asList(userStoryTasks));
                }
                ++n2;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return projectTasks.toArray(new TaskData[projectTasks.size()]);
    }

    public TaskData[] getTasksForProject(int projectId, int personId) {
        TaskData[] allProjectTasks;
        if (projectId == -1 || personId == -1) {
            return new TaskData[0];
        }
        ArrayList<TaskData> projectPersonTasks = new ArrayList<TaskData>();
        TaskData[] taskDataArray = allProjectTasks = this.getTasksForProject(projectId);
        int n = allProjectTasks.length;
        int n2 = 0;
        while (n2 < n) {
            TaskData task = taskDataArray[n2];
            if (task.getAcceptorId() == personId) {
                projectPersonTasks.add(task);
            }
            ++n2;
        }
        return projectPersonTasks.toArray(new TaskData[projectPersonTasks.size()]);
    }

    public TaskData[] getTasksForIteration(int iterationId) {
        if (iterationId == -1) {
            return new TaskData[0];
        }
        ArrayList iterationTasks = new ArrayList();
        try {
            UserStoryData[] userStories;
            UserStoryData[] userStoryDataArray = userStories = this.getUserStories(iterationId);
            int n = userStories.length;
            int n2 = 0;
            while (n2 < n) {
                UserStoryData userStory = userStoryDataArray[n2];
                TaskData[] userStoryTasks = this.getTasks(userStory.getId());
                if (userStoryTasks.length > 0) {
                    iterationTasks.addAll(Arrays.asList(userStoryTasks));
                }
                ++n2;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return iterationTasks.toArray(new TaskData[iterationTasks.size()]);
    }

    public TaskData[] getTasksForIteration(int iterationId, int personId) {
        TaskData[] allIterationTasks;
        if (iterationId == -1 || personId == -1) {
            return new TaskData[0];
        }
        ArrayList<TaskData> iterationPersonTasks = new ArrayList<TaskData>();
        TaskData[] taskDataArray = allIterationTasks = this.getTasksForIteration(iterationId);
        int n = allIterationTasks.length;
        int n2 = 0;
        while (n2 < n) {
            TaskData task = taskDataArray[n2];
            if (task.getAcceptorId() == personId) {
                iterationPersonTasks.add(task);
            }
            ++n2;
        }
        return iterationPersonTasks.toArray(new TaskData[iterationPersonTasks.size()]);
    }

    public String getHttpPassword() {
        return this.httpPassword;
    }

    public String getHttpUser() {
        return this.httpUser;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public boolean useCompression() {
        return this.useCompression;
    }
}

