/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;

public class XPlannerAttributeFactory
extends AbstractAttributeFactory {
    private static final long serialVersionUID = -4685044081450189855L;
    private static final String TIME_DATE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss";
    public static final int INVALID_ID = -1;
    public static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(2);
    public static final DateFormat TIME_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String ATTRIBUTE_EST_HOURS_NAME = "estimatedHours";
    public static final String ATTRIBUTE_ACT_HOURS_NAME = "actualHours";
    public static final String ATTRIBUTE_REMAINING_HOURS_NAME = "remainingHours";
    public static final String ATTRIBUTE_ADJUSTED_ESTIMATED_HOURS_NAME = "adjustedEstimatedHours";
    public static final String ATTRIBUTE_ESTIMATED_ORIGINAL_HOURS_NAME = "estimatedOriginalHours";
    public static final String ATTRIBUTE_PROJECT_NAME = "projectName";
    public static final String ATTRIBUTE_ITERATION_NAME = "iterationName";
    public static final String ATTRIBUTE_USER_STORY_NAME = "userStoryName";
    public static final String ATTRIBUTE_TASK_COMPLETED = "completed";
    public static final String ATTRIBUTE_ASSIGNED_ID = "assignedId";
    public static final String ATTRIBUTE_PROJECT_ID = "projectId";
    public static final String ATTRIBUTE_ITERATION_ID = "iterationId";
    public static final String ATTRIBUTE_USER_STORY_ID = "userStoryId";
    public static final String ATTRIBUTE_SUBTASK_IDS = "attribute.xplanner.subtask_ids";
    public static final String ATTRIBUTE_SUBTASK_KEYS = "attribute.xplanner.subtask_keys";
    private static Map<String, Attribute> commonKeyToAttributesMap = new HashMap<String, Attribute>();

    static {
        Attribute.values();
    }

    public String getName(String key) {
        Attribute attribute = commonKeyToAttributesMap.get(key);
        return attribute != null ? attribute.getDisplayName() : key;
    }

    public String mapCommonAttributeKey(String key) {
        return key;
    }

    public boolean isHidden(String key) {
        return false;
    }

    public boolean isReadOnly(String key) {
        Attribute attribute = commonKeyToAttributesMap.get(key);
        return attribute != null ? attribute.isReadOnly() : false;
    }

    public Date getDateForAttributeType(String attributeKey, String dateString) {
        if (dateString == null || dateString.equals("")) {
            return null;
        }
        Date date = null;
        try {
            String mappedKey = this.mapCommonAttributeKey(attributeKey);
            if (mappedKey.equals(ATTRIBUTE_ACT_HOURS_NAME) || mappedKey.equals(ATTRIBUTE_EST_HOURS_NAME) || mappedKey.equals(ATTRIBUTE_REMAINING_HOURS_NAME) || mappedKey.equals("task.common.date.created")) {
                date = DATE_FORMAT.parse(dateString);
            } else if (mappedKey.equals("task.common.date.modified")) {
                date = TIME_DATE_FORMAT.parse(dateString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        DESCRIPTION("Description:", "task.common.description", false),
        OWNER("Acceptor:", "task.common.user.assigned", true),
        PRIORITY("Priority:", "task.common.priority", true),
        STATUS("Status:", "task.common.status", true),
        NAME("Name:", "task.common.summary", false),
        CREATED_ON("Created:", "task.common.date.created", true),
        MODIFIED_TIME("Last Update:", "task.common.date.modified", true),
        SUBTASK_IDS("Subtask ids:", "attribute.xplanner.subtask_ids", true),
        SUBTASK_KEYS("Sub-Tasks:", "attribute.xplanner.subtask_keys", true);

        private final boolean isReadOnly;
        private final String displayName;
        private final String commonAttributeKey;

        private Attribute(String displayName, String commonAttributeKey, boolean readonly) {
            this.displayName = displayName;
            this.commonAttributeKey = commonAttributeKey;
            this.isReadOnly = readonly;
            commonKeyToAttributesMap.put(commonAttributeKey, this);
        }

        public String getCommonAttributeKey() {
            return this.commonAttributeKey;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

