/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.xplanner.core.XPlannerClientManager;
import org.eclipse.mylyn.xplanner.core.XPlannerCorePlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.core.service.exceptions.AuthenticationException;
import org.eclipse.mylyn.xplanner.core.service.exceptions.ServiceUnavailableException;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;

public class XPlannerClientFacade
implements ITaskRepositoryListener {
    private XPlannerClientManager clientManager = null;
    private static XPlannerClientFacade instance = null;

    public XPlannerClientFacade() {
        TasksUiPlugin.getRepositoryManager().addListener((ITaskRepositoryListener)this);
        this.clientManager = XPlannerCorePlugin.getDefault().getClientManager();
    }

    public XPlannerClient getXPlannerClient(TaskRepository repository) throws CoreException {
        try {
            XPlannerRepositoryUtils.checkRepositoryValidated(repository.getUrl());
            String serverHostname = XPlannerClientFacade.getServerHost(repository);
            XPlannerClient client = this.clientManager.getClient(serverHostname);
            client = this.clientManager.createClient(serverHostname, repository.getUrl(), false, repository.getUserName(), repository.getPassword(), false, repository.getProxy(), repository.getHttpUser(), repository.getHttpPassword());
            this.clientManager.addClient(client);
            if (client == null) {
                throw new ServiceUnavailableException(String.valueOf(serverHostname) + " " + repository.getUrl());
            }
            return client;
        }
        catch (CoreException ce) {
            StatusHandler.log((String)Messages.XPlannerClientFacade_SERVER_CONNECTION_ERROR, (Object)this);
            throw ce;
        }
        catch (ServiceUnavailableException sue) {
            throw sue;
        }
        catch (RuntimeException e) {
            StatusHandler.log((String)Messages.XPlannerClientFacade_SERVER_CONNECTION_ERROR, (Object)this);
            throw e;
        }
    }

    public static XPlannerClientFacade getDefault() {
        if (instance == null) {
            instance = new XPlannerClientFacade();
        }
        return instance;
    }

    public void logOutFromAll() {
        try {
            XPlannerClient[] allClients = this.clientManager.getAllClients();
            int i = 0;
            while (i < allClients.length) {
                allClients[i].logout();
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public void repositoriesRead() {
    }

    public void repositoryAdded(TaskRepository repository) {
        if (repository.getConnectorKind().equals("xplanner")) {
            try {
                this.getXPlannerClient(repository);
            }
            catch (CoreException e) {
                StatusHandler.log((String)e.getMessage(), (Object)this);
            }
        }
    }

    public void repositoryRemoved(TaskRepository repository) {
        if (repository.getConnectorKind().equals("xplanner")) {
            String serverHostname = XPlannerClientFacade.getServerHost(repository);
            XPlannerClient client = this.clientManager.getClient(serverHostname);
            this.removeClient(client);
            XPlannerRepositoryUtils.removeValidatedRepositoryUrl(repository.getUrl());
        }
    }

    public void repositorySettingsChanged(TaskRepository repository) {
        this.repositoryRemoved(repository);
        this.repositoryAdded(repository);
    }

    public void refreshClientSettings(TaskRepository repository) {
        try {
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (client != null) {
                client.refreshDetails();
            }
        }
        catch (Exception e) {
            String reason = e.getLocalizedMessage();
            if (reason == null || reason.length() == 0) {
                reason = e.getClass().getName();
            }
            StatusHandler.log((IStatus)new Status(0, "org.eclipse.mylyn.tasks.ui", 4, MessageFormat.format(Messages.XPlannerRepositoryConnector_PerformQueryFailure, reason), (Throwable)e));
        }
    }

    private void removeClient(XPlannerClient client) {
        if (client != null) {
            client.logout();
            this.clientManager.removeClient(client);
        }
    }

    public void validateServerAndCredentials(String serverUrl, String user, String password, Proxy proxy, String httpUser, String httpPassword) throws Exception {
        XPlannerRepositoryUtils.removeValidatedRepositoryUrl(serverUrl);
        this.clientManager.testConnection(serverUrl, user, password, proxy, httpUser, httpPassword);
        XPlannerRepositoryUtils.addValidatedRepositoryUrl(serverUrl);
    }

    private static String getServerHost(TaskRepository repository) {
        try {
            return new URL(repository.getUrl()).getHost();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(String.valueOf(Messages.XPlannerClientFacade_INVALID_URL_EXCEPTION) + repository.getUrl(), ex);
        }
    }

    public static void handleConnectionException(Exception e) {
        if (e instanceof ServiceUnavailableException) {
            StatusHandler.fail((Throwable)e, (String)(String.valueOf(Messages.XPlannerClientFacade_CONNECTION_FAILURE_ERROR) + Messages.XPlannerClientFacade_NETWORK_CONNECTION_FAILURE), (boolean)true);
        } else if (e instanceof AuthenticationException) {
            StatusHandler.fail((Throwable)e, (String)(String.valueOf(Messages.XPlannerClientFacade_AUTHENTICATION_FAILED) + Messages.XPlannerClientFacade_USERNAME_PASSWORD_ERROR), (boolean)true);
        } else if (e instanceof RuntimeException) {
            StatusHandler.fail((Throwable)e, (String)(String.valueOf(Messages.XPlannerClientFacade_NO_REPOSITORY_FOUND) + Messages.XPlannerClientFacade_VERIFY_VALID_REPOSITORY), (boolean)true);
        } else {
            StatusHandler.fail((Throwable)e, (String)(String.valueOf(Messages.XPlannerClientFacade_COULD_NOT_CONNECT_TO_REPOSITORY) + Messages.XPlannerClientFacade_CHECK_CREDENTIALS), (boolean)true);
        }
    }
}

