/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.tasks.ui.TaskListImageDescriptor;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.swt.graphics.Image;

public class XPlannerImages {
    private static ImageRegistry imageRegistry;
    private static final String T_VIEW = "eview16";
    private static final URL baseURL;
    public static final ImageDescriptor OVERLAY_XPLANNER;
    public static final ImageDescriptor OVERLAY_ITERATION;
    public static final ImageDescriptor OVERLAY_USER_STORY;
    public static final ImageDescriptor OVERLAY_TASK;
    public static final ImageDescriptor TREEITEM_PROJECT;
    public static final ImageDescriptor TREEITEM_ITERATION;
    public static final ImageDescriptor TREEITEM_USER_STORY;
    public static final ImageDescriptor TREEITEM_PROJECT_OVERLAY;
    public static final ImageDescriptor TREEITEM_ITERATION_OVERLAY;
    public static final ImageDescriptor TREEITEM_USER_STORY_OVERLAY;

    static {
        baseURL = XPlannerMylynUIPlugin.getDefault() == null ? null : XPlannerMylynUIPlugin.getDefault().getBundle().getEntry("/icons/");
        OVERLAY_XPLANNER = XPlannerImages.create(T_VIEW, "overlay-xplanner.gif");
        OVERLAY_ITERATION = XPlannerImages.create(T_VIEW, "overlay-iteration.gif");
        OVERLAY_USER_STORY = XPlannerImages.create(T_VIEW, "overlay-userstory.gif");
        OVERLAY_TASK = XPlannerImages.create(T_VIEW, "overlay-task.gif");
        TREEITEM_PROJECT = XPlannerImages.create(T_VIEW, "treeitem-project.gif");
        TREEITEM_ITERATION = XPlannerImages.create(T_VIEW, "treeitem-iteration.gif");
        TREEITEM_USER_STORY = XPlannerImages.create(T_VIEW, "treeitem-userstory.gif");
        TREEITEM_PROJECT_OVERLAY = XPlannerImages.create(TREEITEM_PROJECT, OVERLAY_XPLANNER);
        TREEITEM_ITERATION_OVERLAY = XPlannerImages.create(TREEITEM_ITERATION, OVERLAY_XPLANNER);
        TREEITEM_USER_STORY_OVERLAY = XPlannerImages.create(TREEITEM_USER_STORY, OVERLAY_XPLANNER);
    }

    private XPlannerImages() {
    }

    private static ImageDescriptor create(String prefix, String name) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)XPlannerImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            id = ImageDescriptor.getMissingImageDescriptor();
        }
        return id;
    }

    private static ImageDescriptor create(ImageDescriptor imageDescriptor, ImageDescriptor overlayDescriptor) {
        return new TaskListImageDescriptor(imageDescriptor, overlayDescriptor, false, false);
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = XPlannerImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage();
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }
}

