/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.ui.Messages;
import org.eclipse.mylyn.xplanner.ui.XPlannerAttributeFactory;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.xplanner.ui.XPlannerCustomQuery;
import org.eclipse.mylyn.xplanner.ui.XPlannerMylynUIPlugin;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.XPlannerTask;
import org.eclipse.mylyn.xplanner.ui.XPlannerTaskDataHandler;
import org.eclipse.mylyn.xplanner.wsdl.soap.domain.DomainData;
import org.xplanner.soap.TaskData;
import org.xplanner.soap.UserStoryData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerRepositoryConnector
extends AbstractRepositoryConnector {
    private XPlannerTaskDataHandler offlineHandler;
    public static final String NEW_TASK_DESC = Messages.XPlannerRepositoryConnector_NEW_TASK_DESCRIPTION;

    public void init(TaskList taskList) {
        super.init(taskList);
        this.offlineHandler = new XPlannerTaskDataHandler(taskList);
    }

    public String getLabel() {
        return XPlannerMylynUIPlugin.XPLANNER_CLIENT_LABEL;
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public AbstractAttachmentHandler getAttachmentHandler() {
        return null;
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.offlineHandler;
    }

    public boolean canCreateTaskFromKey(TaskRepository repository) {
        return true;
    }

    protected AbstractTask makeTask(String repositoryUrl, String id, String summary) {
        return new XPlannerTask(repositoryUrl, id, summary);
    }

    public AbstractTask createTask(String repositoryUrl, String id, String summary) {
        AbstractTask task = null;
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        String handleIdentifier = RepositoryTaskHandleUtil.getHandle((String)repository.getUrl(), (String)id);
        AbstractTask existingTask = TasksUiPlugin.getTaskListManager().getTaskList().getTask(handleIdentifier);
        if (existingTask instanceof XPlannerTask) {
            task = existingTask;
        } else {
            try {
                task = this.createTask(repository, id);
            }
            catch (CoreException e) {
                XPlannerMylynUIPlugin.log(e, "", false);
            }
        }
        return task;
    }

    private AbstractTask createTask(TaskRepository repository, String key) throws CoreException {
        XPlannerTask task = null;
        XPlannerRepositoryUtils.checkRepositoryValidated(repository.getUrl());
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        if (client != null) {
            try {
                TaskData taskData = client.getTask(Integer.valueOf(key).intValue());
                if (taskData != null) {
                    task = this.createTask((DomainData)taskData, taskData.getName(), String.valueOf(taskData.getId()), repository);
                } else {
                    UserStoryData userStory = client.getUserStory(Integer.valueOf(key).intValue());
                    if (userStory != null) {
                        task = this.createTask((DomainData)userStory, userStory.getName(), String.valueOf(userStory.getId()), repository);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return task;
    }

    public IStatus performQuery(AbstractRepositoryQuery repositoryQuery, TaskRepository repository, IProgressMonitor monitor, ITaskCollector resultCollector) {
        if (!(repositoryQuery instanceof XPlannerCustomQuery)) {
            return Status.OK_STATUS;
        }
        XPlannerCustomQuery xplannerCustomQuery = (XPlannerCustomQuery)repositoryQuery;
        try {
            monitor.beginTask("Running query", -1);
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (xplannerCustomQuery.isMyCurrentTasks()) {
                IStatus iStatus = this.queryMyCurrentTasks(xplannerCustomQuery, client, repository, resultCollector);
                return iStatus;
            }
            IStatus iStatus = this.queryTasks(xplannerCustomQuery, client, repository, resultCollector);
            return iStatus;
        }
        catch (Exception e) {
            String reason = e.getLocalizedMessage();
            if (reason == null || reason.length() == 0) {
                reason = e.getClass().getName();
            }
            Status status = new Status(0, "org.eclipse.mylyn.tasks.ui", 4, MessageFormat.format(Messages.XPlannerRepositoryConnector_PerformQueryFailure, reason), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public boolean canCreateNewTask(TaskRepository repository) {
        return true;
    }

    private IStatus queryMyCurrentTasks(XPlannerCustomQuery xplannerCustomQuery, XPlannerClient client, TaskRepository repository, ITaskCollector resultCollector) throws RemoteException {
        ArrayList<TaskData> xplannerTasks = new ArrayList<TaskData>();
        int currentPersonId = client.getCurrentPersonId();
        xplannerTasks.addAll((Collection)Arrays.asList(client.getCurrentTasksForPerson(currentPersonId)));
        xplannerTasks.addAll((Collection)Arrays.asList(client.getPlannedTasksForPerson(currentPersonId)));
        return this.getTaskQueryHits(xplannerTasks, repository, xplannerCustomQuery, resultCollector);
    }

    private IStatus queryTasks(XPlannerCustomQuery xplannerCustomQuery, XPlannerClient client, TaskRepository repository, ITaskCollector resultCollector) throws RemoteException {
        List<Integer> contentIds = xplannerCustomQuery.getContentIds();
        ArrayList<TaskData> xplannerTasks = new ArrayList<TaskData>();
        XPlannerCustomQuery.ContentIdType contentIdType = xplannerCustomQuery.getContentIdType();
        for (Integer contentId : contentIds) {
            this.addTasks(contentId, contentIdType, xplannerTasks, xplannerCustomQuery, client);
        }
        return this.getTaskQueryHits(xplannerTasks, repository, xplannerCustomQuery, resultCollector);
    }

    private void addTasks(int contentId, XPlannerCustomQuery.ContentIdType contentIdType, List<TaskData> xplannerTasks, XPlannerCustomQuery xplannerCustomQuery, XPlannerClient client) throws RemoteException {
        if (contentId == -1) {
            return;
        }
        if (contentIdType == XPlannerCustomQuery.ContentIdType.PROJECT) {
            UserStoryData[] userStories;
            UserStoryData[] userStoryDataArray = userStories = client.getUserStoriesForProject(contentId);
            int n = userStories.length;
            int n2 = 0;
            while (n2 < n) {
                UserStoryData userStory = userStoryDataArray[n2];
                this.addUserStoryTasks(xplannerCustomQuery, userStory.getId(), xplannerTasks, client);
                ++n2;
            }
        } else if (contentIdType == XPlannerCustomQuery.ContentIdType.ITERATION) {
            UserStoryData[] userStories;
            UserStoryData[] userStoryDataArray = userStories = client.getUserStories(contentId);
            int n = userStories.length;
            int n3 = 0;
            while (n3 < n) {
                UserStoryData userStory = userStoryDataArray[n3];
                this.addUserStoryTasks(xplannerCustomQuery, userStory.getId(), xplannerTasks, client);
                ++n3;
            }
        } else if (contentIdType == XPlannerCustomQuery.ContentIdType.USER_STORY) {
            this.addUserStoryTasks(xplannerCustomQuery, contentId, xplannerTasks, client);
        }
    }

    private void addUserStoryTasks(XPlannerCustomQuery query, int userStoryId, List<TaskData> xplannerTasks, XPlannerClient client) {
        if (query.getPersonId() != -1) {
            int personId = query.getPersonId();
            xplannerTasks.addAll((Collection<TaskData>)Arrays.asList(client.getUserStoryTasksForPerson(personId, userStoryId)));
        } else {
            try {
                xplannerTasks.addAll((Collection<TaskData>)Arrays.asList(client.getTasks(userStoryId)));
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private IStatus getTaskQueryHits(List<TaskData> tasks, TaskRepository repository, XPlannerCustomQuery query, ITaskCollector resultCollector) {
        for (TaskData data : tasks) {
            String id = String.valueOf(data.getId());
            AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(repository.getUrl(), id);
            if (task != null) {
                this.updateTaskDetails(repository.getUrl(), (XPlannerTask)task, data, false);
            } else {
                task = this.createTask((DomainData)data, data.getName(), String.valueOf(data.getId()), repository);
            }
            resultCollector.accept(task);
        }
        return Status.OK_STATUS;
    }

    public void updateTaskFromRepository(TaskRepository repository, AbstractTask repositoryTask, IProgressMonitor monitor) throws CoreException {
        if (repository != null && repositoryTask instanceof XPlannerTask) {
            XPlannerTask xPlannerTask = (XPlannerTask)repositoryTask;
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (client != null) {
                try {
                    TaskData xplannerTaskData = client.getTask(Integer.valueOf(xPlannerTask.getTaskId()).intValue());
                    if (xplannerTaskData != null) {
                        this.updateTaskDetails(repository.getUrl(), xPlannerTask, xplannerTaskData, true);
                    } else {
                        UserStoryData userStoryData = client.getUserStory(Integer.valueOf(xPlannerTask.getTaskId()).intValue());
                        if (userStoryData != null) {
                            XPlannerRepositoryConnector.updateTaskDetails(repository.getUrl(), xPlannerTask, userStoryData, true);
                        }
                    }
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.xplanner.ui", 4, Messages.XPlannerRepositoryConnector_ERROR_UPDATING_TASK, (Throwable)e));
                }
            }
        }
    }

    public void updateTaskFromTaskData(TaskRepository repository, AbstractTask repositoryTask, RepositoryTaskData taskData) {
        if (taskData != null) {
            XPlannerTask xplannerTask = (XPlannerTask)repositoryTask;
            String url = String.valueOf(repository.getUrl()) + "/do/view/task?oid=" + taskData.getId();
            xplannerTask.setUrl(url);
            xplannerTask.setSummary(taskData.getSummary());
            xplannerTask.setOwner(taskData.getAssignedTo());
            xplannerTask.setPriority(taskData.getAttributeValue("task.common.priority"));
            xplannerTask.setTaskKind(taskData.getTaskKind());
            if (XPlannerRepositoryUtils.isCompleted(taskData)) {
                xplannerTask.setCompleted(true);
                try {
                    xplannerTask.setCompletionDate(XPlannerAttributeFactory.TIME_DATE_FORMAT.parse(taskData.getAttribute("task.common.date.modified").getValue()));
                }
                catch (ParseException e) {
                    StatusHandler.log((Throwable)e, (String)Messages.XPlannerRepositoryConnector_COULD_NOT_CONVERT_TASK_DATE);
                }
            } else {
                xplannerTask.setCompleted(false);
                xplannerTask.setCompletionDate(null);
            }
        }
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("/do/view/");
        if (index != -1) {
            return url.substring(0, index);
        }
        return null;
    }

    public void updateTaskDetails(String repositoryUrl, XPlannerTask task, TaskData taskData, boolean notifyOfChange) {
        if (taskData.getId() > 0) {
            String url = String.valueOf(repositoryUrl) + "/do/view/task?oid=" + taskData.getId();
            task.setUrl(url);
            if (taskData.getName() != null) {
                task.setSummary(taskData.getName());
            }
        }
        if (taskData.isCompleted()) {
            task.setCompleted(true);
            task.setCompletionDate(taskData.getLastUpdateTime().getTime());
        } else {
            task.setCompleted(false);
            task.setCompletionDate(null);
        }
        if (notifyOfChange) {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged((AbstractTask)task, true);
        }
    }

    public static void updateTaskDetails(String repositoryUrl, XPlannerTask task, UserStoryData userStory, boolean notifyOfChange) {
        if (userStory.getId() > 0) {
            String url = String.valueOf(repositoryUrl) + "/do/view/userstory?oid=" + userStory.getId();
            task.setUrl(url);
            if (userStory.getName() != null) {
                task.setSummary(userStory.getName());
                task.setKey(String.valueOf(userStory.getId()));
            }
        }
        if (userStory.isCompleted()) {
            task.setCompleted(true);
            task.setCompletionDate(userStory.getLastUpdateTime().getTime());
        } else {
            task.setCompleted(false);
            task.setCompletionDate(null);
        }
        task.setPriority("" + userStory.getPriority());
        task.setTaskKind(XPlannerTask.Kind.USER_STORY.toString());
        if (notifyOfChange) {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged((AbstractTask)task, true);
        }
    }

    public XPlannerTask createTask(DomainData data, String name, String id, TaskRepository repository) {
        XPlannerTask task;
        AbstractTask existingTask = TasksUiPlugin.getTaskListManager().getTaskList().getTask(repository.getUrl(), id);
        if (existingTask instanceof XPlannerTask) {
            task = (XPlannerTask)existingTask;
        } else {
            task = new XPlannerTask(repository.getUrl(), id, name);
            task.setKind(data);
        }
        return task;
    }

    public String toString() {
        return this.getLabel();
    }

    public void updateAttributes(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        XPlannerClientFacade.getDefault().refreshClientSettings(repository);
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        String taskUrl = null;
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("xplanner", repositoryUrl);
        try {
            XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            if (client != null) {
                TaskData taskData = client.getTask(Integer.valueOf(taskId).intValue());
                if (taskData != null) {
                    if (taskData.getId() > 0) {
                        taskUrl = String.valueOf(repositoryUrl) + "/do/view/task?oid=" + taskData.getId();
                    }
                } else {
                    UserStoryData userStory = client.getUserStory(Integer.valueOf(taskId).intValue());
                    if (userStory != null) {
                        taskUrl = String.valueOf(repositoryUrl) + "/do/view/userstory?oid=" + userStory.getId();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return taskUrl;
    }

    public String getTaskIdFromTaskUrl(String url) {
        String taskId = null;
        if (url == null) {
            return null;
        }
        int index = url.indexOf("?oid=");
        if (index != -1) {
            taskId = url.substring(index + "?oid=".length());
        }
        return taskId;
    }

    public Set<AbstractTask> getChangedSinceLastSync(TaskRepository repository, Set<AbstractTask> tasks) throws CoreException {
        XPlannerClient client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
        if (client == null) {
            return Collections.emptySet();
        }
        HashSet<AbstractTask> changedTasks = new HashSet<AbstractTask>();
        for (AbstractTask task : tasks) {
            if (!(task instanceof XPlannerTask)) continue;
            XPlannerTask xplannerTask = (XPlannerTask)task;
            try {
                TaskData taskData = client.getTask(Integer.valueOf(xplannerTask.getTaskId()).intValue());
                if (taskData == null) continue;
                Date lastUpdateTime = taskData.getLastUpdateTime().getTime();
                String lastSynchStamp = xplannerTask.getLastReadTimeStamp();
                Date lastSynchTime = null;
                if (lastSynchStamp != null && lastSynchStamp.length() > 0) {
                    lastSynchTime = XPlannerAttributeFactory.TIME_DATE_FORMAT.parse(lastSynchStamp);
                }
                if (lastSynchTime != null && !lastUpdateTime.after(lastSynchTime)) continue;
                changedTasks.add(task);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return changedTasks;
    }

    public boolean markStaleTasks(TaskRepository repository, Set<AbstractTask> tasks, IProgressMonitor monitor) throws CoreException {
        boolean changed = false;
        try {
            monitor.beginTask("Getting changed tasks", -1);
            if (repository.getSynchronizationTimeStamp() == null) {
                for (AbstractTask task : tasks) {
                    task.setStale(true);
                }
                changed = true;
            } else {
                Set<AbstractTask> changedTasks = this.getChangedSinceLastSync(repository, tasks);
                for (AbstractTask changedTask : changedTasks) {
                    changedTask.setStale(true);
                }
                changed = true;
            }
        }
        finally {
            monitor.done();
        }
        return changed;
    }
}

