/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.xplanner.ui.XPlannerCustomQuery;
import org.eclipse.mylyn.xplanner.ui.XPlannerImages;
import org.eclipse.mylyn.xplanner.ui.XPlannerTask;
import org.eclipse.mylyn.xplanner.ui.wizard.EditXPlannerQueryWizard;
import org.eclipse.mylyn.xplanner.ui.wizard.NewXPlannerQueryWizard;
import org.eclipse.mylyn.xplanner.ui.wizard.NewXPlannerTaskWizard;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerCustomQueryPage;
import org.eclipse.mylyn.xplanner.ui.wizard.XPlannerRepositorySettingsPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPlannerRepositoryUi
extends AbstractRepositoryConnectorUi {
    public AbstractRepositorySettingsPage getSettingsPage() {
        return new XPlannerRepositorySettingsPage(this);
    }

    public ImageDescriptor getTaskKindOverlay(AbstractTask task) {
        XPlannerTask.Kind kind = XPlannerTask.Kind.fromString(task.getTaskKind());
        ImageDescriptor overlayImage = kind.equals((Object)XPlannerTask.Kind.TASK) ? XPlannerImages.OVERLAY_TASK : (kind.equals((Object)XPlannerTask.Kind.USER_STORY) ? XPlannerImages.OVERLAY_USER_STORY : (kind.equals((Object)XPlannerTask.Kind.ITERATION) ? XPlannerImages.OVERLAY_ITERATION : super.getTaskKindOverlay(task)));
        return overlayImage;
    }

    public WizardPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new XPlannerCustomQueryPage(repository, null);
    }

    public IWizard getQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        if (query instanceof XPlannerCustomQuery) {
            return new EditXPlannerQueryWizard(repository, query);
        }
        return new NewXPlannerQueryWizard(repository);
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository) {
        return new NewXPlannerTaskWizard(taskRepository);
    }

    public String getConnectorKind() {
        return "xplanner";
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getTaskKindLabel(AbstractTask repositoryTask) {
        return repositoryTask == null ? super.getTaskKindLabel(repositoryTask) : repositoryTask.getTaskKind();
    }

    public List<AbstractTaskContainer> getLegendItems() {
        ArrayList<AbstractTaskContainer> legendItems = new ArrayList<AbstractTaskContainer>();
        XPlannerTask task = new XPlannerTask("", XPlannerTask.Kind.TASK.name(), XPlannerTask.Kind.TASK.toString());
        task.setTaskKind(XPlannerTask.Kind.TASK.toString());
        legendItems.add((AbstractTaskContainer)task);
        XPlannerTask userStory = new XPlannerTask("", XPlannerTask.Kind.USER_STORY.name(), XPlannerTask.Kind.USER_STORY.toString());
        userStory.setTaskKind(XPlannerTask.Kind.USER_STORY.toString());
        legendItems.add((AbstractTaskContainer)userStory);
        XPlannerTask iteration = new XPlannerTask("", XPlannerTask.Kind.ITERATION.name(), XPlannerTask.Kind.ITERATION.toString());
        iteration.setTaskKind(XPlannerTask.Kind.ITERATION.toString());
        legendItems.add((AbstractTaskContainer)iteration);
        return legendItems;
    }
}

