/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.editor;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.editor.Messages;
import org.eclipse.mylyn.xplanner.ui.editor.XPlannerEditorAttributeProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class XPlannerTaskEditorExtraControls {
    private AbstractRepositoryTaskEditor editor;
    RepositoryTaskData repositoryTaskData;
    private Label remainingTimeValueLabel;
    private Button completedButton;

    public XPlannerTaskEditorExtraControls(AbstractRepositoryTaskEditor editor, RepositoryTaskData repositoryTaskData) {
        this.editor = editor;
        this.repositoryTaskData = repositoryTaskData;
    }

    protected void createPartControlCustom(Composite parent, boolean showTask) {
        FormToolkit toolkit = new FormToolkit(this.editor.getSite().getShell().getDisplay());
        this.createHierarchySection(toolkit, parent, this.repositoryTaskData, showTask);
        this.createDataSection(toolkit, parent, this.repositoryTaskData);
    }

    protected void createHierarchySection(FormToolkit toolkit, Composite formBody, RepositoryTaskData repositoryTaskData, boolean showTask) {
        Section hierarchySection = toolkit.createSection(formBody, 258);
        hierarchySection.setText(Messages.XPlannerTaskEditor_HIERARCHY_SECTION_TITLE);
        hierarchySection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hierarchySection);
        hierarchySection.setExpanded(true);
        Composite hierarchyComposite = toolkit.createComposite((Composite)hierarchySection, 0);
        GridLayout hierarchyGridLayout = new GridLayout(1, false);
        hierarchyGridLayout.marginWidth = 0;
        hierarchyComposite.setLayout((Layout)hierarchyGridLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)hierarchyComposite);
        hierarchySection.setClient((Control)hierarchyComposite);
        Tree hierarchyTree = toolkit.createTree(hierarchyComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).minSize(200, 80).applyTo((Control)hierarchyTree);
        TreeItem projectItem = new TreeItem(hierarchyTree, 0);
        projectItem.setText(XPlannerRepositoryUtils.getProjectName(repositoryTaskData));
        TreeItem iterationItem = new TreeItem(projectItem, 0);
        iterationItem.setText(XPlannerRepositoryUtils.getIterationName(repositoryTaskData));
        TreeItem storyItem = new TreeItem(iterationItem, 0);
        storyItem.setText(XPlannerRepositoryUtils.getUserStoryName(repositoryTaskData));
        if (showTask) {
            TreeItem taskItem = new TreeItem(storyItem, 0);
            taskItem.setText(XPlannerRepositoryUtils.getName(repositoryTaskData));
            hierarchyTree.showItem(taskItem);
        } else {
            hierarchyTree.showItem(storyItem);
        }
        hierarchySection.setExpanded(true);
    }

    private void createDataSection(FormToolkit toolkit, Composite formBody, RepositoryTaskData repositoryTaskData) {
        Section dataSection = toolkit.createSection(formBody, 258);
        dataSection.setText(Messages.XPlannerTaskEditor_DATA_SECTION_TITLE);
        dataSection.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, true).align(4, 128).applyTo((Control)dataSection);
        dataSection.setExpanded(true);
        Composite dataComposite = toolkit.createComposite((Composite)dataSection, 2048);
        dataComposite.setLayout((Layout)new GridLayout(5, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dataComposite);
        dataSection.setClient((Control)dataComposite);
        Label acceptorLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ACCEPTOR_TEXT);
        acceptorLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        Label acceptorValue = toolkit.createLabel(dataComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000000).applyTo((Control)acceptorValue);
        acceptorValue.setText(repositoryTaskData.getAssignedTo());
        Label estimatedHoursLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ESTIMATED_HOURS_TEXT);
        estimatedHoursLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        final Text estimatedTimeText = toolkit.createText(dataComposite, "" + XPlannerRepositoryUtils.getAdjustedEstimatedHours(repositoryTaskData));
        estimatedTimeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XPlannerTaskEditorExtraControls.this.updateAttribute("estimatedHours", estimatedTimeText.getText());
            }
        });
        toolkit.createLabel(dataComposite, " (" + XPlannerRepositoryUtils.getEstimatedOriginalHours(repositoryTaskData) + ")");
        this.completedButton = toolkit.createButton(dataComposite, Messages.XPlannerTaskEditor_COMPLETED_BUTTON, 32);
        this.completedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                XPlannerTaskEditorExtraControls.this.updateAttribute("completed", XPlannerTaskEditorExtraControls.this.completedButton.getSelection() ? "1" : "0");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.completedButton.setSelection(XPlannerRepositoryUtils.isCompleted(repositoryTaskData));
        Label actualTimeLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_ACTUAL_HOURS_TEXT);
        actualTimeLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(0x1000008, 0x1000000).applyTo((Control)actualTimeLabel);
        toolkit.createLabel(dataComposite, String.valueOf(XPlannerRepositoryUtils.getActualHours(repositoryTaskData)));
        Label remainingTimeLabel = toolkit.createLabel(dataComposite, Messages.XPlannerTaskEditor_REMAINING_HOURS_TEXT);
        remainingTimeLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).align(0x1000008, 0x1000000).applyTo((Control)remainingTimeLabel);
        this.remainingTimeValueLabel = toolkit.createLabel(dataComposite, String.valueOf(XPlannerRepositoryUtils.getRemainingHours(repositoryTaskData)));
        this.updateRemainingTimeFont();
        dataSection.setExpanded(true);
    }

    private void updateRemainingTimeFont() {
        if (this.remainingTimeValueLabel != null) {
            if (this.isTaskCompleted()) {
                this.remainingTimeValueLabel.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
            } else {
                this.remainingTimeValueLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
        }
    }

    private boolean isTaskCompleted() {
        return this.completedButton.getSelection();
    }

    private void updateAttribute(String attributeName, String attributeValue) {
        RepositoryTaskAttribute attribute = this.repositoryTaskData.getAttribute(attributeName);
        attribute.setValue(attributeValue);
        if (this.editor instanceof XPlannerEditorAttributeProvider) {
            ((XPlannerEditorAttributeProvider)this.editor).xplannerAttributeChanged(attribute);
        }
    }
}

