/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.xplanner.ui.XPlannerClientFacade;
import org.eclipse.mylyn.xplanner.ui.wizard.ProjectsViewerContentProvider;
import org.eclipse.mylyn.xplanner.ui.wizard.ProjectsViewerLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.xplanner.soap.UserStoryData;

public class NewXPlannerTaskPage
extends WizardPage {
    private static final String DESCRIPTION = "Pick a user story to open the new task editor.\nPress the Update button if the story is not in the list.";
    private static final String LABEL_UPDATE = "Update from Repository";
    private FilteredTree projectTree;
    private XPlannerClient client;
    private TaskRepository repository;

    public NewXPlannerTaskPage(TaskRepository repository) {
        super("XPlannerUserStory");
        this.repository = repository;
        this.setTitle("New XPlanner Task");
        this.setDescription(DESCRIPTION);
        try {
            this.client = XPlannerClientFacade.getDefault().getXPlannerClient(repository);
            this.setPageComplete(false);
        }
        catch (CoreException ce) {
            StatusHandler.displayStatus((String)"Repository Error", (IStatus)ce.getStatus());
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.projectTree = new FilteredTree(composite, 2052, new PatternFilter());
        this.projectTree.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).hint(-1, 200).create());
        TreeViewer projectsViewer = this.projectTree.getViewer();
        projectsViewer.setContentProvider((IContentProvider)new ProjectsViewerContentProvider(this.client));
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ProjectsViewerLabelProvider());
        GridData projectsViewerGridData = new GridData(4, 4, true, true);
        projectsViewerGridData.heightHint = 100;
        projectsViewerGridData.widthHint = 200;
        projectsViewer.getTree().setLayoutData((Object)projectsViewerGridData);
        projectsViewer.setInput((Object)this.client);
        projectsViewer.refresh();
        projectsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                NewXPlannerTaskPage.this.validatePage(true);
            }
        });
        projectsViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                if (NewXPlannerTaskPage.this.getWizard().canFinish() && NewXPlannerTaskPage.this.getWizard().performFinish()) {
                    ((WizardDialog)NewXPlannerTaskPage.this.getContainer()).close();
                }
            }
        });
        this.updateProjectsFromRepository(false);
        Button updateButton = new Button(composite, 16392);
        updateButton.setText(LABEL_UPDATE);
        updateButton.setLayoutData((Object)new GridData());
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewXPlannerTaskPage.this.updateProjectsFromRepository(true);
            }
        });
        this.setControl((Control)composite);
        this.isPageComplete();
        this.getWizard().getContainer().updateButtons();
    }

    public void validatePage(boolean updatePageComplete) {
        String errorMessage = null;
        if (this.getSelectedUserStory() == null) {
            errorMessage = "A user story for the new task needs to be selected";
        }
        this.setErrorMessage(errorMessage);
        if (updatePageComplete) {
            this.setPageComplete(errorMessage == null);
        }
    }

    public boolean isPageComplete() {
        this.validatePage(false);
        return this.getErrorMessage() == null;
    }

    private void updateProjectsFromRepository(boolean force) {
        if (force) {
            try {
                final AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Updating repository ...", -1);
                        try {
                            try {
                                connector.updateAttributes(NewXPlannerTaskPage.this.repository, monitor);
                            }
                            catch (Exception e) {
                                String msg = NLS.bind((String)"Error updating attributes: {0}\nPlease check repository settings in the Task Repositories view.", (Object)e.getMessage());
                                this.showWarning(msg);
                                StatusHandler.fail((Throwable)e, (String)msg, (boolean)false);
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }

                    private void showWarning(final String msg) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                NewXPlannerTaskPage.this.setErrorMessage(msg);
                            }
                        });
                    }
                });
            }
            catch (Exception exception) {
                return;
            }
        }
        this.projectTree.getViewer().setInput((Object)this.client);
    }

    public UserStoryData getSelectedUserStory() {
        UserStoryData selectedUserStory = null;
        IStructuredSelection selection = (IStructuredSelection)this.projectTree.getViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof UserStoryData) {
            selectedUserStory = (UserStoryData)selection.getFirstElement();
        }
        return selectedUserStory;
    }
}

