/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.xplanner.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.mylyn.xplanner.ui.XPlannerRepositoryUtils;
import org.eclipse.mylyn.xplanner.ui.wizard.NewXPlannerTaskPage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewXPlannerTaskWizard
extends Wizard
implements INewWizard {
    private TaskRepository taskRepository;
    private NewXPlannerTaskPage userStoryPage;

    public NewXPlannerTaskWizard(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
        this.userStoryPage = new NewXPlannerTaskPage(taskRepository);
        this.setWindowTitle("New Task");
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.userStoryPage);
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.userStoryPage != null) {
            canFinish = this.userStoryPage.isPageComplete();
        }
        return canFinish;
    }

    public boolean performFinish() {
        try {
            RepositoryTaskData taskData = XPlannerRepositoryUtils.getNewRepositoryTaskData(this.taskRepository, this.userStoryPage.getSelectedUserStory());
            NewTaskEditorInput editorInput = new NewTaskEditorInput(this.taskRepository, taskData);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TasksUiUtil.openEditor((IEditorInput)editorInput, (String)"org.eclipse.mylyn.tasks.ui.editors.task", (IWorkbenchPage)page);
            return true;
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

