/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConfiguration
implements Serializable {
    private static final long serialVersionUID = -3623617786905114255L;
    private static final String VERSION_UNKNOWN = "unknown";
    private String repositoryUrl = "<unknown>";
    private Map<String, ProductEntry> products = new HashMap<String, ProductEntry>();
    private List<String> platforms = new ArrayList<String>();
    private List<String> operatingSystems = new ArrayList<String>();
    private List<String> priorities = new ArrayList<String>();
    private List<String> severities = new ArrayList<String>();
    private List<String> bugStatus = new ArrayList<String>();
    private List<String> openStatusValues = new ArrayList<String>();
    private List<String> resolutionValues = new ArrayList<String>();
    private List<String> keywords = new ArrayList<String>();
    private List<String> versions = new ArrayList<String>();
    private List<String> components = new ArrayList<String>();
    private List<String> milestones = new ArrayList<String>();
    private String version = "unknown";

    public void addStatus(String status) {
        this.bugStatus.add(status);
    }

    public List<String> getStatusValues() {
        return this.bugStatus;
    }

    public void addResolution(String res) {
        this.resolutionValues.add(res);
    }

    public List<String> getResolutions() {
        return this.resolutionValues;
    }

    public void addProduct(String name) {
        if (!this.products.containsKey(name)) {
            ProductEntry product = new ProductEntry(name);
            this.products.put(name, product);
        }
    }

    public List<String> getProducts() {
        ArrayList<String> productList = new ArrayList<String>((Collection)this.products.keySet());
        Collections.sort(productList);
        return productList;
    }

    public List<String> getComponents(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getComponents();
        }
        return Collections.emptyList();
    }

    public List<String> getVersions(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getVersions();
        }
        return Collections.emptyList();
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    public List<String> getOSs() {
        return this.operatingSystems;
    }

    public void addOS(String os) {
        this.operatingSystems.add(os);
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public List<String> getPriorities() {
        return this.priorities;
    }

    public void addComponent(String product, String component) {
        ProductEntry entry;
        if (!this.components.contains(component)) {
            this.components.add(component);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addComponent(component);
    }

    public void addVersion(String product, String version) {
        ProductEntry entry;
        if (!this.versions.contains(version)) {
            this.versions.add(version);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addVersion(version);
    }

    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void addPlatform(String platform) {
        this.platforms.add(platform);
    }

    public void addPriority(String priority) {
        this.priorities.add(priority);
    }

    public void addSeverity(String severity) {
        this.severities.add(severity);
    }

    public void setInstallVersion(String version) {
        this.version = version;
    }

    public String getInstallVersion() {
        return this.version;
    }

    public void addTargetMilestone(String product, String target) {
        ProductEntry entry;
        if (!this.milestones.contains(target)) {
            this.milestones.add(target);
        }
        if ((entry = this.products.get(product)) == null) {
            entry = new ProductEntry(product);
            this.products.put(product, entry);
        }
        entry.addTargetMilestone(target);
    }

    public List<String> getTargetMilestones(String product) {
        ProductEntry entry = this.products.get(product);
        if (entry != null) {
            return entry.getTargetMilestones();
        }
        return Collections.emptyList();
    }

    public List<String> getOpenStatusValues() {
        return this.openStatusValues;
    }

    public void addOpenStatusValue(String value) {
        this.openStatusValues.add(value);
    }

    public List<String> getComponents() {
        return this.components;
    }

    public List<String> getTargetMilestones() {
        return this.milestones;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public List<String> getOptionValues(BugzillaReportElement element, String product) {
        switch (element) {
            case PRODUCT: {
                return this.getProducts();
            }
            case TARGET_MILESTONE: {
                return this.getTargetMilestones(product);
            }
            case BUG_STATUS: {
                return this.getStatusValues();
            }
            case VERSION: {
                return this.getVersions(product);
            }
            case COMPONENT: {
                return this.getComponents(product);
            }
            case REP_PLATFORM: {
                return this.getPlatforms();
            }
            case OP_SYS: {
                return this.getOSs();
            }
            case PRIORITY: {
                return this.getPriorities();
            }
            case BUG_SEVERITY: {
                return this.getSeverities();
            }
            case KEYWORDS: {
                return this.getKeywords();
            }
            case RESOLUTION: {
                return this.getResolutions();
            }
        }
        return new ArrayList<String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProductEntry
    implements Serializable {
        private static final long serialVersionUID = 4120139521246741120L;
        String productName;
        List<String> components = new ArrayList<String>();
        List<String> versions = new ArrayList<String>();
        List<String> milestones = new ArrayList<String>();

        ProductEntry(String name) {
            this.productName = name;
        }

        List<String> getComponents() {
            return this.components;
        }

        void addComponent(String componentName) {
            if (!this.components.contains(componentName)) {
                this.components.add(componentName);
            }
        }

        List<String> getVersions() {
            return this.versions;
        }

        void addVersion(String name) {
            if (!this.versions.contains(name)) {
                this.versions.add(name);
            }
        }

        List<String> getTargetMilestones() {
            return this.milestones;
        }

        void addTargetMilestone(String target) {
            this.milestones.add(target);
        }
    }
}

