/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.Locale;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTask;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.web.core.HtmlStreamTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxBugzillaQueryContentHandler
extends DefaultHandler {
    private String id;
    private String description = "";
    private String priority = AbstractTask.PriorityLevel.getDefault().toString();
    private String owner = "";
    private StringBuffer characters;
    private ITaskCollector collector;
    private String repositoryUrl;

    public SaxBugzillaQueryContentHandler(String repositoryUrl, ITaskCollector collector) {
        this.repositoryUrl = repositoryUrl;
        this.collector = collector;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
        BugzillaReportElement tag = BugzillaReportElement.UNKNOWN;
        try {
            tag = BugzillaReportElement.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
            switch (tag) {
                default: 
            }
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        String parsedText = HtmlStreamTokenizer.unescape((String)this.characters.toString());
        BugzillaReportElement tag = BugzillaReportElement.UNKNOWN;
        try {
            tag = BugzillaReportElement.valueOf(localName.trim().toUpperCase(Locale.ENGLISH));
            switch (tag) {
                case ID: {
                    this.id = parsedText;
                    break;
                }
                case PRIORITY: {
                    this.priority = parsedText;
                    break;
                }
                case ASSIGNED_TO: {
                    this.owner = parsedText;
                    break;
                }
                case BUG_STATUS: {
                    break;
                }
                case SHORT_DESC: {
                    this.description = parsedText;
                    break;
                }
                case SHORT_SHORT_DESC: {
                    this.description = parsedText;
                    break;
                }
                case LI: {
                    BugzillaTask task = new BugzillaTask(this.repositoryUrl, this.id, this.description);
                    task.setPriority(this.priority);
                    task.setOwner(this.owner);
                    this.collector.accept((AbstractTask)task);
                }
            }
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
    }
}

