/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaReportElement;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BugzillaCompareNode
implements IStreamContentAccessor,
IStructureComparator,
ITypedElement {
    private String key;
    private String value;
    private ArrayList<BugzillaCompareNode> nodeChildren;
    private Image image;

    public BugzillaCompareNode(String key, String value) {
        this(key, value, null);
    }

    public BugzillaCompareNode(String key, String value, Image image) {
        this.key = key;
        this.value = this.checkText(value);
        this.nodeChildren = null;
        this.image = image;
    }

    private String checkText(String newValue) {
        return newValue == null ? "" : newValue;
    }

    public Object[] getChildren() {
        return this.nodeChildren == null ? new Object[]{} : this.nodeChildren.toArray();
    }

    public void addChild(BugzillaCompareNode bugNode) {
        if (this.nodeChildren == null) {
            this.nodeChildren = new ArrayList();
        }
        this.nodeChildren.add(bugNode);
    }

    public InputStream getContents() throws CoreException {
        return new ByteArrayInputStream(this.getValue().getBytes());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = this.checkText(value);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image newImage) {
        this.image = newImage;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof BugzillaCompareNode) {
            BugzillaCompareNode bugNode = (BugzillaCompareNode)arg0;
            return this.getKey().equals(bugNode.getKey());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String getName() {
        return this.getKey();
    }

    public String getType() {
        return "bug report";
    }

    public static BugzillaCompareNode parseBugReport(RepositoryTaskData bug) {
        Image defaultImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEF_VIEW");
        BugzillaCompareNode topNode = new BugzillaCompareNode("Bug #" + bug.getId(), null, defaultImage);
        Image attributeImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        BugzillaCompareNode attributes = new BugzillaCompareNode("Attributes", null, attributeImage);
        for (RepositoryTaskAttribute attribute : bug.getAttributes()) {
            BugzillaCompareNode child = new BugzillaCompareNode(attribute.toString(), attribute.getValue(), defaultImage);
            attributes.addChild(child);
        }
        BugzillaCompareNode comments = new BugzillaCompareNode("Comments", null, defaultImage);
        for (TaskComment taskComment : bug.getComments()) {
            String bodyString = "Comment from " + taskComment.getAuthorName() + ":\n\n" + taskComment.getText();
            comments.addChild(new BugzillaCompareNode(taskComment.getAttributeValue(BugzillaReportElement.BUG_WHEN.getKeyString()), bodyString, defaultImage));
        }
        topNode.addChild(comments);
        topNode.addChild(new BugzillaCompareNode("New Comment", bug.getNewComment(), defaultImage));
        BugzillaCompareNode ccList = new BugzillaCompareNode("CC List", null, defaultImage);
        for (String cc : bug.getCc()) {
            ccList.addChild(new BugzillaCompareNode("CC", cc, defaultImage));
        }
        topNode.addChild(ccList);
        BugzillaCompareNode titleNode = new BugzillaCompareNode("BugReport Object", null, defaultImage);
        titleNode.addChild(topNode);
        return titleNode;
    }
}

