/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ConcurrentModificationException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.context.core.InteractionContextRelation;
import org.eclipse.mylyn.internal.context.ui.ColorMap;
import org.eclipse.mylyn.internal.context.ui.ContextUiPrefContstants;
import org.eclipse.mylyn.internal.context.ui.InterestDecorator;
import org.eclipse.mylyn.monitor.core.StatusHandler;

public class InterestDecoratorLightweight
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        if (ContextCorePlugin.getContextManager() != null && !ContextCorePlugin.getContextManager().isContextActive()) {
            return;
        }
        AbstractContextStructureBridge bridge = null;
        try {
            if (ContextCorePlugin.getDefault() == null) {
                return;
            }
            bridge = ContextCorePlugin.getDefault().getStructureBridge(element);
        }
        catch (ConcurrentModificationException concurrentModificationException) {}
        try {
            IInteractionElement node = null;
            if (element instanceof InteractionContextRelation) {
                decoration.setForegroundColor(ColorMap.RELATIONSHIP);
            } else if (element instanceof IInteractionElement) {
                node = (IInteractionElement)element;
            } else if (bridge != null && bridge.getContentType() != null) {
                node = ContextCorePlugin.getContextManager().getElement(bridge.getHandleIdentifier(element));
            }
            if (node != null) {
                decoration.setForegroundColor(InterestDecorator.getForegroundForElement(node));
                if (bridge != null && bridge.canBeLandmark(node.getHandleIdentifier()) && node.getInterest().isLandmark() && !node.getInterest().isPropagated() && !node.getInterest().isPredicted()) {
                    decoration.setFont(ContextUiPrefContstants.BOLD);
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((Throwable)e, (String)"decoration failed");
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

