/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskListInterestFilter
extends AbstractTaskListFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Object parent, Object child) {
        try {
            AbstractTask task;
            if (child instanceof ScheduledTaskContainer) {
                ScheduledTaskContainer dateRangeTaskContainer = (ScheduledTaskContainer)child;
                return this.isDateRangeInteresting(dateRangeTaskContainer);
            }
            if (child instanceof AbstractTask) {
                AbstractTask task2 = null;
                if (child instanceof AbstractTask) {
                    task2 = (AbstractTask)child;
                }
                if (task2 == null) return false;
                if (this.isUninteresting(parent, task2)) {
                    return false;
                }
                if (!this.isInteresting(parent, task2)) return false;
                return true;
            }
            if (!(child instanceof AbstractTaskContainer)) return false;
            Set children = ((AbstractTaskContainer)child).getChildren();
            if (children.size() == 0) {
                return false;
            }
            Iterator iterator = children.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!this.shouldAlwaysShow(child, task = (AbstractTask)iterator.next(), 10));
            return true;
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"interest filter failed", (boolean)false);
        }
        return false;
    }

    private boolean isDateRangeInteresting(ScheduledTaskContainer container) {
        return TasksUiPlugin.getTaskActivityManager().isWeekDay(container);
    }

    protected boolean isUninteresting(Object parent, AbstractTask task) {
        return !task.isActive() && !this.hasInterestingSubTasks(parent, task, 10) && (task.isCompleted() && !TaskActivityManager.getInstance().isCompletedToday(task) && !TaskListInterestFilter.hasChanges(parent, task) || TaskActivityManager.getInstance().isScheduledAfterThisWeek(task) && !TaskListInterestFilter.hasChanges(parent, task));
    }

    protected boolean isInteresting(Object parent, AbstractTask task) {
        return this.shouldAlwaysShow(parent, task, 10);
    }

    public boolean shouldAlwaysShow(Object parent, AbstractTask task, int depth) {
        return task.isActive() || TaskListInterestFilter.hasChanges(parent, task) || TaskActivityManager.getInstance().isCompletedToday(task) || TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task) || TaskListInterestFilter.isInterestingForThisWeek(parent, task) && !task.isCompleted() || TaskActivityManager.getInstance().isOverdue(task) || this.hasInterestingSubTasks(parent, task, depth) || "New Task".equals(task.getSummary());
    }

    private boolean hasInterestingSubTasks(Object parent, AbstractTask task, int depth) {
        if (depth > 0) {
            if (!TasksUiPlugin.getDefault().groupSubtasks((AbstractTaskContainer)task)) {
                return false;
            }
            if (task.getChildren() != null && task.getChildren().size() > 0) {
                for (AbstractTask subTask : task.getChildren()) {
                    if (!this.shouldAlwaysShow(parent, subTask, depth - 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean shouldShowInFocusedWorkweekDateContainer(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            if (!TasksUiPlugin.getTaskActivityManager().isWeekDay((ScheduledTaskContainer)parent)) {
                return false;
            }
            if (TaskActivityManager.getInstance().isOverdue(task) || task.isPastReminder()) {
                return true;
            }
            ScheduledTaskContainer container = (ScheduledTaskContainer)parent;
            Calendar previousCal = TasksUiPlugin.getTaskActivityManager().getActivityPrevious().getEnd();
            Calendar nextCal = TasksUiPlugin.getTaskActivityManager().getActivityNextWeek().getStart();
            if (container.getEnd().compareTo(previousCal) > 0 && container.getStart().compareTo(nextCal) < 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInterestingForThisWeek(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer) {
            return TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task);
        }
        return TasksUiPlugin.getTaskActivityManager().isScheduledForThisWeek(task) || TasksUiPlugin.getTaskActivityManager().isScheduledForToday(task) || task.isPastReminder() || TasksUiPlugin.getTaskActivityManager().isDueThisWeek(task);
    }

    public static boolean hasChanges(Object parent, AbstractTask task) {
        if (parent instanceof ScheduledTaskContainer && !TaskListInterestFilter.shouldShowInFocusedWorkweekDateContainer(parent, task)) {
            return false;
        }
        boolean result = false;
        if (task != null) {
            if (task.getLastReadTimeStamp() == null) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof ScheduledTaskContainer)) {
                return true;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                return true;
            }
            return TaskListInterestFilter.hasChangesHelper(parent, (AbstractTaskContainer)task);
        }
        return result;
    }

    private static boolean hasChangesHelper(Object parent, AbstractTaskContainer container) {
        boolean result = false;
        for (AbstractTask task : container.getChildren()) {
            if (task == null) continue;
            if (task.getLastReadTimeStamp() == null) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.OUTGOING) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && !(parent instanceof ScheduledTaskContainer)) {
                result = true;
                continue;
            }
            if (task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                result = true;
                continue;
            }
            if (task.getChildren() == null || task.getChildren().size() <= 0) continue;
            result = TaskListInterestFilter.hasChangesHelper(parent, (AbstractTaskContainer)task);
        }
        return result;
    }
}

