/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.context.ui.views.ActiveSearchView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LinkActiveSearchWithEditorAction
extends Action {
    public static final String ID = "org.eclipse.mylyn.ui.views.active.search.link";
    private static final String LABEL = "Link with Editor";
    private SelectionTracker selectionTracker = new SelectionTracker();
    private static LinkActiveSearchWithEditorAction INSTANCE;

    public LinkActiveSearchWithEditorAction() {
        super(LABEL, 2);
        INSTANCE = this;
        this.setId(ID);
        this.setImageDescriptor(ContextUiImages.LINK_WITH_EDITOR);
        this.setText(LABEL);
        this.setToolTipText(LABEL);
        ContextUiPlugin.getDefault().getPreferenceStore().setDefault(ID, true);
        this.update(ContextUiPlugin.getDefault().getPreferenceStore().getBoolean(ID));
    }

    public void run() {
        this.update(this.isChecked());
    }

    public void update(boolean on) {
        this.setChecked(on);
        ContextUiPlugin.getDefault().getPreferenceStore().setValue(ID, on);
        ISelectionService service = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        if (on) {
            service.addPostSelectionListener((ISelectionListener)this.selectionTracker);
        } else {
            service.removePostSelectionListener((ISelectionListener)this.selectionTracker);
        }
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
    }

    public static LinkActiveSearchWithEditorAction getDefault() {
        return INSTANCE;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    private static class SelectionTracker
    implements ISelectionListener {
        private SelectionTracker() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            try {
                if (selection instanceof TextSelection && part instanceof IEditorPart) {
                    ActiveSearchView view = ActiveSearchView.getFromActivePerspective();
                    if (view == null || !view.getViewer().getControl().isVisible()) {
                        return;
                    }
                    AbstractContextUiBridge bridge = ContextUiPlugin.getDefault().getUiBridgeForEditor((IEditorPart)part);
                    Object toSelect = bridge.getObjectForTextSelection((TextSelection)selection, (IEditorPart)part);
                    if (toSelect != null && view.getViewer().testFindItem(toSelect) != null) {
                        view.getViewer().setSelection((ISelection)new StructuredSelection(toSelect), true);
                    }
                }
            }
            catch (Throwable t) {
                StatusHandler.log((Throwable)t, (String)"Could not update package explorer");
            }
        }
    }
}

