/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.ui.internal.provisional.views.markers.MarkerEntry;
import org.eclipse.ui.internal.provisional.views.markers.api.MarkerItem;

public class MarkerInterestFilter
extends InterestFilter {
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof MarkerItem) {
            if (element.getClass().getSimpleName().equals("MarkerCategory")) {
                return true;
            }
            if (element instanceof MarkerEntry) {
                MarkerEntry entry = (MarkerEntry)element;
                return this.isInteresting(entry.getMarker(), viewer, parent);
            }
        }
        return false;
    }

    private boolean isImplicitlyInteresting(IMarker marker) {
        try {
            Object severity = marker.getAttribute("severity");
            return severity != null && severity.equals(2);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isInteresting(IMarker marker, Viewer viewer, Object parent) {
        if (this.isImplicitlyInteresting(marker)) {
            return true;
        }
        String handle = ContextCorePlugin.getDefault().getStructureBridge(marker.getResource().getFileExtension()).getHandleForOffsetInObject((Object)marker, 0);
        if (handle == null) {
            return false;
        }
        return super.select(viewer, parent, (Object)ContextCorePlugin.getContextManager().getElement(handle));
    }
}

