/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.java.ui.JavaStackTraceFileHyperlink;

public class JavaStackTraceHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final Pattern stackTracePattern = Pattern.compile("\\S*.{1}java:\\d*\\){1}", 2);

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        Matcher m = stackTracePattern.matcher(line);
        if (m.find()) {
            Region urlRegion = new Region(lineInfo.getOffset() + m.start(), m.end() - m.start());
            return new IHyperlink[]{new JavaStackTraceFileHyperlink((IRegion)urlRegion, m.group())};
        }
        return null;
    }
}

